/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.asyncapi.models.AaiSchema;
import io.apicurio.datamodels.cmd.commands.NewSchemaPropertyCommand;
import io.apicurio.datamodels.cmd.models.SimplifiedPropertyType;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.cmd.util.SimplifiedTypeUtil;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.IPropertySchema;
import io.apicurio.datamodels.core.models.common.Schema;
import java.util.ArrayList;
import java.util.List;

public class NewSchemaPropertyCommand_Aai20
extends NewSchemaPropertyCommand {
    NewSchemaPropertyCommand_Aai20() {
    }

    NewSchemaPropertyCommand_Aai20(Schema schema, String propertyName, String description, SimplifiedPropertyType newType) {
        super(schema, propertyName, description, newType);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewSchemaPropertyCommand_Aai20] Executing.", new Object[0]);
        this._created = false;
        AaiSchema schema = (AaiSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema)) {
            LoggerCompat.info("[NewSchemaPropertyCommand_Aai20] Schema is null.", new Object[0]);
            return;
        }
        if (ModelUtils.isDefined(schema.getProperty(this._propertyName))) {
            LoggerCompat.info("[NewSchemaPropertyCommand_Aai20] Property already exists.", new Object[0]);
            return;
        }
        AaiSchema property = schema.createPropertySchema(this._propertyName);
        if (ModelUtils.isDefined(this._description)) {
            property.description = this._description;
        }
        if (ModelUtils.isDefined(this._newType)) {
            this._setPropertyType((IPropertySchema)((Object)property));
        }
        schema.addProperty(this._propertyName, property);
        LoggerCompat.info("[NewSchemaPropertyCommand_Aai20] Property [%s] created successfully.", this._propertyName);
        this._created = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewSchemaPropertyCommand_Aai20] Reverting.", new Object[0]);
        if (!this._created) {
            return;
        }
        AaiSchema schema = (AaiSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        if (this.isNullOrUndefined(schema.getProperty(this._propertyName))) {
            return;
        }
        schema.removeProperty(this._propertyName);
        if (ModelUtils.isDefined(this._newType) && this._newType.required == Boolean.TRUE) {
            List<String> required = schema.required;
            required.remove(required.indexOf(this._propertyName));
        }
    }

    @Override
    protected void _setPropertyType(IPropertySchema prop) {
        SimplifiedTypeUtil.setSimplifiedType((AaiSchema)((Object)prop), this._newType);
        if (ModelUtils.isDefined(this._newType) && this._newType.required == Boolean.TRUE) {
            AaiSchema parent = (AaiSchema)((Node)((Object)prop)).parent();
            List<String> required = parent.required;
            if (this.isNullOrUndefined(required)) {
                required = new ArrayList<String>();
                NodeCompat.setProperty(parent, "required", required);
                this._nullRequired = true;
            }
            required.add(prop.getPropertyName());
        }
    }
}

