/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.commands.RenameSchemaDefinitionCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20SchemaDefinition;

public class RenameSchemaDefinitionCommand_20
extends RenameSchemaDefinitionCommand {
    RenameSchemaDefinitionCommand_20() {
    }

    RenameSchemaDefinitionCommand_20(String oldName, String newName) {
        super(oldName, newName);
    }

    @Override
    protected String _nameToReference(String name) {
        return "#/definitions/" + name;
    }

    @Override
    protected boolean _renameSchemaDefinition(OasDocument document, String fromName, String toName) {
        Oas20Document doc20 = (Oas20Document)document;
        if (this.isNullOrUndefined(doc20.definitions)) {
            return false;
        }
        if (ModelUtils.isDefined(doc20.definitions.getDefinition(toName))) {
            return false;
        }
        Oas20SchemaDefinition schemaDef = doc20.definitions.removeDefinition(fromName);
        schemaDef.rename(toName);
        doc20.definitions.addDefinition(toName, schemaDef);
        return true;
    }
}

