/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.cmd.commands.ReplaceNodeCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import java.util.Collection;
import java.util.LinkedHashMap;

public class ReplaceDocumentCommand
extends ReplaceNodeCommand<Document> {
    ReplaceDocumentCommand() {
    }

    ReplaceDocumentCommand(Document old, Document replacement) {
        super(old, replacement);
    }

    @Override
    protected void removeNode(Document doc, Document node) {
        switch (node.getDocumentType()) {
            case asyncapi2: {
                this.resetAai2xDocument((Aai20Document)node);
                break;
            }
            case openapi2: {
                this.resetOas2xDocument((Oas20Document)node);
                break;
            }
            case openapi3: {
                this.resetOas3xDocument((Oas30Document)node);
                break;
            }
        }
    }

    @Override
    protected void addNode(Document doc, Document node) {
    }

    @Override
    protected Document readNode(Document doc, Object node) {
        Library.readNode(node, doc);
        return doc;
    }

    private void resetOas2xDocument(Oas20Document doc) {
        doc.host = null;
        doc.basePath = null;
        doc.schemes = null;
        doc.consumes = null;
        doc.produces = null;
        doc.definitions = null;
        doc.parameters = null;
        doc.responses = null;
        doc.securityDefinitions = null;
        this.resetOasDocument(doc);
    }

    private void resetOas3xDocument(Oas30Document doc) {
        doc.servers = null;
        doc.components = null;
        this.resetOasDocument(doc);
    }

    private void resetAai2xDocument(Aai20Document doc) {
        doc.id = null;
        doc.channels = new LinkedHashMap();
        doc.servers = null;
        doc.components = null;
        doc.defaultContentType = null;
        this.resetDocument(doc);
    }

    private void resetOasDocument(OasDocument doc) {
        doc.paths = null;
        doc.security = null;
        this.resetDocument(doc);
    }

    private void resetDocument(Document doc) {
        doc.info = null;
        doc.tags = null;
        doc.externalDocs = null;
        Collection<Extension> extensions = doc.getExtensions();
        if (ModelUtils.isDefined(extensions)) {
            extensions.forEach(ext -> doc.removeExtension(ext.name));
        }
        doc.getExtraPropertyNames().forEach(pname -> doc.removeExtraProperty((String)pname));
    }
}

