/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.ReplaceNodeCommand;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasPathItem;

public class ReplacePathItemCommand
extends ReplaceNodeCommand<OasPathItem> {
    public String _pathName;

    ReplacePathItemCommand() {
    }

    ReplacePathItemCommand(OasPathItem old, OasPathItem replacement) {
        super(old, replacement);
        this._pathName = replacement.getPath();
    }

    @Override
    protected void removeNode(Document doc, OasPathItem node) {
        OasDocument odoc = (OasDocument)doc;
        odoc.paths.removePathItem(node.getPath());
    }

    @Override
    protected void addNode(Document doc, OasPathItem node) {
        OasDocument odoc = (OasDocument)doc;
        node._ownerDocument = odoc;
        node._parent = odoc.paths;
        odoc.paths.addPathItem(this._pathName, node);
    }

    @Override
    protected OasPathItem readNode(Document doc, Object node) {
        OasDocument odoc = (OasDocument)doc;
        OasPathItem pathItem = odoc.paths.createPathItem(this._pathName);
        Library.readNode(node, pathItem);
        return pathItem;
    }
}

