/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.name;

import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.IExample;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.validation.rules.invalid.name.OasInvalidPropertyNameRule;
import io.apicurio.datamodels.core.visitors.OperationFinder;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Example;
import io.apicurio.datamodels.openapi.v2.models.Oas20Operation;
import java.util.ArrayList;
import java.util.List;

public class OasUnmatchedExampleTypeRule
extends OasInvalidPropertyNameRule {
    public OasUnmatchedExampleTypeRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private static Operation findParentOperation(Node node) {
        OperationFinder finder = new OperationFinder();
        VisitorUtil.visitTree(node, finder, TraverserDirection.up);
        return finder.found;
    }

    @Override
    public void visitExample(IExample node) {
        Oas20Example example20 = (Oas20Example)node;
        Oas20Document doc = (Oas20Document)example20.ownerDocument();
        List<String> produces = doc.produces;
        Oas20Operation operation = (Oas20Operation)OasUnmatchedExampleTypeRule.findParentOperation(example20);
        if (this.hasValue(operation.produces)) {
            produces = operation.produces;
        }
        if (!this.hasValue(produces)) {
            produces = new ArrayList<String>();
        }
        List<String> ctypes = example20.getExampleContentTypes();
        for (String ct : ctypes) {
            this.reportIfInvalid(produces.indexOf(ct) != -1, example20, "produces", this.map("contentType", ct));
        }
    }
}

