/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.ispn;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IDataStoreComponent;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;

public class InfinispanDataStoreComponent
implements IDataStoreComponent {
    private static final String DEFAULT_CACHE_CONTAINER = "java:jboss/infinispan/container/apiman-gateway";
    private static final String DEFAULT_CACHE = "data-store";
    private String cacheContainer = "java:jboss/infinispan/container/apiman-gateway";
    private String cacheName = "data-store";
    private Cache<Object, Object> cache;

    public InfinispanDataStoreComponent() {
    }

    public InfinispanDataStoreComponent(Map<String, String> config) {
        if (config.containsKey("cache-container")) {
            this.cacheContainer = config.get("cache-container");
        }
        if (config.containsKey("cache")) {
            this.cacheName = config.get("cache");
        }
    }

    public <T> boolean hasProperty(String namespace, String propertyName) {
        QName qname = new QName(namespace, propertyName);
        return this.getCache().containsKey((Object)qname);
    }

    public <T> void getProperty(String namespace, String propertyName, T defaultValue, IAsyncResultHandler<T> handler) {
        QName qname = new QName(namespace, propertyName);
        if (this.getCache().containsKey((Object)qname)) {
            try {
                Object rval = this.getCache().get((Object)qname);
                handler.handle((Object)AsyncResultImpl.create((Object)rval));
            }
            catch (Exception e) {
                handler.handle((Object)AsyncResultImpl.create((Throwable)e));
            }
        } else {
            handler.handle((Object)AsyncResultImpl.create(defaultValue));
        }
    }

    public <T> void setProperty(String namespace, String propertyName, T value, IAsyncResultHandler<T> handler) {
        this.setProperty(namespace, propertyName, value, null, handler);
    }

    public <T> void setProperty(String namespace, String propertyName, T value, Long expiration, IAsyncResultHandler<T> handler) {
        QName qname = new QName(namespace, propertyName);
        try {
            Object oldValue = null;
            oldValue = expiration == null ? this.getCache().put((Object)qname, value) : this.getCache().put((Object)qname, value, expiration.longValue(), TimeUnit.SECONDS);
            handler.handle((Object)AsyncResultImpl.create((Object)oldValue));
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    public <T> void clearProperty(String namespace, String propertyName, IAsyncResultHandler<T> handler) {
        QName qname = new QName(namespace, propertyName);
        try {
            Object oldValue = this.getCache().remove((Object)qname);
            handler.handle((Object)AsyncResultImpl.create((Object)oldValue));
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    private Cache<Object, Object> getCache() {
        if (this.cache != null) {
            return this.cache;
        }
        try {
            InitialContext ic = new InitialContext();
            CacheContainer container = (CacheContainer)ic.lookup(this.cacheContainer);
            this.cache = container.getCache(this.cacheName);
            return this.cache;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }
}

