/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.ispn;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.components.rate.RateLimitResponse;
import io.apiman.gateway.engine.rates.RateBucketPeriod;
import io.apiman.gateway.engine.rates.RateLimiterBucket;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;

public class InfinispanRateLimiterComponent
implements IRateLimiterComponent {
    private static final String DEFAULT_CACHE_CONTAINER = "java:jboss/infinispan/container/apiman-gateway";
    private static final String DEFAULT_CACHE = "rate-limiter";
    private String cacheContainer = "java:jboss/infinispan/container/apiman-gateway";
    private String cacheName = "rate-limiter";
    private Cache<Object, Object> cache;
    private Object mutex = new Object();

    public InfinispanRateLimiterComponent() {
    }

    public InfinispanRateLimiterComponent(Map<String, String> config) {
        if (config.containsKey("cache-container")) {
            this.cacheContainer = config.get("cache-container");
        }
        if (config.containsKey("cache")) {
            this.cacheName = config.get("cache");
        }
    }

    private Cache<Object, Object> getCache() {
        if (this.cache != null) {
            return this.cache;
        }
        try {
            InitialContext ic = new InitialContext();
            CacheContainer container = (CacheContainer)ic.lookup(this.cacheContainer);
            this.cache = container.getCache(this.cacheName);
            return this.cache;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(String bucketId, RateBucketPeriod period, int limit, IAsyncResultHandler<RateLimitResponse> handler) {
        RateLimiterBucket bucket = null;
        Object object = this.mutex;
        synchronized (object) {
            bucket = (RateLimiterBucket)this.getCache().get((Object)bucketId);
            if (bucket == null) {
                bucket = new RateLimiterBucket();
                this.getCache().put((Object)bucketId, (Object)bucket);
            }
            bucket.resetIfNecessary(period);
            RateLimitResponse response = new RateLimitResponse();
            if (bucket.getCount() >= limit) {
                response.setAccepted(false);
            } else {
                bucket.setCount(bucket.getCount() + 1);
                bucket.setLast(System.currentTimeMillis());
                response.setAccepted(true);
            }
            int reset = (int)(bucket.getResetMillis(period) / 1000L);
            response.setReset((long)reset);
            response.setRemaining(limit - bucket.getCount());
            handler.handle((Object)AsyncResultImpl.create((Object)response));
            this.getCache().put((Object)bucketId, (Object)bucket);
        }
    }
}

