/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.coreinterfaces.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface VerificationResult {
    public boolean isSuccess();

    public List<String> getErrors();

    public static VerificationResult success() {
        return new VerificationResult(){

            @Override
            public boolean isSuccess() {
                return true;
            }

            @Override
            public List<String> getErrors() {
                return Collections.emptyList();
            }
        };
    }

    public static VerificationResult failure(final String ... errors) {
        return new VerificationResult(){

            @Override
            public boolean isSuccess() {
                return false;
            }

            @Override
            public List<String> getErrors() {
                return Collections.unmodifiableList(errors != null ? Arrays.asList(errors) : Collections.emptyList());
            }
        };
    }
}

