/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection.pgoutput;

import io.debezium.connector.postgresql.connection.AbstractColumnValue;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.util.Strings;
import java.math.BigDecimal;

class PgOutputColumnValue
extends AbstractColumnValue<String> {
    private String value;

    PgOutputColumnValue(String value) {
        this.value = value;
    }

    @Override
    public String getRawValue() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public Boolean asBoolean() {
        return "t".equalsIgnoreCase(this.value);
    }

    @Override
    public Integer asInteger() {
        return Integer.valueOf(this.value);
    }

    @Override
    public Long asLong() {
        return Long.valueOf(this.value);
    }

    @Override
    public Float asFloat() {
        return Float.valueOf(this.value);
    }

    @Override
    public Double asDouble() {
        return Double.valueOf(this.value);
    }

    public SpecialValueDecimal asDecimal() {
        if ("NaN".equals(this.value)) {
            return SpecialValueDecimal.NOT_A_NUMBER;
        }
        return new SpecialValueDecimal(new BigDecimal(this.value));
    }

    @Override
    public byte[] asByteArray() {
        return Strings.hexStringToByteArray((String)this.value.substring(2));
    }
}

