/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractBuildSupportMojo;
import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.access.AuthConfigList;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.ImagePullManager;
import io.fabric8.maven.docker.service.JibBuildService;
import io.fabric8.maven.docker.service.RegistryService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.DockerFileUtil;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="build", defaultPhase=LifecyclePhase.INSTALL, requiresDependencyResolution=ResolutionScope.TEST)
public class BuildMojo
extends AbstractBuildSupportMojo {
    public static final String DMP_PLUGIN_DESCRIPTOR = "META-INF/maven/io.fabric8/dmp-plugin";
    public static final String DOCKER_EXTRA_DIR = "docker-extra";
    @Parameter(property="docker.skip.build", defaultValue="false")
    protected boolean skipBuild;
    @Parameter(property="docker.name", defaultValue="")
    protected String name;
    @Parameter(property="docker.buildArchiveOnly", defaultValue="false")
    protected String buildArchiveOnly;
    @Parameter(property="docker.skip.tag", defaultValue="false")
    protected boolean skipTag;

    @Override
    protected void executeInternal(ServiceHub hub) throws IOException, MojoExecutionException {
        if (this.skipBuild) {
            return;
        }
        this.executeBuildPlugins();
        for (ImageConfiguration imageConfig : this.getResolvedImages()) {
            this.processImageConfig(hub, imageConfig);
        }
    }

    protected void buildAndTag(ServiceHub hub, ImageConfiguration imageConfig) throws MojoExecutionException, IOException {
        EnvUtil.storeTimestamp(this.getBuildTimestampFile(), this.getBuildTimestamp());
        BuildService.BuildContext buildContext = this.getBuildContext();
        ImagePullManager pullManager = this.getImagePullManager(this.determinePullPolicy(imageConfig.getBuildConfiguration()), this.autoPull);
        this.proceedWithBuildProcess(hub, buildContext, imageConfig, pullManager);
    }

    private void proceedWithBuildProcess(ServiceHub hub, BuildService.BuildContext buildContext, ImageConfiguration imageConfig, ImagePullManager pullManager) throws MojoExecutionException, IOException {
        if (Boolean.TRUE.equals(this.jib)) {
            this.proceedWithJibBuild(hub, buildContext, imageConfig);
        } else {
            this.proceedWithDockerBuild(hub, buildContext, imageConfig, pullManager);
        }
    }

    private void proceedWithJibBuild(ServiceHub hub, BuildService.BuildContext buildContext, ImageConfiguration imageConfig) throws MojoExecutionException {
        this.log.info("Building Container image with [[B]]JIB(Java Image Builder)[[B]] mode", new Object[0]);
        new JibBuildService(hub, this.createMojoParameters(), this.log).build(this.jibImageFormat, imageConfig, buildContext.getRegistryConfig());
    }

    private void proceedWithDockerBuild(ServiceHub hub, BuildService.BuildContext buildContext, ImageConfiguration imageConfig, ImagePullManager pullManager) throws MojoExecutionException, IOException {
        BuildService buildService = hub.getBuildService();
        File buildArchiveFile = buildService.buildArchive(imageConfig, buildContext, this.resolveBuildArchiveParameter());
        if (Boolean.FALSE.equals(this.shallBuildArchiveOnly())) {
            if (imageConfig.isBuildX()) {
                hub.getBuildXService().build(this.createProjectPaths(), imageConfig, null, this.getAuthConfig(imageConfig), buildArchiveFile);
            } else {
                buildService.buildImage(imageConfig, pullManager, buildContext, buildArchiveFile);
                if (!this.skipTag) {
                    buildService.tagImage(imageConfig);
                }
            }
        }
    }

    private AuthConfigList getAuthConfig(ImageConfiguration imageConfig) throws MojoExecutionException {
        RegistryService.RegistryConfig registryConfig = this.getRegistryConfig(this.pullRegistry);
        ImageName imageName = new ImageName(imageConfig.getName());
        String configuredRegistry = EnvUtil.firstRegistryOf(imageName.getRegistry(), imageConfig.getRegistry(), registryConfig.getRegistry());
        AuthConfig authConfig = registryConfig.createAuthConfig(false, imageName.getUser(), configuredRegistry);
        AuthConfigList authConfigList = new AuthConfigList();
        if (authConfig != null) {
            authConfigList.addAuthConfig(authConfig);
        }
        BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
        Set<String> fromRegistries = this.getRegistriesForPull(buildConfig);
        for (String fromRegistry : fromRegistries) {
            AuthConfig additionalAuth;
            if (StringUtils.isNotBlank((CharSequence)configuredRegistry) && configuredRegistry.equalsIgnoreCase(fromRegistry) || (additionalAuth = (registryConfig = this.getRegistryConfig(fromRegistry)).createAuthConfig(false, imageName.getUser(), fromRegistry)) == null) continue;
            authConfigList.addAuthConfig(additionalAuth);
        }
        return authConfigList;
    }

    private Set<String> getRegistriesForPull(BuildImageConfiguration buildConfig) {
        HashSet<String> registries = new HashSet<String>();
        List<String> fromImages = this.extractBaseFromDockerfile(buildConfig);
        for (String fromImage : fromImages) {
            ImageName imageName = new ImageName(fromImage);
            if (!imageName.hasRegistry()) continue;
            registries.add(imageName.getRegistry());
        }
        return registries;
    }

    private List<String> extractBaseFromDockerfile(BuildImageConfiguration buildConfig) {
        List<String> fromImage;
        if (buildConfig.getDockerFile() == null || !buildConfig.getDockerFile().exists()) {
            if (buildConfig.getFrom() != null && !buildConfig.getFrom().isEmpty()) {
                return Collections.singletonList(buildConfig.getFrom());
            }
            return Collections.emptyList();
        }
        try {
            MojoParameters mojoParameters = this.createMojoParameters();
            File fullDockerFilePath = buildConfig.getAbsoluteDockerFilePath(mojoParameters);
            fromImage = DockerFileUtil.extractBaseImages(fullDockerFilePath, DockerFileUtil.createInterpolator(mojoParameters, buildConfig.getFilter()), buildConfig.getArgs());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return fromImage;
    }

    @Override
    protected Date getReferenceDate() {
        return new Date();
    }

    private String resolveBuildArchiveParameter() {
        if (!(this.buildArchiveOnly == null || this.buildArchiveOnly.isEmpty() || this.buildArchiveOnly.equalsIgnoreCase("false") || this.buildArchiveOnly.equalsIgnoreCase("true"))) {
            return this.buildArchiveOnly;
        }
        return null;
    }

    private boolean shallBuildArchiveOnly() {
        if (this.buildArchiveOnly != null && !this.buildArchiveOnly.isEmpty() && (this.buildArchiveOnly.equalsIgnoreCase("false") || this.buildArchiveOnly.equalsIgnoreCase("true"))) {
            return Boolean.parseBoolean(this.buildArchiveOnly);
        }
        return false;
    }

    private String determinePullPolicy(BuildImageConfiguration buildConfig) {
        return buildConfig != null && buildConfig.getImagePullPolicy() != null ? buildConfig.getImagePullPolicy() : this.imagePullPolicy;
    }

    private void processImageConfig(ServiceHub hub, ImageConfiguration aImageConfig) throws IOException, MojoExecutionException {
        BuildImageConfiguration buildConfig = aImageConfig.getBuildConfiguration();
        if (buildConfig != null) {
            if (buildConfig.skip() || this.shouldSkipPom()) {
                this.log.info("%s : Skipped building", aImageConfig.getDescription());
            } else {
                this.buildAndTag(hub, aImageConfig);
            }
        }
    }

    private void executeBuildPlugins() {
        try {
            Enumeration<URL> dmpPlugins = Thread.currentThread().getContextClassLoader().getResources(DMP_PLUGIN_DESCRIPTOR);
            while (dmpPlugins.hasMoreElements()) {
                URL dmpPlugin = dmpPlugins.nextElement();
                File outputDir = this.getAndEnsureOutputDirectory();
                this.processDmpPluginDescription(dmpPlugin, outputDir);
            }
        }
        catch (IOException e) {
            this.log.error("Cannot load dmp-plugins from %s", DMP_PLUGIN_DESCRIPTOR);
        }
    }

    private void processDmpPluginDescription(URL pluginDesc, File outputDir) throws IOException {
        String line = null;
        try (LineNumberReader reader2 = new LineNumberReader(new InputStreamReader(pluginDesc.openStream(), "UTF8"));){
            line = reader2.readLine();
            while (line != null) {
                if (line.matches("^\\s*#")) continue;
                this.callBuildPlugin(outputDir, line);
                line = reader2.readLine();
            }
        }
        catch (ClassNotFoundException reader2) {
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.log.verbose(Logger.LogVerboseCategory.BUILD, "Found dmp-plugin %s but could not be called : %s", line, e.getMessage());
        }
    }

    private File getAndEnsureOutputDirectory() {
        File outputDir = new File(new File(this.project.getBuild().getDirectory()), DOCKER_EXTRA_DIR);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        return outputDir;
    }

    private void callBuildPlugin(File outputDir, String buildPluginClass) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> buildPlugin = Class.forName(buildPluginClass);
        try {
            Method method = buildPlugin.getMethod("addExtraFiles", File.class);
            method.invoke(null, outputDir);
            this.log.info("Extra files from %s extracted", buildPluginClass);
        }
        catch (NoSuchMethodException exp) {
            this.log.verbose(Logger.LogVerboseCategory.BUILD, "Build plugin %s does not support 'addExtraFiles' method", buildPluginClass);
        }
    }
}

