/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.wait;

import io.fabric8.maven.docker.wait.PreconditionFailedException;
import io.fabric8.maven.docker.wait.WaitChecker;
import io.fabric8.maven.docker.wait.WaitTimeoutException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class WaitUtil {
    private static final long DEFAULT_MAX_WAIT = 10000L;
    private static final long WAIT_RETRY_WAIT = 500L;

    private WaitUtil() {
    }

    public static long wait(int wait, Callable<Void> callable) throws ExecutionException, WaitTimeoutException {
        long now = System.currentTimeMillis();
        if (wait > 0) {
            try {
                FutureTask<Void> task = new FutureTask<Void>(callable);
                task.run();
                task.get(wait, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                throw new WaitTimeoutException("timed out waiting for execution to complete: " + e, WaitUtil.delta(now));
            }
        }
        return WaitUtil.delta(now);
    }

    public static long wait(Precondition precondition, int maxWait, WaitChecker ... checkers) throws WaitTimeoutException, PreconditionFailedException {
        return WaitUtil.wait(precondition, maxWait, Arrays.asList(checkers));
    }

    public static long wait(Precondition precondition, int maxWait, Iterable<WaitChecker> checkers) throws WaitTimeoutException, PreconditionFailedException {
        long max = maxWait > 0 ? (long)maxWait : 10000L;
        long now = System.currentTimeMillis();
        try {
            do {
                if (!precondition.isOk()) {
                    if (WaitUtil.check(checkers)) {
                        long l = WaitUtil.delta(now);
                        return l;
                    }
                    throw new PreconditionFailedException("Precondition failed", WaitUtil.delta(now));
                }
                if (WaitUtil.check(checkers)) {
                    long l = WaitUtil.delta(now);
                    return l;
                }
                WaitUtil.sleep(500L);
            } while (WaitUtil.delta(now) < max);
            throw new WaitTimeoutException("No checker finished successfully", WaitUtil.delta(now));
        }
        finally {
            precondition.cleanup();
            WaitUtil.cleanup(checkers);
        }
    }

    private static boolean check(Iterable<WaitChecker> checkers) {
        for (WaitChecker checker : checkers) {
            if (!checker.check()) continue;
            return true;
        }
        return false;
    }

    private static void cleanup(Iterable<WaitChecker> checkers) {
        for (WaitChecker checker : checkers) {
            checker.cleanUp();
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static long delta(long now) {
        return System.currentTimeMillis() - now;
    }

    public static interface Precondition {
        public boolean isOk();

        public void cleanup();
    }
}

