/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import com.google.gson.JsonObject;
import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.access.util.ExternalCommand;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.JsonFactory;
import io.fabric8.maven.docker.util.Logger;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class CredentialHelperClient {
    static final String SECRET_KEY = "Secret";
    static final String USERNAME_KEY = "Username";
    static final String TOKEN_USERNAME = "<token>";
    private final String credentialHelperName;
    private final Logger log;

    public CredentialHelperClient(Logger log, String credentialsStore) {
        this.log = log;
        this.credentialHelperName = "docker-credential-" + credentialsStore;
    }

    public String getName() {
        return this.credentialHelperName;
    }

    public String getVersion() {
        try {
            return new VersionCommand().getVersion();
        }
        catch (IOException e) {
            return null;
        }
    }

    public AuthConfig getAuthConfig(String registryToLookup) throws MojoExecutionException {
        try {
            JsonObject creds = new GetCommand().getCredentialNode(registryToLookup);
            if (creds == null) {
                creds = new GetCommand().getCredentialNode(EnvUtil.ensureRegistryHttpUrl(registryToLookup));
            }
            return this.toAuthConfig(creds);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error getting the credentials for " + registryToLookup + " from the configured credential helper", (Exception)e);
        }
    }

    AuthConfig toAuthConfig(JsonObject credential) {
        if (credential == null) {
            return null;
        }
        String password = credential.get(SECRET_KEY).getAsString();
        String userKey = credential.get(USERNAME_KEY).getAsString();
        if (TOKEN_USERNAME.equals(userKey)) {
            return new AuthConfig(null, null, null, null, password);
        }
        return new AuthConfig(userKey, password, null, null);
    }

    private class GetCommand
    extends ExternalCommand {
        private final List<String> reply;

        GetCommand() {
            super(CredentialHelperClient.this.log);
            this.reply = new LinkedList<String>();
        }

        @Override
        protected String[] getArgs() {
            return new String[]{CredentialHelperClient.this.credentialHelperName, "get"};
        }

        @Override
        protected void processLine(String line) {
            this.reply.add(line);
        }

        public JsonObject getCredentialNode(String registryToLookup) throws IOException {
            try {
                this.execute(registryToLookup);
            }
            catch (IOException ex) {
                if (this.getStatusCode() == 1) {
                    return null;
                }
                throw ex;
            }
            String joinedReply = String.join((CharSequence)"\n", this.reply);
            JsonObject credentials = JsonFactory.newJsonObject(joinedReply);
            if (!credentials.has(CredentialHelperClient.SECRET_KEY) || !credentials.has(CredentialHelperClient.USERNAME_KEY)) {
                return null;
            }
            return credentials;
        }
    }

    private class VersionCommand
    extends ExternalCommand {
        private String version;

        VersionCommand() {
            super(CredentialHelperClient.this.log);
        }

        @Override
        protected String[] getArgs() {
            return new String[]{CredentialHelperClient.this.credentialHelperName, "version"};
        }

        @Override
        protected void processLine(String line) {
            this.log.verbose(Logger.LogVerboseCategory.BUILD, "Credentials helper reply for \"%s\" is %s", CredentialHelperClient.this.credentialHelperName, line);
            this.version = line;
        }

        public String getVersion() throws IOException {
            this.execute();
            return this.version;
        }
    }
}

