/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.api.handlers.http;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.HttpServerRequest;

public class HttpServiceResponseHandler
implements Handler<HttpClientResponse> {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpServiceResponseHandler.class);
    final HttpClient httpClient;
    final HttpServerRequest request;

    public HttpServiceResponseHandler(HttpClient httpClient, HttpServerRequest request) {
        this.httpClient = httpClient;
        this.request = request;
    }

    public void handle(HttpClientResponse clientResponse) {
        this.request.response().setStatusCode(clientResponse.statusCode());
        this.request.response().headers().set(clientResponse.headers());
        this.request.response().setChunked(true);
        clientResponse.dataHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer data) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxying response body:" + data);
                }
                HttpServiceResponseHandler.this.request.response().write(data);
            }
        });
        clientResponse.endHandler((Handler)new VoidHandler(){

            public void handle() {
                HttpServiceResponseHandler.this.request.response().end();
                HttpServiceResponseHandler.this.httpClient.close();
            }
        });
    }
}

