package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JSONSchemaPropsOrBoolBuilder extends JSONSchemaPropsOrBoolFluentImpl<JSONSchemaPropsOrBoolBuilder> implements VisitableBuilder<JSONSchemaPropsOrBool,JSONSchemaPropsOrBoolBuilder> {

    JSONSchemaPropsOrBoolFluent<?> fluent;
    Boolean validationEnabled;

    public JSONSchemaPropsOrBoolBuilder() { 
        this(true);
    }


    public JSONSchemaPropsOrBoolBuilder(Boolean validationEnabled) { 
        this(new JSONSchemaPropsOrBool(), validationEnabled);
    }


    public JSONSchemaPropsOrBoolBuilder(JSONSchemaPropsOrBoolFluent<?> fluent) { 
        this(fluent, true);
    }


    public JSONSchemaPropsOrBoolBuilder(JSONSchemaPropsOrBoolFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new JSONSchemaPropsOrBool(), validationEnabled);
    }


    public JSONSchemaPropsOrBoolBuilder(JSONSchemaPropsOrBoolFluent<?> fluent,JSONSchemaPropsOrBool instance) { 
        this(fluent, instance, true);
    }


    public JSONSchemaPropsOrBoolBuilder(JSONSchemaPropsOrBoolFluent<?> fluent,JSONSchemaPropsOrBool instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAllows(instance.getAllows()); 
        fluent.withSchema(instance.getSchema()); 
        this.validationEnabled = validationEnabled; 
    }


    public JSONSchemaPropsOrBoolBuilder(JSONSchemaPropsOrBool instance) { 
        this(instance,true);
    }


    public JSONSchemaPropsOrBoolBuilder(JSONSchemaPropsOrBool instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAllows(instance.getAllows()); 
        this.withSchema(instance.getSchema()); 
        this.validationEnabled = validationEnabled; 
    }


    public JSONSchemaPropsOrBool build() {
        JSONSchemaPropsOrBool buildable = new JSONSchemaPropsOrBool(fluent.isAllows(),fluent.getSchema());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JSONSchemaPropsOrBoolBuilder that = (JSONSchemaPropsOrBoolBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
