package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.StringBuffer;

public class CustomResourceDefinitionSpecFluentImpl<A extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent<A> {

    private List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder> additionalPrinterColumns =  new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder>();
    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder conversion;
    private String group;
    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder names;
    private Boolean preserveUnknownFields;
    private String scope;
    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder subresources;
    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder validation;
    private String version;
    private List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder> versions =  new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder>();

    public CustomResourceDefinitionSpecFluentImpl() { 
    }


    public CustomResourceDefinitionSpecFluentImpl(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec instance) { 
        this.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns()); 
        this.withConversion(instance.getConversion()); 
        this.withGroup(instance.getGroup()); 
        this.withNames(instance.getNames()); 
        this.withPreserveUnknownFields(instance.getPreserveUnknownFields()); 
        this.withScope(instance.getScope()); 
        this.withSubresources(instance.getSubresources()); 
        this.withValidation(instance.getValidation()); 
        this.withVersion(instance.getVersion()); 
        this.withVersions(instance.getVersions()); 
    }


    public A addToAdditionalPrinterColumns(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
        if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder>();}
        io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(index >= 0 ? index : _visitables.get("additionalPrinterColumns").size(), builder);this.additionalPrinterColumns.add(index >= 0 ? index : additionalPrinterColumns.size(), builder); return (A)this;
    }

    public A setToAdditionalPrinterColumns(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
        if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder>();}
        io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);
        if (index < 0 || index >= _visitables.get("additionalPrinterColumns").size()) { _visitables.get("additionalPrinterColumns").add(builder); } else { _visitables.get("additionalPrinterColumns").set(index, builder);}
        if (index < 0 || index >= additionalPrinterColumns.size()) { additionalPrinterColumns.add(builder); } else { additionalPrinterColumns.set(index, builder);}
         return (A)this;
    }

    public A addToAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition... items) {
        if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder>();}
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(builder);this.additionalPrinterColumns.add(builder);} return (A)this;
    }

    public A addAllToAdditionalPrinterColumns(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition> items) {
        if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder>();}
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(builder);this.additionalPrinterColumns.add(builder);} return (A)this;
    }

    public A removeFromAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition... items) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").remove(builder);if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.remove(builder);}} return (A)this;
    }

    public A removeAllFromAdditionalPrinterColumns(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition> items) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").remove(builder);if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAdditionalPrinterColumns(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder> predicate) {
        if (additionalPrinterColumns == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder> each = additionalPrinterColumns.iterator();
        final List visitables = _visitables.get("additionalPrinterColumns");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAdditionalPrinterColumns instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition> getAdditionalPrinterColumns() {
        return build(additionalPrinterColumns);
    }

    public List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition> buildAdditionalPrinterColumns() {
        return build(additionalPrinterColumns);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition buildAdditionalPrinterColumn(int index) {
        return this.additionalPrinterColumns.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition buildFirstAdditionalPrinterColumn() {
        return this.additionalPrinterColumns.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition buildLastAdditionalPrinterColumn() {
        return this.additionalPrinterColumns.get(additionalPrinterColumns.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition buildMatchingAdditionalPrinterColumn(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder item: additionalPrinterColumns) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAdditionalPrinterColumn(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder item: additionalPrinterColumns) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAdditionalPrinterColumns(List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition> additionalPrinterColumns) {
        if (this.additionalPrinterColumns != null) { _visitables.get("additionalPrinterColumns").removeAll(this.additionalPrinterColumns);}
        if (additionalPrinterColumns != null) {this.additionalPrinterColumns = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder>(); for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item : additionalPrinterColumns){this.addToAdditionalPrinterColumns(item);}} else { this.additionalPrinterColumns = null;} return (A) this;
    }

    public A withAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition... additionalPrinterColumns) {
        if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.clear();}
        if (additionalPrinterColumns != null) {for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item :additionalPrinterColumns){ this.addToAdditionalPrinterColumns(item);}} return (A) this;
    }

    public Boolean hasAdditionalPrinterColumns() {
        return additionalPrinterColumns != null && !additionalPrinterColumns.isEmpty();
    }

    public CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumn() {
        return new AdditionalPrinterColumnsNestedImpl();
    }

    public CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumnLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
        return new AdditionalPrinterColumnsNestedImpl(-1, item);
    }

    public CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> setNewAdditionalPrinterColumnLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
        return new AdditionalPrinterColumnsNestedImpl(index, item);
    }

    public CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> editAdditionalPrinterColumn(int index) {
        if (additionalPrinterColumns.size() <= index) throw new RuntimeException("Can't edit additionalPrinterColumns. Index exceeds size.");
        return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
    }

    public CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> editFirstAdditionalPrinterColumn() {
        if (additionalPrinterColumns.size() == 0) throw new RuntimeException("Can't edit first additionalPrinterColumns. The list is empty.");
        return setNewAdditionalPrinterColumnLike(0, buildAdditionalPrinterColumn(0));
    }

    public CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> editLastAdditionalPrinterColumn() {
        int index = additionalPrinterColumns.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last additionalPrinterColumns. The list is empty.");
        return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
    }

    public CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> editMatchingAdditionalPrinterColumn(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<additionalPrinterColumns.size();i++) { 
        if (predicate.apply(additionalPrinterColumns.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching additionalPrinterColumns. No match found.");
        return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
    }

    
/**
 * This method has been deprecated, please use method buildConversion instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion getConversion() {
        return this.conversion!=null?this.conversion.build():null;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion buildConversion() {
        return this.conversion!=null?this.conversion.build():null;
    }

    public A withConversion(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion conversion) {
        _visitables.get("conversion").remove(this.conversion);
        if (conversion!=null){ this.conversion= new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder(conversion); _visitables.get("conversion").add(this.conversion);} return (A) this;
    }

    public Boolean hasConversion() {
        return this.conversion != null;
    }

    public CustomResourceDefinitionSpecFluent.ConversionNested<A> withNewConversion() {
        return new ConversionNestedImpl();
    }

    public CustomResourceDefinitionSpecFluent.ConversionNested<A> withNewConversionLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item) {
        return new ConversionNestedImpl(item);
    }

    public CustomResourceDefinitionSpecFluent.ConversionNested<A> editConversion() {
        return withNewConversionLike(getConversion());
    }

    public CustomResourceDefinitionSpecFluent.ConversionNested<A> editOrNewConversion() {
        return withNewConversionLike(getConversion() != null ? getConversion(): new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder().build());
    }

    public CustomResourceDefinitionSpecFluent.ConversionNested<A> editOrNewConversionLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item) {
        return withNewConversionLike(getConversion() != null ? getConversion(): item);
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group=group; return (A) this;
    }

    public Boolean hasGroup() {
        return this.group != null;
    }

    public A withNewGroup(String arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuilder arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuffer arg1) {
        return (A)withGroup(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildNames instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames getNames() {
        return this.names!=null?this.names.build():null;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames buildNames() {
        return this.names!=null?this.names.build():null;
    }

    public A withNames(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames names) {
        _visitables.get("names").remove(this.names);
        if (names!=null){ this.names= new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(names); _visitables.get("names").add(this.names);} return (A) this;
    }

    public Boolean hasNames() {
        return this.names != null;
    }

    public CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNames() {
        return new NamesNestedImpl();
    }

    public CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNamesLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item) {
        return new NamesNestedImpl(item);
    }

    public CustomResourceDefinitionSpecFluent.NamesNested<A> editNames() {
        return withNewNamesLike(getNames());
    }

    public CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNames() {
        return withNewNamesLike(getNames() != null ? getNames(): new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder().build());
    }

    public CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNamesLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item) {
        return withNewNamesLike(getNames() != null ? getNames(): item);
    }

    public Boolean isPreserveUnknownFields() {
        return this.preserveUnknownFields;
    }

    public A withPreserveUnknownFields(Boolean preserveUnknownFields) {
        this.preserveUnknownFields=preserveUnknownFields; return (A) this;
    }

    public Boolean hasPreserveUnknownFields() {
        return this.preserveUnknownFields != null;
    }

    public A withNewPreserveUnknownFields(String arg1) {
        return (A)withPreserveUnknownFields(new Boolean(arg1));
    }

    public A withNewPreserveUnknownFields(boolean arg1) {
        return (A)withPreserveUnknownFields(new Boolean(arg1));
    }

    public String getScope() {
        return this.scope;
    }

    public A withScope(String scope) {
        this.scope=scope; return (A) this;
    }

    public Boolean hasScope() {
        return this.scope != null;
    }

    public A withNewScope(String arg1) {
        return (A)withScope(new String(arg1));
    }

    public A withNewScope(StringBuilder arg1) {
        return (A)withScope(new String(arg1));
    }

    public A withNewScope(StringBuffer arg1) {
        return (A)withScope(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSubresources instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources getSubresources() {
        return this.subresources!=null?this.subresources.build():null;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources buildSubresources() {
        return this.subresources!=null?this.subresources.build():null;
    }

    public A withSubresources(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources subresources) {
        _visitables.get("subresources").remove(this.subresources);
        if (subresources!=null){ this.subresources= new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(subresources); _visitables.get("subresources").add(this.subresources);} return (A) this;
    }

    public Boolean hasSubresources() {
        return this.subresources != null;
    }

    public CustomResourceDefinitionSpecFluent.SubresourcesNested<A> withNewSubresources() {
        return new SubresourcesNestedImpl();
    }

    public CustomResourceDefinitionSpecFluent.SubresourcesNested<A> withNewSubresourcesLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item) {
        return new SubresourcesNestedImpl(item);
    }

    public CustomResourceDefinitionSpecFluent.SubresourcesNested<A> editSubresources() {
        return withNewSubresourcesLike(getSubresources());
    }

    public CustomResourceDefinitionSpecFluent.SubresourcesNested<A> editOrNewSubresources() {
        return withNewSubresourcesLike(getSubresources() != null ? getSubresources(): new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder().build());
    }

    public CustomResourceDefinitionSpecFluent.SubresourcesNested<A> editOrNewSubresourcesLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item) {
        return withNewSubresourcesLike(getSubresources() != null ? getSubresources(): item);
    }

    
/**
 * This method has been deprecated, please use method buildValidation instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation getValidation() {
        return this.validation!=null?this.validation.build():null;
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation buildValidation() {
        return this.validation!=null?this.validation.build():null;
    }

    public A withValidation(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation validation) {
        _visitables.get("validation").remove(this.validation);
        if (validation!=null){ this.validation= new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(validation); _visitables.get("validation").add(this.validation);} return (A) this;
    }

    public Boolean hasValidation() {
        return this.validation != null;
    }

    public CustomResourceDefinitionSpecFluent.ValidationNested<A> withNewValidation() {
        return new ValidationNestedImpl();
    }

    public CustomResourceDefinitionSpecFluent.ValidationNested<A> withNewValidationLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item) {
        return new ValidationNestedImpl(item);
    }

    public CustomResourceDefinitionSpecFluent.ValidationNested<A> editValidation() {
        return withNewValidationLike(getValidation());
    }

    public CustomResourceDefinitionSpecFluent.ValidationNested<A> editOrNewValidation() {
        return withNewValidationLike(getValidation() != null ? getValidation(): new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder().build());
    }

    public CustomResourceDefinitionSpecFluent.ValidationNested<A> editOrNewValidationLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item) {
        return withNewValidationLike(getValidation() != null ? getValidation(): item);
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A addToVersions(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item) {
        if (this.versions == null) {this.versions = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder>();}
        io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(index >= 0 ? index : _visitables.get("versions").size(), builder);this.versions.add(index >= 0 ? index : versions.size(), builder); return (A)this;
    }

    public A setToVersions(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item) {
        if (this.versions == null) {this.versions = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder>();}
        io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(item);
        if (index < 0 || index >= _visitables.get("versions").size()) { _visitables.get("versions").add(builder); } else { _visitables.get("versions").set(index, builder);}
        if (index < 0 || index >= versions.size()) { versions.add(builder); } else { versions.set(index, builder);}
         return (A)this;
    }

    public A addToVersions(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion... items) {
        if (this.versions == null) {this.versions = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder>();}
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
    }

    public A addAllToVersions(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion> items) {
        if (this.versions == null) {this.versions = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder>();}
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
    }

    public A removeFromVersions(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion... items) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
    }

    public A removeAllFromVersions(Collection<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion> items) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item : items) {io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVersions(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder> predicate) {
        if (versions == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder> each = versions.iterator();
        final List visitables = _visitables.get("versions");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVersions instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion> getVersions() {
        return build(versions);
    }

    public List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion> buildVersions() {
        return build(versions);
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion buildVersion(int index) {
        return this.versions.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion buildFirstVersion() {
        return this.versions.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion buildLastVersion() {
        return this.versions.get(versions.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion buildMatchingVersion(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder item: versions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVersion(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder item: versions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVersions(List<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion> versions) {
        if (this.versions != null) { _visitables.get("versions").removeAll(this.versions);}
        if (versions != null) {this.versions = new ArrayList<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder>(); for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item : versions){this.addToVersions(item);}} else { this.versions = null;} return (A) this;
    }

    public A withVersions(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion... versions) {
        if (this.versions != null) {this.versions.clear();}
        if (versions != null) {for (io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item :versions){ this.addToVersions(item);}} return (A) this;
    }

    public Boolean hasVersions() {
        return versions != null && !versions.isEmpty();
    }

    public CustomResourceDefinitionSpecFluent.VersionsNested<A> addNewVersion() {
        return new VersionsNestedImpl();
    }

    public CustomResourceDefinitionSpecFluent.VersionsNested<A> addNewVersionLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item) {
        return new VersionsNestedImpl(-1, item);
    }

    public CustomResourceDefinitionSpecFluent.VersionsNested<A> setNewVersionLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item) {
        return new VersionsNestedImpl(index, item);
    }

    public CustomResourceDefinitionSpecFluent.VersionsNested<A> editVersion(int index) {
        if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
        return setNewVersionLike(index, buildVersion(index));
    }

    public CustomResourceDefinitionSpecFluent.VersionsNested<A> editFirstVersion() {
        if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
        return setNewVersionLike(0, buildVersion(0));
    }

    public CustomResourceDefinitionSpecFluent.VersionsNested<A> editLastVersion() {
        int index = versions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
        return setNewVersionLike(index, buildVersion(index));
    }

    public CustomResourceDefinitionSpecFluent.VersionsNested<A> editMatchingVersion(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<versions.size();i++) { 
        if (predicate.apply(versions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
        return setNewVersionLike(index, buildVersion(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CustomResourceDefinitionSpecFluentImpl that = (CustomResourceDefinitionSpecFluentImpl) o;
        if (additionalPrinterColumns != null ? !additionalPrinterColumns.equals(that.additionalPrinterColumns) :that.additionalPrinterColumns != null) return false;
        if (conversion != null ? !conversion.equals(that.conversion) :that.conversion != null) return false;
        if (group != null ? !group.equals(that.group) :that.group != null) return false;
        if (names != null ? !names.equals(that.names) :that.names != null) return false;
        if (preserveUnknownFields != null ? !preserveUnknownFields.equals(that.preserveUnknownFields) :that.preserveUnknownFields != null) return false;
        if (scope != null ? !scope.equals(that.scope) :that.scope != null) return false;
        if (subresources != null ? !subresources.equals(that.subresources) :that.subresources != null) return false;
        if (validation != null ? !validation.equals(that.validation) :that.validation != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(additionalPrinterColumns,  conversion,  group,  names,  preserveUnknownFields,  scope,  subresources,  validation,  version,  versions,  super.hashCode());
    }

    public class AdditionalPrinterColumnsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionFluentImpl<CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<N>> implements CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder;
        private final int index;

        AdditionalPrinterColumnsNestedImpl(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
            this.index = index;
            this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(this, item);
        }

        AdditionalPrinterColumnsNestedImpl() {
            this.index = -1;
            this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(this);
        }

        public N and() {
             return (N) CustomResourceDefinitionSpecFluentImpl.this.setToAdditionalPrinterColumns(index,builder.build());
        }

        public N endAdditionalPrinterColumn() {
             return and();
        }
    }


    public class ConversionNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionFluentImpl<CustomResourceDefinitionSpecFluent.ConversionNested<N>> implements CustomResourceDefinitionSpecFluent.ConversionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder builder;

        ConversionNestedImpl(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item) {
            this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder(this, item);
        }

        ConversionNestedImpl() {
            this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder(this);
        }

        public N and() {
             return (N) CustomResourceDefinitionSpecFluentImpl.this.withConversion(builder.build());
        }

        public N endConversion() {
             return and();
        }
    }


    public class NamesNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesFluentImpl<CustomResourceDefinitionSpecFluent.NamesNested<N>> implements CustomResourceDefinitionSpecFluent.NamesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder builder;

        NamesNestedImpl(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item) {
            this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(this, item);
        }

        NamesNestedImpl() {
            this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(this);
        }

        public N and() {
             return (N) CustomResourceDefinitionSpecFluentImpl.this.withNames(builder.build());
        }

        public N endNames() {
             return and();
        }
    }


    public class SubresourcesNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesFluentImpl<CustomResourceDefinitionSpecFluent.SubresourcesNested<N>> implements CustomResourceDefinitionSpecFluent.SubresourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder builder;

        SubresourcesNestedImpl(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item) {
            this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(this, item);
        }

        SubresourcesNestedImpl() {
            this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(this);
        }

        public N and() {
             return (N) CustomResourceDefinitionSpecFluentImpl.this.withSubresources(builder.build());
        }

        public N endSubresources() {
             return and();
        }
    }


    public class ValidationNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationFluentImpl<CustomResourceDefinitionSpecFluent.ValidationNested<N>> implements CustomResourceDefinitionSpecFluent.ValidationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder builder;

        ValidationNestedImpl(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item) {
            this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(this, item);
        }

        ValidationNestedImpl() {
            this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(this);
        }

        public N and() {
             return (N) CustomResourceDefinitionSpecFluentImpl.this.withValidation(builder.build());
        }

        public N endValidation() {
             return and();
        }
    }


    public class VersionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluentImpl<CustomResourceDefinitionSpecFluent.VersionsNested<N>> implements CustomResourceDefinitionSpecFluent.VersionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder;
        private final int index;

        VersionsNestedImpl(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item) {
            this.index = index;
            this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(this, item);
        }

        VersionsNestedImpl() {
            this.index = -1;
            this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(this);
        }

        public N and() {
             return (N) CustomResourceDefinitionSpecFluentImpl.this.setToVersions(index,builder.build());
        }

        public N endVersion() {
             return and();
        }
    }


}
