package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CustomResourceDefinitionListFluent<A extends CustomResourceDefinitionListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,CustomResourceDefinition item);
    public A setToItems(int index,CustomResourceDefinition item);
    public A addToItems(CustomResourceDefinition... items);
    public A addAllToItems(Collection<CustomResourceDefinition> items);
    public A removeFromItems(CustomResourceDefinition... items);
    public A removeAllFromItems(Collection<CustomResourceDefinition> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<CustomResourceDefinitionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<CustomResourceDefinition> getItems();
    public List<CustomResourceDefinition> buildItems();
    public CustomResourceDefinition buildItem(int index);
    public CustomResourceDefinition buildFirstItem();
    public CustomResourceDefinition buildLastItem();
    public CustomResourceDefinition buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<CustomResourceDefinitionBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<CustomResourceDefinitionBuilder> predicate);
    public A withItems(List<CustomResourceDefinition> items);
    public A withItems(CustomResourceDefinition... items);
    public Boolean hasItems();
    public CustomResourceDefinitionListFluent.ItemsNested<A> addNewItem();
    public CustomResourceDefinitionListFluent.ItemsNested<A> addNewItemLike(CustomResourceDefinition item);
    public CustomResourceDefinitionListFluent.ItemsNested<A> setNewItemLike(int index,CustomResourceDefinition item);
    public CustomResourceDefinitionListFluent.ItemsNested<A> editItem(int index);
    public CustomResourceDefinitionListFluent.ItemsNested<A> editFirstItem();
    public CustomResourceDefinitionListFluent.ItemsNested<A> editLastItem();
    public CustomResourceDefinitionListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<CustomResourceDefinitionBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CustomResourceDefinitionFluent<CustomResourceDefinitionListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
