package io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JSONSchemaPropsOrBoolFluent<A extends JSONSchemaPropsOrBoolFluent<A>> extends BaseFluent<A>{
  public JSONSchemaPropsOrBoolFluent() {
  }
  
  public JSONSchemaPropsOrBoolFluent(JSONSchemaPropsOrBool instance) {
    this.copyInstance(instance);
  }
  private Boolean allows;
  private JSONSchemaPropsBuilder schema;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(JSONSchemaPropsOrBool instance) {
    instance = (instance != null ? instance : new JSONSchemaPropsOrBool());
    if (instance != null) {
          this.withAllows(instance.getAllows());
          this.withSchema(instance.getSchema());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getAllows() {
    return this.allows;
  }
  
  public A withAllows(Boolean allows) {
    this.allows = allows;
    return (A) this;
  }
  
  public boolean hasAllows() {
    return this.allows != null;
  }
  
  public JSONSchemaProps buildSchema() {
    return this.schema != null ? this.schema.build() : null;
  }
  
  public A withSchema(JSONSchemaProps schema) {
    this._visitables.remove("schema");
    if (schema != null) {
        this.schema = new JSONSchemaPropsBuilder(schema);
        this._visitables.get("schema").add(this.schema);
    } else {
        this.schema = null;
        this._visitables.get("schema").remove(this.schema);
    }
    return (A) this;
  }
  
  public boolean hasSchema() {
    return this.schema != null;
  }
  
  public SchemaNested<A> withNewSchema() {
    return new SchemaNested(null);
  }
  
  public SchemaNested<A> withNewSchemaLike(JSONSchemaProps item) {
    return new SchemaNested(item);
  }
  
  public SchemaNested<A> editSchema() {
    return withNewSchemaLike(java.util.Optional.ofNullable(buildSchema()).orElse(null));
  }
  
  public SchemaNested<A> editOrNewSchema() {
    return withNewSchemaLike(java.util.Optional.ofNullable(buildSchema()).orElse(new JSONSchemaPropsBuilder().build()));
  }
  
  public SchemaNested<A> editOrNewSchemaLike(JSONSchemaProps item) {
    return withNewSchemaLike(java.util.Optional.ofNullable(buildSchema()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JSONSchemaPropsOrBoolFluent that = (JSONSchemaPropsOrBoolFluent) o;
    if (!java.util.Objects.equals(allows, that.allows)) return false;
    if (!java.util.Objects.equals(schema, that.schema)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allows,  schema,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allows != null) { sb.append("allows:"); sb.append(allows + ","); }
    if (schema != null) { sb.append("schema:"); sb.append(schema + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAllows() {
    return withAllows(true);
  }
  public class SchemaNested<N> extends JSONSchemaPropsFluent<SchemaNested<N>> implements Nested<N>{
    SchemaNested(JSONSchemaProps item) {
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    JSONSchemaPropsBuilder builder;
    
    public N and() {
      return (N) JSONSchemaPropsOrBoolFluent.this.withSchema(builder.build());
    }
    
    public N endSchema() {
      return and();
    }
    
  
  }

}