package io.fabric8.kubernetes.api.model.coordination.v1;

import java.lang.Integer;
import java.time.ZonedDateTime;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class LeaseSpecFluent<A extends LeaseSpecFluent<A>> extends BaseFluent<A>{
  public LeaseSpecFluent() {
  }
  
  public LeaseSpecFluent(LeaseSpec instance) {
    this.copyInstance(instance);
  }
  private ZonedDateTime acquireTime;
  private String holderIdentity;
  private Integer leaseDurationSeconds;
  private Integer leaseTransitions;
  private String preferredHolder;
  private ZonedDateTime renewTime;
  private String strategy;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(LeaseSpec instance) {
    instance = (instance != null ? instance : new LeaseSpec());
    if (instance != null) {
          this.withAcquireTime(instance.getAcquireTime());
          this.withHolderIdentity(instance.getHolderIdentity());
          this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds());
          this.withLeaseTransitions(instance.getLeaseTransitions());
          this.withPreferredHolder(instance.getPreferredHolder());
          this.withRenewTime(instance.getRenewTime());
          this.withStrategy(instance.getStrategy());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ZonedDateTime getAcquireTime() {
    return this.acquireTime;
  }
  
  public A withAcquireTime(ZonedDateTime acquireTime) {
    this.acquireTime = acquireTime;
    return (A) this;
  }
  
  public boolean hasAcquireTime() {
    return this.acquireTime != null;
  }
  
  public String getHolderIdentity() {
    return this.holderIdentity;
  }
  
  public A withHolderIdentity(String holderIdentity) {
    this.holderIdentity = holderIdentity;
    return (A) this;
  }
  
  public boolean hasHolderIdentity() {
    return this.holderIdentity != null;
  }
  
  public Integer getLeaseDurationSeconds() {
    return this.leaseDurationSeconds;
  }
  
  public A withLeaseDurationSeconds(Integer leaseDurationSeconds) {
    this.leaseDurationSeconds = leaseDurationSeconds;
    return (A) this;
  }
  
  public boolean hasLeaseDurationSeconds() {
    return this.leaseDurationSeconds != null;
  }
  
  public Integer getLeaseTransitions() {
    return this.leaseTransitions;
  }
  
  public A withLeaseTransitions(Integer leaseTransitions) {
    this.leaseTransitions = leaseTransitions;
    return (A) this;
  }
  
  public boolean hasLeaseTransitions() {
    return this.leaseTransitions != null;
  }
  
  public String getPreferredHolder() {
    return this.preferredHolder;
  }
  
  public A withPreferredHolder(String preferredHolder) {
    this.preferredHolder = preferredHolder;
    return (A) this;
  }
  
  public boolean hasPreferredHolder() {
    return this.preferredHolder != null;
  }
  
  public ZonedDateTime getRenewTime() {
    return this.renewTime;
  }
  
  public A withRenewTime(ZonedDateTime renewTime) {
    this.renewTime = renewTime;
    return (A) this;
  }
  
  public boolean hasRenewTime() {
    return this.renewTime != null;
  }
  
  public String getStrategy() {
    return this.strategy;
  }
  
  public A withStrategy(String strategy) {
    this.strategy = strategy;
    return (A) this;
  }
  
  public boolean hasStrategy() {
    return this.strategy != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LeaseSpecFluent that = (LeaseSpecFluent) o;
    if (!java.util.Objects.equals(acquireTime, that.acquireTime)) return false;
    if (!java.util.Objects.equals(holderIdentity, that.holderIdentity)) return false;
    if (!java.util.Objects.equals(leaseDurationSeconds, that.leaseDurationSeconds)) return false;
    if (!java.util.Objects.equals(leaseTransitions, that.leaseTransitions)) return false;
    if (!java.util.Objects.equals(preferredHolder, that.preferredHolder)) return false;
    if (!java.util.Objects.equals(renewTime, that.renewTime)) return false;
    if (!java.util.Objects.equals(strategy, that.strategy)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(acquireTime,  holderIdentity,  leaseDurationSeconds,  leaseTransitions,  preferredHolder,  renewTime,  strategy,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (acquireTime != null) { sb.append("acquireTime:"); sb.append(acquireTime + ","); }
    if (holderIdentity != null) { sb.append("holderIdentity:"); sb.append(holderIdentity + ","); }
    if (leaseDurationSeconds != null) { sb.append("leaseDurationSeconds:"); sb.append(leaseDurationSeconds + ","); }
    if (leaseTransitions != null) { sb.append("leaseTransitions:"); sb.append(leaseTransitions + ","); }
    if (preferredHolder != null) { sb.append("preferredHolder:"); sb.append(preferredHolder + ","); }
    if (renewTime != null) { sb.append("renewTime:"); sb.append(renewTime + ","); }
    if (strategy != null) { sb.append("strategy:"); sb.append(strategy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}