package io.fabric8.kubernetes.api.model.discovery;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointBuilder extends EndpointFluentImpl<EndpointBuilder> implements VisitableBuilder<Endpoint,EndpointBuilder> {

    EndpointFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointBuilder() { 
        this(true);
    }


    public EndpointBuilder(Boolean validationEnabled) { 
        this(new Endpoint(), validationEnabled);
    }


    public EndpointBuilder(EndpointFluent<?> fluent) { 
        this(fluent, true);
    }


    public EndpointBuilder(EndpointFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new Endpoint(), validationEnabled);
    }


    public EndpointBuilder(EndpointFluent<?> fluent,Endpoint instance) { 
        this(fluent, instance, true);
    }


    public EndpointBuilder(EndpointFluent<?> fluent,Endpoint instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAddresses(instance.getAddresses()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withHostname(instance.getHostname()); 
        fluent.withTargetRef(instance.getTargetRef()); 
        fluent.withTopology(instance.getTopology()); 
        this.validationEnabled = validationEnabled; 
    }


    public EndpointBuilder(Endpoint instance) { 
        this(instance,true);
    }


    public EndpointBuilder(Endpoint instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAddresses(instance.getAddresses()); 
        this.withConditions(instance.getConditions()); 
        this.withHostname(instance.getHostname()); 
        this.withTargetRef(instance.getTargetRef()); 
        this.withTopology(instance.getTopology()); 
        this.validationEnabled = validationEnabled; 
    }


    public Endpoint build() {
        Endpoint buildable = new Endpoint(fluent.getAddresses(),fluent.getConditions(),fluent.getHostname(),fluent.getTargetRef(),fluent.getTopology());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EndpointBuilder that = (EndpointBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
