package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EndpointHintsBuilder extends EndpointHintsFluent<EndpointHintsBuilder> implements VisitableBuilder<EndpointHints,EndpointHintsBuilder>{
  public EndpointHintsBuilder() {
    this(new EndpointHints());
  }
  
  public EndpointHintsBuilder(EndpointHintsFluent<?> fluent) {
    this(fluent, new EndpointHints());
  }
  
  public EndpointHintsBuilder(EndpointHintsFluent<?> fluent,EndpointHints instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EndpointHintsBuilder(EndpointHints instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EndpointHintsFluent<?> fluent;
  
  public EndpointHints build() {
    EndpointHints buildable = new EndpointHints(fluent.buildForZones());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}