package io.fabric8.kubernetes.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodDisruptionBudgetSpecBuilder extends PodDisruptionBudgetSpecFluent<PodDisruptionBudgetSpecBuilder> implements VisitableBuilder<PodDisruptionBudgetSpec,PodDisruptionBudgetSpecBuilder>{
  public PodDisruptionBudgetSpecBuilder() {
    this(new PodDisruptionBudgetSpec());
  }
  
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpecFluent<?> fluent) {
    this(fluent, new PodDisruptionBudgetSpec());
  }
  
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpecFluent<?> fluent,PodDisruptionBudgetSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodDisruptionBudgetSpecFluent<?> fluent;
  
  public PodDisruptionBudgetSpec build() {
    PodDisruptionBudgetSpec buildable = new PodDisruptionBudgetSpec(fluent.buildMaxUnavailable(),fluent.buildMinAvailable(),fluent.buildSelector(),fluent.getUnhealthyPodEvictionPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}