package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ResourceClaimParametersFluent<A extends ResourceClaimParametersFluent<A>> extends BaseFluent<A>{
  public ResourceClaimParametersFluent() {
  }
  
  public ResourceClaimParametersFluent(ResourceClaimParameters instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private ArrayList<DriverRequestsBuilder> driverRequests = new ArrayList<DriverRequestsBuilder>();
  private ResourceClaimParametersReferenceBuilder generatedFrom;
  private String kind;
  private ObjectMetaBuilder metadata;
  private Boolean shareable;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ResourceClaimParameters instance) {
    instance = (instance != null ? instance : new ResourceClaimParameters());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withDriverRequests(instance.getDriverRequests());
          this.withGeneratedFrom(instance.getGeneratedFrom());
          this.withKind(instance.getKind());
          this.withMetadata(instance.getMetadata());
          this.withShareable(instance.getShareable());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public A addToDriverRequests(int index,DriverRequests item) {
    if (this.driverRequests == null) {this.driverRequests = new ArrayList<DriverRequestsBuilder>();}
    DriverRequestsBuilder builder = new DriverRequestsBuilder(item);
    if (index < 0 || index >= driverRequests.size()) { _visitables.get("driverRequests").add(builder); driverRequests.add(builder); } else { _visitables.get("driverRequests").add(index, builder); driverRequests.add(index, builder);}
    return (A)this;
  }
  
  public A setToDriverRequests(int index,DriverRequests item) {
    if (this.driverRequests == null) {this.driverRequests = new ArrayList<DriverRequestsBuilder>();}
    DriverRequestsBuilder builder = new DriverRequestsBuilder(item);
    if (index < 0 || index >= driverRequests.size()) { _visitables.get("driverRequests").add(builder); driverRequests.add(builder); } else { _visitables.get("driverRequests").set(index, builder); driverRequests.set(index, builder);}
    return (A)this;
  }
  
  public A addToDriverRequests(io.fabric8.kubernetes.api.model.resource.v1alpha2.DriverRequests... items) {
    if (this.driverRequests == null) {this.driverRequests = new ArrayList<DriverRequestsBuilder>();}
    for (DriverRequests item : items) {DriverRequestsBuilder builder = new DriverRequestsBuilder(item);_visitables.get("driverRequests").add(builder);this.driverRequests.add(builder);} return (A)this;
  }
  
  public A addAllToDriverRequests(Collection<DriverRequests> items) {
    if (this.driverRequests == null) {this.driverRequests = new ArrayList<DriverRequestsBuilder>();}
    for (DriverRequests item : items) {DriverRequestsBuilder builder = new DriverRequestsBuilder(item);_visitables.get("driverRequests").add(builder);this.driverRequests.add(builder);} return (A)this;
  }
  
  public A removeFromDriverRequests(io.fabric8.kubernetes.api.model.resource.v1alpha2.DriverRequests... items) {
    if (this.driverRequests == null) return (A)this;
    for (DriverRequests item : items) {DriverRequestsBuilder builder = new DriverRequestsBuilder(item);_visitables.get("driverRequests").remove(builder); this.driverRequests.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDriverRequests(Collection<DriverRequests> items) {
    if (this.driverRequests == null) return (A)this;
    for (DriverRequests item : items) {DriverRequestsBuilder builder = new DriverRequestsBuilder(item);_visitables.get("driverRequests").remove(builder); this.driverRequests.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDriverRequests(Predicate<DriverRequestsBuilder> predicate) {
    if (driverRequests == null) return (A) this;
    final Iterator<DriverRequestsBuilder> each = driverRequests.iterator();
    final List visitables = _visitables.get("driverRequests");
    while (each.hasNext()) {
      DriverRequestsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DriverRequests> buildDriverRequests() {
    return this.driverRequests != null ? build(driverRequests) : null;
  }
  
  public DriverRequests buildDriverRequest(int index) {
    return this.driverRequests.get(index).build();
  }
  
  public DriverRequests buildFirstDriverRequest() {
    return this.driverRequests.get(0).build();
  }
  
  public DriverRequests buildLastDriverRequest() {
    return this.driverRequests.get(driverRequests.size() - 1).build();
  }
  
  public DriverRequests buildMatchingDriverRequest(Predicate<DriverRequestsBuilder> predicate) {
      for (DriverRequestsBuilder item : driverRequests) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDriverRequest(Predicate<DriverRequestsBuilder> predicate) {
      for (DriverRequestsBuilder item : driverRequests) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDriverRequests(List<DriverRequests> driverRequests) {
    if (this.driverRequests != null) {
      this._visitables.get("driverRequests").clear();
    }
    if (driverRequests != null) {
        this.driverRequests = new ArrayList();
        for (DriverRequests item : driverRequests) {
          this.addToDriverRequests(item);
        }
    } else {
      this.driverRequests = null;
    }
    return (A) this;
  }
  
  public A withDriverRequests(io.fabric8.kubernetes.api.model.resource.v1alpha2.DriverRequests... driverRequests) {
    if (this.driverRequests != null) {
        this.driverRequests.clear();
        _visitables.remove("driverRequests");
    }
    if (driverRequests != null) {
      for (DriverRequests item : driverRequests) {
        this.addToDriverRequests(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDriverRequests() {
    return this.driverRequests != null && !this.driverRequests.isEmpty();
  }
  
  public DriverRequestsNested<A> addNewDriverRequest() {
    return new DriverRequestsNested(-1, null);
  }
  
  public DriverRequestsNested<A> addNewDriverRequestLike(DriverRequests item) {
    return new DriverRequestsNested(-1, item);
  }
  
  public DriverRequestsNested<A> setNewDriverRequestLike(int index,DriverRequests item) {
    return new DriverRequestsNested(index, item);
  }
  
  public DriverRequestsNested<A> editDriverRequest(int index) {
    if (driverRequests.size() <= index) throw new RuntimeException("Can't edit driverRequests. Index exceeds size.");
    return setNewDriverRequestLike(index, buildDriverRequest(index));
  }
  
  public DriverRequestsNested<A> editFirstDriverRequest() {
    if (driverRequests.size() == 0) throw new RuntimeException("Can't edit first driverRequests. The list is empty.");
    return setNewDriverRequestLike(0, buildDriverRequest(0));
  }
  
  public DriverRequestsNested<A> editLastDriverRequest() {
    int index = driverRequests.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last driverRequests. The list is empty.");
    return setNewDriverRequestLike(index, buildDriverRequest(index));
  }
  
  public DriverRequestsNested<A> editMatchingDriverRequest(Predicate<DriverRequestsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<driverRequests.size();i++) { 
    if (predicate.test(driverRequests.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching driverRequests. No match found.");
    return setNewDriverRequestLike(index, buildDriverRequest(index));
  }
  
  public ResourceClaimParametersReference buildGeneratedFrom() {
    return this.generatedFrom != null ? this.generatedFrom.build() : null;
  }
  
  public A withGeneratedFrom(ResourceClaimParametersReference generatedFrom) {
    this._visitables.remove("generatedFrom");
    if (generatedFrom != null) {
        this.generatedFrom = new ResourceClaimParametersReferenceBuilder(generatedFrom);
        this._visitables.get("generatedFrom").add(this.generatedFrom);
    } else {
        this.generatedFrom = null;
        this._visitables.get("generatedFrom").remove(this.generatedFrom);
    }
    return (A) this;
  }
  
  public boolean hasGeneratedFrom() {
    return this.generatedFrom != null;
  }
  
  public A withNewGeneratedFrom(String apiGroup,String kind,String name) {
    return (A)withGeneratedFrom(new ResourceClaimParametersReference(apiGroup, kind, name));
  }
  
  public GeneratedFromNested<A> withNewGeneratedFrom() {
    return new GeneratedFromNested(null);
  }
  
  public GeneratedFromNested<A> withNewGeneratedFromLike(ResourceClaimParametersReference item) {
    return new GeneratedFromNested(item);
  }
  
  public GeneratedFromNested<A> editGeneratedFrom() {
    return withNewGeneratedFromLike(java.util.Optional.ofNullable(buildGeneratedFrom()).orElse(null));
  }
  
  public GeneratedFromNested<A> editOrNewGeneratedFrom() {
    return withNewGeneratedFromLike(java.util.Optional.ofNullable(buildGeneratedFrom()).orElse(new ResourceClaimParametersReferenceBuilder().build()));
  }
  
  public GeneratedFromNested<A> editOrNewGeneratedFromLike(ResourceClaimParametersReference item) {
    return withNewGeneratedFromLike(java.util.Optional.ofNullable(buildGeneratedFrom()).orElse(item));
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public Boolean getShareable() {
    return this.shareable;
  }
  
  public A withShareable(Boolean shareable) {
    this.shareable = shareable;
    return (A) this;
  }
  
  public boolean hasShareable() {
    return this.shareable != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceClaimParametersFluent that = (ResourceClaimParametersFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(driverRequests, that.driverRequests)) return false;
    if (!java.util.Objects.equals(generatedFrom, that.generatedFrom)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(shareable, that.shareable)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  driverRequests,  generatedFrom,  kind,  metadata,  shareable,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (driverRequests != null && !driverRequests.isEmpty()) { sb.append("driverRequests:"); sb.append(driverRequests + ","); }
    if (generatedFrom != null) { sb.append("generatedFrom:"); sb.append(generatedFrom + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (shareable != null) { sb.append("shareable:"); sb.append(shareable + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withShareable() {
    return withShareable(true);
  }
  public class DriverRequestsNested<N> extends DriverRequestsFluent<DriverRequestsNested<N>> implements Nested<N>{
    DriverRequestsNested(int index,DriverRequests item) {
      this.index = index;
      this.builder = new DriverRequestsBuilder(this, item);
    }
    DriverRequestsBuilder builder;
    int index;
    
    public N and() {
      return (N) ResourceClaimParametersFluent.this.setToDriverRequests(index,builder.build());
    }
    
    public N endDriverRequest() {
      return and();
    }
    
  
  }
  public class GeneratedFromNested<N> extends ResourceClaimParametersReferenceFluent<GeneratedFromNested<N>> implements Nested<N>{
    GeneratedFromNested(ResourceClaimParametersReference item) {
      this.builder = new ResourceClaimParametersReferenceBuilder(this, item);
    }
    ResourceClaimParametersReferenceBuilder builder;
    
    public N and() {
      return (N) ResourceClaimParametersFluent.this.withGeneratedFrom(builder.build());
    }
    
    public N endGeneratedFrom() {
      return and();
    }
    
  
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) ResourceClaimParametersFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }

}