package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ResourceHandleFluent<A extends ResourceHandleFluent<A>> extends BaseFluent<A>{
  public ResourceHandleFluent() {
  }
  
  public ResourceHandleFluent(ResourceHandle instance) {
    this.copyInstance(instance);
  }
  private String data;
  private String driverName;
  private StructuredResourceHandleBuilder structuredData;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ResourceHandle instance) {
    instance = (instance != null ? instance : new ResourceHandle());
    if (instance != null) {
          this.withData(instance.getData());
          this.withDriverName(instance.getDriverName());
          this.withStructuredData(instance.getStructuredData());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getData() {
    return this.data;
  }
  
  public A withData(String data) {
    this.data = data;
    return (A) this;
  }
  
  public boolean hasData() {
    return this.data != null;
  }
  
  public String getDriverName() {
    return this.driverName;
  }
  
  public A withDriverName(String driverName) {
    this.driverName = driverName;
    return (A) this;
  }
  
  public boolean hasDriverName() {
    return this.driverName != null;
  }
  
  public StructuredResourceHandle buildStructuredData() {
    return this.structuredData != null ? this.structuredData.build() : null;
  }
  
  public A withStructuredData(StructuredResourceHandle structuredData) {
    this._visitables.remove("structuredData");
    if (structuredData != null) {
        this.structuredData = new StructuredResourceHandleBuilder(structuredData);
        this._visitables.get("structuredData").add(this.structuredData);
    } else {
        this.structuredData = null;
        this._visitables.get("structuredData").remove(this.structuredData);
    }
    return (A) this;
  }
  
  public boolean hasStructuredData() {
    return this.structuredData != null;
  }
  
  public StructuredDataNested<A> withNewStructuredData() {
    return new StructuredDataNested(null);
  }
  
  public StructuredDataNested<A> withNewStructuredDataLike(StructuredResourceHandle item) {
    return new StructuredDataNested(item);
  }
  
  public StructuredDataNested<A> editStructuredData() {
    return withNewStructuredDataLike(java.util.Optional.ofNullable(buildStructuredData()).orElse(null));
  }
  
  public StructuredDataNested<A> editOrNewStructuredData() {
    return withNewStructuredDataLike(java.util.Optional.ofNullable(buildStructuredData()).orElse(new StructuredResourceHandleBuilder().build()));
  }
  
  public StructuredDataNested<A> editOrNewStructuredDataLike(StructuredResourceHandle item) {
    return withNewStructuredDataLike(java.util.Optional.ofNullable(buildStructuredData()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceHandleFluent that = (ResourceHandleFluent) o;
    if (!java.util.Objects.equals(data, that.data)) return false;
    if (!java.util.Objects.equals(driverName, that.driverName)) return false;
    if (!java.util.Objects.equals(structuredData, that.structuredData)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(data,  driverName,  structuredData,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (data != null) { sb.append("data:"); sb.append(data + ","); }
    if (driverName != null) { sb.append("driverName:"); sb.append(driverName + ","); }
    if (structuredData != null) { sb.append("structuredData:"); sb.append(structuredData + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class StructuredDataNested<N> extends StructuredResourceHandleFluent<StructuredDataNested<N>> implements Nested<N>{
    StructuredDataNested(StructuredResourceHandle item) {
      this.builder = new StructuredResourceHandleBuilder(this, item);
    }
    StructuredResourceHandleBuilder builder;
    
    public N and() {
      return (N) ResourceHandleFluent.this.withStructuredData(builder.build());
    }
    
    public N endStructuredData() {
      return and();
    }
    
  
  }

}