package io.fabric8.kubernetes.api.model.resource.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DeviceClaimBuilder extends DeviceClaimFluent<DeviceClaimBuilder> implements VisitableBuilder<DeviceClaim,DeviceClaimBuilder>{
  public DeviceClaimBuilder() {
    this(new DeviceClaim());
  }
  
  public DeviceClaimBuilder(DeviceClaimFluent<?> fluent) {
    this(fluent, new DeviceClaim());
  }
  
  public DeviceClaimBuilder(DeviceClaimFluent<?> fluent,DeviceClaim instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DeviceClaimBuilder(DeviceClaim instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DeviceClaimFluent<?> fluent;
  
  public DeviceClaim build() {
    DeviceClaim buildable = new DeviceClaim(fluent.buildConfig(),fluent.buildConstraints(),fluent.buildRequests());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}