package io.fabric8.kubernetes.api.model.resource.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkDeviceDataBuilder extends NetworkDeviceDataFluent<NetworkDeviceDataBuilder> implements VisitableBuilder<NetworkDeviceData,NetworkDeviceDataBuilder>{
  public NetworkDeviceDataBuilder() {
    this(new NetworkDeviceData());
  }
  
  public NetworkDeviceDataBuilder(NetworkDeviceDataFluent<?> fluent) {
    this(fluent, new NetworkDeviceData());
  }
  
  public NetworkDeviceDataBuilder(NetworkDeviceDataFluent<?> fluent,NetworkDeviceData instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkDeviceDataBuilder(NetworkDeviceData instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkDeviceDataFluent<?> fluent;
  
  public NetworkDeviceData build() {
    NetworkDeviceData buildable = new NetworkDeviceData(fluent.getHardwareAddress(),fluent.getInterfaceName(),fluent.getIps());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}