package io.fabric8.kubernetes.api.model.resource.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceClaimBuilder extends ResourceClaimFluent<ResourceClaimBuilder> implements VisitableBuilder<ResourceClaim,ResourceClaimBuilder>{
  public ResourceClaimBuilder() {
    this(new ResourceClaim());
  }
  
  public ResourceClaimBuilder(ResourceClaimFluent<?> fluent) {
    this(fluent, new ResourceClaim());
  }
  
  public ResourceClaimBuilder(ResourceClaimFluent<?> fluent,ResourceClaim instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceClaimBuilder(ResourceClaim instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceClaimFluent<?> fluent;
  
  public ResourceClaim build() {
    ResourceClaim buildable = new ResourceClaim(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}