package io.fabric8.kubernetes.api.model.resource.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DeviceFluent<A extends DeviceFluent<A>> extends BaseFluent<A>{
  public DeviceFluent() {
  }
  
  public DeviceFluent(Device instance) {
    this.copyInstance(instance);
  }
  private BasicDeviceBuilder basic;
  private String name;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Device instance) {
    instance = (instance != null ? instance : new Device());
    if (instance != null) {
          this.withBasic(instance.getBasic());
          this.withName(instance.getName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public BasicDevice buildBasic() {
    return this.basic != null ? this.basic.build() : null;
  }
  
  public A withBasic(BasicDevice basic) {
    this._visitables.remove("basic");
    if (basic != null) {
        this.basic = new BasicDeviceBuilder(basic);
        this._visitables.get("basic").add(this.basic);
    } else {
        this.basic = null;
        this._visitables.get("basic").remove(this.basic);
    }
    return (A) this;
  }
  
  public boolean hasBasic() {
    return this.basic != null;
  }
  
  public BasicNested<A> withNewBasic() {
    return new BasicNested(null);
  }
  
  public BasicNested<A> withNewBasicLike(BasicDevice item) {
    return new BasicNested(item);
  }
  
  public BasicNested<A> editBasic() {
    return withNewBasicLike(java.util.Optional.ofNullable(buildBasic()).orElse(null));
  }
  
  public BasicNested<A> editOrNewBasic() {
    return withNewBasicLike(java.util.Optional.ofNullable(buildBasic()).orElse(new BasicDeviceBuilder().build()));
  }
  
  public BasicNested<A> editOrNewBasicLike(BasicDevice item) {
    return withNewBasicLike(java.util.Optional.ofNullable(buildBasic()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeviceFluent that = (DeviceFluent) o;
    if (!java.util.Objects.equals(basic, that.basic)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(basic,  name,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (basic != null) { sb.append("basic:"); sb.append(basic + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BasicNested<N> extends BasicDeviceFluent<BasicNested<N>> implements Nested<N>{
    BasicNested(BasicDevice item) {
      this.builder = new BasicDeviceBuilder(this, item);
    }
    BasicDeviceBuilder builder;
    
    public N and() {
      return (N) DeviceFluent.this.withBasic(builder.build());
    }
    
    public N endBasic() {
      return and();
    }
    
  
  }

}