package io.fabric8.kubernetes.api.model.resource.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DeviceRequestBuilder extends DeviceRequestFluent<DeviceRequestBuilder> implements VisitableBuilder<DeviceRequest,DeviceRequestBuilder>{
  public DeviceRequestBuilder() {
    this(new DeviceRequest());
  }
  
  public DeviceRequestBuilder(DeviceRequestFluent<?> fluent) {
    this(fluent, new DeviceRequest());
  }
  
  public DeviceRequestBuilder(DeviceRequestFluent<?> fluent,DeviceRequest instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DeviceRequestBuilder(DeviceRequest instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DeviceRequestFluent<?> fluent;
  
  public DeviceRequest build() {
    DeviceRequest buildable = new DeviceRequest(fluent.getAdminAccess(),fluent.getAllocationMode(),fluent.getCount(),fluent.getDeviceClassName(),fluent.getName(),fluent.buildSelectors());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}