/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.polling;

import com.softwaremill.quicklens.package;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.util.NameGen;
import io.gatling.http.HeaderNames$;
import io.gatling.http.client.Request;
import io.gatling.http.client.ahc.uri.Uri;
import io.gatling.http.engine.response.Crash;
import io.gatling.http.engine.response.Proceed;
import io.gatling.http.engine.response.ProcessorResult;
import io.gatling.http.engine.response.Redirect;
import io.gatling.http.engine.response.RedirectProcessor$;
import io.gatling.http.engine.response.SessionProcessor;
import io.gatling.http.engine.response.StatsProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.Response;
import io.gatling.http.response.ResponseBuilder;
import io.gatling.http.util.HttpHelper$;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u001b\t9\u0002k\u001c7mKJ\u0014Vm\u001d9p]N,\u0007K]8dKN\u001cxN\u001d\u0006\u0003\u0007\u0011\tq\u0001]8mY&twM\u0003\u0002\u0006\r\u00051\u0011m\u0019;j_:T!a\u0002\u0005\u0002\t!$H\u000f\u001d\u0006\u0003\u0013)\tqaZ1uY&twMC\u0001\f\u0003\tIwn\u0001\u0001\u0014\t\u0001qAC\b\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UaR\"\u0001\f\u000b\u0005]A\u0012\u0001D:dC2\fGn\\4hS:<'BA\r\u001b\u0003!!\u0018\u0010]3tC\u001a,'\"A\u000e\u0002\u0007\r|W.\u0003\u0002\u001e-\ti1\u000b\u001e:jGRdunZ4j]\u001e\u0004\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\tU$\u0018\u000e\u001c\u0006\u0003G!\tAaY8sK&\u0011Q\u0005\t\u0002\b\u001d\u0006lWmR3o\u0011!9\u0003A!A!\u0002\u0013A\u0013A\u0001;y!\tIS&D\u0001+\u0015\t93F\u0003\u0002-\r\u00051QM\\4j]\u0016L!A\f\u0016\u0003\r!#H\u000f\u001d+y\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0014\u0001E:fgNLwN\u001c)s_\u000e,7o]8s!\t\u0011T'D\u00014\u0015\t!4&\u0001\u0005sKN\u0004xN\\:f\u0013\t14G\u0001\tTKN\u001c\u0018n\u001c8Qe>\u001cWm]:pe\"A\u0001\b\u0001B\u0001B\u0003%\u0011(\u0001\bti\u0006$8\u000f\u0015:pG\u0016\u001c8o\u001c:\u0011\u0005IR\u0014BA\u001e4\u00059\u0019F/\u0019;t!J|7-Z:t_JD\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\u000fI\u00164\u0017-\u001e7u\u0007\"\f'o]3u!\tyd)D\u0001A\u0015\t\t%)A\u0004dQ\u0006\u00148/\u001a;\u000b\u0005\r#\u0015a\u00018j_*\tQ)\u0001\u0003kCZ\f\u0017BA$A\u0005\u001d\u0019\u0005.\u0019:tKRDQ!\u0013\u0001\u0005\u0002)\u000ba\u0001P5oSRtD#B&N\u001d>\u0003\u0006C\u0001'\u0001\u001b\u0005\u0011\u0001\"B\u0014I\u0001\u0004A\u0003\"\u0002\u0019I\u0001\u0004\t\u0004\"\u0002\u001dI\u0001\u0004I\u0004\"B\u001fI\u0001\u0004q\u0004\"\u0002*\u0001\t\u0003\u0019\u0016AC8o\u0007>l\u0007\u000f\\3uKR\u0011A\u000b\u0019\t\u0005\u001fU;V,\u0003\u0002W!\t1A+\u001e9mKJ\u0002\"\u0001W.\u000e\u0003eS!A\u0017\u0012\u0002\u000fM,7o]5p]&\u0011A,\u0017\u0002\b'\u0016\u001c8/[8o!\u0011yalV,\n\u0005}\u0003\"!\u0003$v]\u000e$\u0018n\u001c82\u0011\u0015\t\u0017\u000b1\u0001c\u0003\u0019\u0011Xm];miB\u00111-Z\u0007\u0002I*\u0011AGB\u0005\u0003M\u0012\u0014!\u0002\u0013;uaJ+7/\u001e7u\u0011\u0015A\u0007\u0001\"\u0003j\u00035A\u0017M\u001c3mK\u001a\u000b\u0017\u000e\\;sKR\u0011AK\u001b\u0005\u0006W\u001e\u0004\r\u0001\\\u0001\bM\u0006LG.\u001e:f!\t\u0019W.\u0003\u0002oI\nY\u0001\n\u001e;q\r\u0006LG.\u001e:f\u0011\u0015\u0001\b\u0001\"\u0003r\u00039A\u0017M\u001c3mKJ+7\u000f]8og\u0016$\"\u0001\u0016:\t\u000bQz\u0007\u0019A:\u0011\u0005\r$\u0018BA;e\u0005!\u0011Vm\u001d9p]N,\u0007\"B<\u0001\t\u0013A\u0018a\u00045b]\u0012dWMU3ta>t7/\u001a\u0019\u0015\u0005ed\bC\u0001\u001a{\u0013\tY8GA\bQe>\u001cWm]:peJ+7/\u001e7u\u0011\u0015!d\u000f1\u0001t\u0001")
public class PollerResponseProcessor
implements StrictLogging,
NameGen {
    private final HttpTx tx;
    private final SessionProcessor sessionProcessor;
    private final StatsProcessor statsProcessor;
    private final Charset defaultCharset;
    private final Logger logger;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Tuple2<Session, Function1<Session, Session>> onComplete(HttpResult result) {
        Tuple2<Session, Function1<Session, Session>> tuple2;
        HttpResult httpResult = result;
        if (httpResult instanceof Response) {
            Response response = (Response)httpResult;
            tuple2 = this.handleResponse(response);
        } else if (httpResult instanceof HttpFailure) {
            HttpFailure httpFailure = (HttpFailure)httpResult;
            tuple2 = this.handleFailure(httpFailure);
        } else {
            throw new MatchError((Object)httpResult);
        }
        return tuple2;
    }

    private Tuple2<Session, Function1<Session, Session>> handleFailure(HttpFailure failure) {
        Session sessionWithUpdatedStats = this.sessionProcessor.updateSessionCrashed(this.tx.session(), failure.startTimestamp(), failure.endTimestamp());
        Function1 & Serializable & scala.Serializable updates = (Function1 & Serializable & scala.Serializable)x$1 -> $this.sessionProcessor.updateSessionCrashed((Session)x$1, failure.startTimestamp(), failure.endTimestamp());
        try {
            this.statsProcessor.reportStats(this.tx.fullRequestName(), this.tx.request().clientRequest(), sessionWithUpdatedStats, (Status)KO$.MODULE$, failure, (Option<String>)new Some((Object)failure.errorMessage()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable t = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(84).append("ResponseProcessor crashed while handling failure ").append(failure).append(" on session=").append(this.tx.session()).append(" request=").append(this.tx.request().requestName()).append(": ").append(this.tx.request().clientRequest()).append(", forwarding").toString(), t);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            throw throwable;
        }
        return new Tuple2((Object)sessionWithUpdatedStats, (Object)updates);
    }

    private Tuple2<Session, Function1<Session, Session>> handleResponse(Response response) {
        Tuple2 tuple2;
        Request clientRequest = this.tx.request().clientRequest();
        ProcessorResult processorResult = this.handleResponse0(response);
        if (processorResult instanceof Proceed) {
            Proceed proceed = (Proceed)processorResult;
            Session newSession = proceed.newSession();
            Function1<Session, Session> updates = proceed.updates();
            Option<String> errorMessage = proceed.error();
            KO$ status = errorMessage.isDefined() ? KO$.MODULE$ : OK$.MODULE$;
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, newSession, (Status)status, response, errorMessage);
            tuple2 = new Tuple2((Object)newSession, updates);
        } else if (processorResult instanceof Redirect) {
            BoxedUnit boxedUnit;
            Redirect redirect = (Redirect)processorResult;
            HttpTx redirectTx = redirect.redirectTx();
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, redirectTx.session(), (Status)OK$.MODULE$, response, (Option<String>)None$.MODULE$);
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Polling support doesn't support redirect atm");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            tuple2 = new Tuple2((Object)this.tx.session().markAsFailed(), (Object)Session$.MODULE$.Identity());
        } else if (processorResult instanceof Crash) {
            Crash crash = (Crash)processorResult;
            String errorMessage = crash.error();
            Session newSession = this.sessionProcessor.updateSessionCrashed(this.tx.session(), response.startTimestamp(), response.endTimestamp());
            Function1 & Serializable & scala.Serializable updates = (Function1 & Serializable & scala.Serializable)x$2 -> $this.sessionProcessor.updateSessionCrashed((Session)x$2, response.startTimestamp(), response.endTimestamp());
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, newSession, (Status)KO$.MODULE$, response, (Option<String>)new Some((Object)errorMessage));
            tuple2 = new Tuple2((Object)newSession, (Object)updates);
        } else {
            throw new MatchError((Object)processorResult);
        }
        return tuple2;
    }

    private ProcessorResult handleResponse0(Response response) {
        ProcessorResult processorResult;
        block16: {
            try {
                if (HttpHelper$.MODULE$.isRedirect(response.status()) && this.tx.request().requestConfig().followRedirect()) {
                    if (this.tx.redirectCount() >= this.tx.request().requestConfig().maxRedirects()) {
                        processorResult = new Crash(new StringBuilder(27).append("Too many redirects, max is ").append(this.tx.request().requestConfig().maxRedirects()).toString());
                    } else {
                        Crash crash;
                        Option<String> option = response.header(HeaderNames$.MODULE$.Location());
                        if (option instanceof Some) {
                            ProcessorResult processorResult2;
                            Some some = (Some)option;
                            String location = (String)some.value();
                            Uri redirectUri = HttpHelper$.MODULE$.resolveFromUri(this.tx.request().clientRequest().getUri(), location);
                            Session newSession = this.sessionProcessor.updatedRedirectSession(this.tx.session(), response, redirectUri);
                            Validation<Request> validation = RedirectProcessor$.MODULE$.redirectRequest(this.tx.request().clientRequest(), newSession, response.status(), this.tx.request().requestConfig().httpProtocol(), redirectUri, this.defaultCharset);
                            if (validation instanceof Success) {
                                Success success = (Success)validation;
                                Request redirectRequest = (Request)success.value();
                                HttpTx fresh$macro$3 = this.tx;
                                HttpTx fresh$macro$6 = (HttpTx)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable & scala.Serializable)(fresh$macro$1, fresh$macro$2) -> fresh$macro$1.copy((Session)fresh$macro$2.apply((Object)fresh$macro$1.session()), fresh$macro$1.copy$default$2(), fresh$macro$1.copy$default$3(), fresh$macro$1.copy$default$4(), fresh$macro$1.copy$default$5(), fresh$macro$1.copy$default$6())).setTo((Object)newSession);
                                HttpTx fresh$macro$9 = (HttpTx)new package.PathModify((Object)fresh$macro$6, (Function2 & Serializable & scala.Serializable)(fresh$macro$4, fresh$macro$5) -> {
                                    Request x$8 = (Request)fresh$macro$5.apply((Object)fresh$macro$4.request().clientRequest());
                                    String x$9 = fresh$macro$4.request().copy$default$1();
                                    HttpRequestConfig x$10 = fresh$macro$4.request().copy$default$3();
                                    HttpRequest x$11 = fresh$macro$4.request().copy(x$9, x$8, x$10);
                                    Session x$12 = fresh$macro$4.copy$default$1();
                                    Function1<Request, ResponseBuilder> x$13 = fresh$macro$4.copy$default$3();
                                    Action x$14 = fresh$macro$4.copy$default$4();
                                    Option<ResourceTx> x$15 = fresh$macro$4.copy$default$5();
                                    int x$16 = fresh$macro$4.copy$default$6();
                                    return fresh$macro$4.copy(x$12, x$11, x$13, x$14, x$15, x$16);
                                }).setTo((Object)redirectRequest);
                                processorResult2 = new Redirect((HttpTx)new package.PathModify((Object)fresh$macro$9, (Function2 & Serializable & scala.Serializable)(fresh$macro$7, fresh$macro$8) -> {
                                    int x$17 = fresh$macro$8.apply$mcII$sp(fresh$macro$7.redirectCount());
                                    Session x$18 = fresh$macro$7.copy$default$1();
                                    HttpRequest x$19 = fresh$macro$7.copy$default$2();
                                    Function1<Request, ResponseBuilder> x$20 = fresh$macro$7.copy$default$3();
                                    Action x$21 = fresh$macro$7.copy$default$4();
                                    Option<ResourceTx> x$22 = fresh$macro$7.copy$default$5();
                                    return fresh$macro$7.copy(x$18, x$19, x$20, x$21, x$22, x$17);
                                }).using((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$6 -> x$6 + 1));
                            } else if (validation instanceof Failure) {
                                Failure failure = (Failure)validation;
                                String message = failure.message();
                                processorResult2 = new Crash(message);
                            } else {
                                throw new MatchError(validation);
                            }
                            crash = processorResult2;
                        } else {
                            crash = new Crash("Redirect status, yet no Location header");
                        }
                        processorResult = crash;
                    }
                    break block16;
                }
                Tuple3<Session, Function1<Session, Session>, Option<String>> tuple3 = this.sessionProcessor.updatedSession(this.tx.session(), response, true);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                Session newSession = (Session)tuple3._1();
                Function1 updates = (Function1)tuple3._2();
                Option errorMessage = (Option)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)newSession, (Object)updates, (Object)errorMessage);
                Tuple3 tuple33 = tuple32;
                Session newSession2 = (Session)tuple33._1();
                Function1 updates2 = (Function1)tuple33._2();
                Option errorMessage2 = (Option)tuple33._3();
                processorResult = new Proceed(newSession2, (Function1<Session, Session>)updates2, (Option<String>)errorMessage2);
            }
            catch (Throwable throwable) {
                Throwable t;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    t = (Throwable)option.get();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringBuilder(85).append("ResponseProcessor crashed while handling response ").append(response.status()).append(" on session=").append(this.tx.session()).append(" request=").append(this.tx.request().requestName()).append(": ").append(this.tx.request().clientRequest()).append(", forwarding").toString(), t);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw throwable;
                }
                Crash crash = new Crash(Throwables.PimpedException$.MODULE$.detailedMessage$extension(Throwables$.MODULE$.PimpedException(t)));
                processorResult = crash;
            }
        }
        return processorResult;
    }

    public PollerResponseProcessor(HttpTx tx, SessionProcessor sessionProcessor, StatsProcessor statsProcessor, Charset defaultCharset) {
        this.tx = tx;
        this.sessionProcessor = sessionProcessor;
        this.statsProcessor = statsProcessor;
        this.defaultCharset = defaultCharset;
        StrictLogging.$init$((StrictLogging)this);
        NameGen.$init$((NameGen)this);
    }
}

