/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.http.action.sse.Closed$;
import io.gatling.http.action.sse.Open$;
import io.gatling.http.action.sse.Opening$;
import io.gatling.http.action.sse.SseException;
import io.gatling.http.action.sse.SseState;
import io.gatling.http.action.sse.fsm.EventStreamDispatcher;
import io.gatling.http.action.sse.fsm.ServerSentEvent;
import io.gatling.http.action.sse.fsm.SseReceived;
import io.gatling.http.action.sse.fsm.SseStream;
import io.gatling.http.action.sse.fsm.SseStreamClosed;
import io.gatling.http.action.sse.fsm.SseStreamConnected;
import io.gatling.http.action.sse.fsm.SseStreamCrashed;
import io.gatling.http.action.sse.fsm.SseStreamDecoder;
import io.gatling.http.client.HttpListener;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.net.InetSocketAddress;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u00015\u00111bU:f\u0019&\u001cH/\u001a8fe*\u00111\u0001B\u0001\u0004gN,'BA\u0003\u0007\u0003\u0019\t7\r^5p]*\u0011q\u0001C\u0001\u0005QR$\bO\u0003\u0002\n\u0015\u00059q-\u0019;mS:<'\"A\u0006\u0002\u0005%|7\u0001A\n\u0007\u000191BDI\u0013\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012\u0001\u00027b]\u001eT\u0011aE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016!\t1qJ\u00196fGR\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0004\u0002\r\rd\u0017.\u001a8u\u0013\tY\u0002D\u0001\u0007IiR\u0004H*[:uK:,'\u000f\u0005\u0002\u001eA5\taD\u0003\u0002 \u0005\u0005\u0019am]7\n\u0005\u0005r\"!C*tKN#(/Z1n!\ti2%\u0003\u0002%=\t)RI^3oiN#(/Z1n\t&\u001c\b/\u0019;dQ\u0016\u0014\bC\u0001\u0014.\u001b\u00059#B\u0001\u0015*\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tQ3&\u0001\u0005usB,7/\u00194f\u0015\u0005a\u0013aA2p[&\u0011af\n\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\t\u0011A\u0002!\u0011!Q\u0001\nE\n\u0001b]:f\u0003\u000e$xN\u001d\t\u0003e]j\u0011a\r\u0006\u0003iU\nQ!Y2u_JT\u0011AN\u0001\u0005C.\\\u0017-\u0003\u00029g\tA\u0011i\u0019;peJ+g\r\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0003-\u0019H/\u0019;t\u000b:<\u0017N\\3\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014!B:uCR\u001c(B\u0001!\t\u0003\u0011\u0019wN]3\n\u0005\tk$aC*uCR\u001cXI\\4j]\u0016D\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!R\u0001\u0006G2|7m\u001b\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000bA!\u001e;jY*\u0011!\nC\u0001\bG>lWn\u001c8t\u0013\tauIA\u0003DY>\u001c7\u000eC\u0003O\u0001\u0011\u0005q*\u0001\u0004=S:LGO\u0010\u000b\u0005!J\u001bF\u000b\u0005\u0002R\u00015\t!\u0001C\u00031\u001b\u0002\u0007\u0011\u0007C\u0003;\u001b\u0002\u00071\bC\u0003E\u001b\u0002\u0007Q\tC\u0004W\u0001\u0001\u0007I\u0011B,\u0002\t\u0011|g.Z\u000b\u00021B\u0011\u0011\fX\u0007\u00025*\t1,A\u0003tG\u0006d\u0017-\u0003\u0002^5\n9!i\\8mK\u0006t\u0007bB0\u0001\u0001\u0004%I\u0001Y\u0001\tI>tWm\u0018\u0013fcR\u0011\u0011\r\u001a\t\u00033\nL!a\u0019.\u0003\tUs\u0017\u000e\u001e\u0005\bKz\u000b\t\u00111\u0001Y\u0003\rAH%\r\u0005\u0007O\u0002\u0001\u000b\u0015\u0002-\u0002\u000b\u0011|g.\u001a\u0011\t\u000f%\u0004\u0001\u0019!C\u0005U\u0006)1\u000f^1uKV\t1\u000e\u0005\u0002RY&\u0011QN\u0001\u0002\t'N,7\u000b^1uK\"9q\u000e\u0001a\u0001\n\u0013\u0001\u0018!C:uCR,w\fJ3r)\t\t\u0017\u000fC\u0004f]\u0006\u0005\t\u0019A6\t\rM\u0004\u0001\u0015)\u0003l\u0003\u0019\u0019H/\u0019;fA!9Q\u000f\u0001b\u0001\n\u00131\u0018a\u00023fG>$WM]\u000b\u0002oB\u0011Q\u0004_\u0005\u0003sz\u0011\u0001cU:f'R\u0014X-Y7EK\u000e|G-\u001a:\t\rm\u0004\u0001\u0015!\u0003x\u0003!!WmY8eKJ\u0004\u0003\"C?\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u007f\u0003\u001d\u0019\u0007.\u00198oK2,\u0012a \t\u0005\u0003\u0003\tI!\u0004\u0002\u0002\u0004)\u0019Q0!\u0002\u000b\u0007\u0005\u001d!\"A\u0003oKR$\u00180\u0003\u0003\u0002\f\u0005\r!aB\"iC:tW\r\u001c\u0005\f\u0003\u001f\u0001\u0001\u0019!a\u0001\n\u0013\t\t\"A\u0006dQ\u0006tg.\u001a7`I\u0015\fHcA1\u0002\u0014!AQ-!\u0004\u0002\u0002\u0003\u0007q\u0010\u0003\u0006\u0002\u0018\u0001\u0001\r\u0011!Q!\n}\f\u0001b\u00195b]:,G\u000e\t\u0005\b\u00037\u0001A\u0011IA\u000f\u0003Myg\u000eV2q\u0007>tg.Z2u'V\u001c7-Z:t)\u0015\t\u0017qDA\u0018\u0011!\t\t#!\u0007A\u0002\u0005\r\u0012aB1eIJ,7o\u001d\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\n\u0002\u00079,G/\u0003\u0003\u0002.\u0005\u001d\"!E%oKR\u001cvnY6fi\u0006#GM]3tg\"1Q0!\u0007A\u0002}Dq!a\r\u0001\t\u0003\n)$\u0001\bp]\"#H\u000f\u001d*fgB|gn]3\u0015\u000b\u0005\f9$!\u0014\t\u0011\u0005e\u0012\u0011\u0007a\u0001\u0003w\taa\u001d;biV\u001c\b\u0003BA\u001f\u0003\u0013j!!a\u0010\u000b\u0007\u001d\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013!B2pI\u0016\u001c'\u0002BA$\u0003\u000b\tq\u0001[1oI2,'/\u0003\u0003\u0002L\u0005}\"A\u0005%uiB\u0014Vm\u001d9p]N,7\u000b^1ukND\u0001\"a\u0014\u00022\u0001\u0007\u0011\u0011K\u0001\bQ\u0016\fG-\u001a:t!\u0011\ti$a\u0015\n\t\u0005U\u0013q\b\u0002\f\u0011R$\b\u000fS3bI\u0016\u00148\u000fC\u0004\u0002Z\u0001!\t%a\u0017\u0002/=t\u0007\n\u001e;q%\u0016\u001c\bo\u001c8tK\n{G-_\"ik:\\G#B1\u0002^\u00055\u0004\u0002CA0\u0003/\u0002\r!!\u0019\u0002\u000b\rDWO\\6\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KRA!a\u001a\u0002\u0006\u00051!-\u001e4gKJLA!a\u001b\u0002f\t9!)\u001f;f\u0005V4\u0007bBA8\u0003/\u0002\r\u0001W\u0001\u0005Y\u0006\u001cH\u000fC\u0004\u0002t\u0001!\t%!\u001e\u0002\u0017=tG\u000b\u001b:po\u0006\u0014G.\u001a\u000b\u0004C\u0006]\u0004\u0002CA=\u0003c\u0002\r!a\u001f\u0002\u0013QD'o\\<bE2,\u0007\u0003BA?\u0003\u001bsA!a \u0002\n:!\u0011\u0011QAD\u001b\t\t\u0019IC\u0002\u0002\u00062\ta\u0001\u0010:p_Rt\u0014\"A.\n\u0007\u0005-%,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0015\u0011\u0013\u0002\n)\"\u0014xn^1cY\u0016T1!a#[\u0011\u001d\t)\n\u0001C\u0001\u0003/\u000bqb]3oI>sG\u000b\u001b:po\u0006\u0014G.\u001a\u000b\u0004C\u0006e\u0005\u0002CA=\u0003'\u0003\r!a\u001f\t\u000f\u0005u\u0005\u0001\"\u0011\u0002 \u0006)1\r\\8tKR\t\u0011\rC\u0004\u0002$\u0002!\t%!*\u0002'\u0011L7\u000f]1uG\",e/\u001a8u'R\u0014X-Y7\u0015\u0007\u0005\f9\u000bC\u0004\u0004\u0003C\u0003\r!!+\u0011\u0007u\tY+C\u0002\u0002.z\u0011qbU3sm\u0016\u00148+\u001a8u\u000bZ,g\u000e\u001e")
public class SseListener
implements HttpListener,
SseStream,
EventStreamDispatcher,
StrictLogging {
    private final ActorRef sseActor;
    private final Clock clock;
    private boolean done;
    private SseState state;
    private final SseStreamDecoder decoder;
    private Channel channel;
    private final Logger logger;

    public void onSend() {
        super.onSend();
    }

    public void onTcpConnectAttempt(InetSocketAddress x$1) {
        super.onTcpConnectAttempt(x$1);
    }

    public void onTcpConnectFailure(InetSocketAddress x$1, Throwable x$2) {
        super.onTcpConnectFailure(x$1, x$2);
    }

    public void onTlsHandshakeAttempt() {
        super.onTlsHandshakeAttempt();
    }

    public void onTlsHandshakeSuccess() {
        super.onTlsHandshakeSuccess();
    }

    public void onTlsHandshakeFailure(Throwable x$1) {
        super.onTlsHandshakeFailure(x$1);
    }

    public void onProtocolAwareness(boolean x$1) {
        super.onProtocolAwareness(x$1);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private boolean done() {
        return this.done;
    }

    private void done_$eq(boolean x$1) {
        this.done = x$1;
    }

    private SseState state() {
        return this.state;
    }

    private void state_$eq(SseState x$1) {
        this.state = x$1;
    }

    private SseStreamDecoder decoder() {
        return this.decoder;
    }

    private Channel channel() {
        return this.channel;
    }

    private void channel_$eq(Channel x$1) {
        this.channel = x$1;
    }

    public void onTcpConnectSuccess(InetSocketAddress address, Channel channel) {
        this.state_$eq(Open$.MODULE$);
        this.channel_$eq(channel);
    }

    public void onHttpResponse(HttpResponseStatus status, HttpHeaders headers) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Status {} received for SSE", new Object[]{BoxesRunTime.boxToInteger((int)status.code())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        HttpResponseStatus httpResponseStatus = status;
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        if (httpResponseStatus != null ? !httpResponseStatus.equals(httpResponseStatus2) : httpResponseStatus2 != null) {
            SseException ex = new SseException(status.code());
            this.onThrowable(ex);
            throw ex;
        }
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.sseActor);
        SseStreamConnected x$1 = new SseStreamConnected(this, this.clock.nowMillis());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void onHttpResponseBodyChunk(ByteBuf chunk, boolean last) {
        block1: {
            if (this.done()) break block1;
            Seq<ServerSentEvent> events = this.decoder().decodeStream(chunk);
            events.foreach((Function1 & Serializable & scala.Serializable)sse -> {
                this.dispatchEventStream(sse);
                return BoxedUnit.UNIT;
            });
            if (last) {
                this.close();
            }
        }
    }

    public void onThrowable(Throwable throwable) {
        block0: {
            if (this.done()) break block0;
            this.close();
            this.sendOnThrowable(throwable);
        }
    }

    public void sendOnThrowable(Throwable throwable) {
        BoxedUnit boxedUnit;
        String errorMessage = Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(throwable));
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Request failed", throwable);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Request failed: {}", new Object[]{errorMessage});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SseState sseState = this.state();
        boolean bl = Opening$.MODULE$.equals(sseState) ? true : Open$.MODULE$.equals(sseState);
        if (bl) {
            ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.sseActor);
            SseStreamCrashed x$3 = new SseStreamCrashed(throwable, this.clock.nowMillis());
            ActorRef x$4 = qual$2.$bang$default$2((Object)x$3);
            qual$2.$bang((Object)x$3, x$4);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (Closed$.MODULE$.equals(sseState)) {
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("unexpected state closed with error message: {}", new Object[]{errorMessage});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit3;
        } else {
            throw new MatchError((Object)sseState);
        }
    }

    @Override
    public void close() {
        block0: {
            this.done_$eq(true);
            if (this.channel() == null) break block0;
            this.channel().close();
            this.channel_$eq(null);
            ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.sseActor);
            SseStreamClosed x$5 = new SseStreamClosed(this.clock.nowMillis());
            ActorRef x$6 = qual$3.$bang$default$2((Object)x$5);
            qual$3.$bang((Object)x$5, x$6);
        }
    }

    @Override
    public void dispatchEventStream(ServerSentEvent sse) {
        ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(this.sseActor);
        SseReceived x$7 = new SseReceived(sse.asJsonString(), this.clock.nowMillis());
        ActorRef x$8 = qual$4.$bang$default$2((Object)x$7);
        qual$4.$bang((Object)x$7, x$8);
    }

    public SseListener(ActorRef sseActor, StatsEngine statsEngine, Clock clock) {
        this.sseActor = sseActor;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.done = false;
        this.state = Opening$.MODULE$;
        this.decoder = new SseStreamDecoder();
    }
}

