/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.response;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Failure;
import io.gatling.core.session.Session;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.check.HttpCheck;
import io.gatling.http.client.Request;
import io.gatling.http.client.ahc.uri.Uri;
import io.gatling.http.cookie.CookieSupport$;
import io.gatling.http.engine.response.CheckProcessor$;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ud!B\u0001\u0003\u0003Ci!\u0001E*fgNLwN\u001c)s_\u000e,7o]8s\u0015\t\u0019A!\u0001\u0005sKN\u0004xN\\:f\u0015\t)a!\u0001\u0004f]\u001eLg.\u001a\u0006\u0003\u000f!\tA\u0001\u001b;ua*\u0011\u0011BC\u0001\bO\u0006$H.\u001b8h\u0015\u0005Y\u0011AA5p\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!A!\u0002\u00131\u0012!\u00038piNKG.\u001a8u!\tyq#\u0003\u0002\u0019!\t9!i\\8mK\u0006t\u0007\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000fI,\u0017/^3tiB\u0011AdH\u0007\u0002;)\u0011aDB\u0001\u0007G2LWM\u001c;\n\u0005\u0001j\"a\u0002*fcV,7\u000f\u001e\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u000511\r[3dWN\u00042\u0001\n\u00170\u001d\t)#F\u0004\u0002'S5\tqE\u0003\u0002)\u0019\u00051AH]8pizJ\u0011!E\u0005\u0003WA\tq\u0001]1dW\u0006<W-\u0003\u0002.]\t!A*[:u\u0015\tY\u0003\u0003\u0005\u00021g5\t\u0011G\u0003\u00023\r\u0005)1\r[3dW&\u0011A'\r\u0002\n\u0011R$\bo\u00115fG.D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u0001\u000bQR$\boQ1dQ\u0016\u001c\bC\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0007\u0003\u0015\u0019\u0017m\u00195f\u0013\ta\u0014H\u0001\u0006IiR\u00048)Y2iKND\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaP\u0001\rQR$\b\u000f\u0015:pi>\u001cw\u000e\u001c\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u001a\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003\t\u0006\u0013A\u0002\u0013;uaB\u0013x\u000e^8d_2D\u0001B\u0012\u0001\u0003\u0002\u0003\u0006IaR\u0001\u0006G2|7m\u001b\t\u0003\u00116k\u0011!\u0013\u0006\u0003\u0015.\u000bA!\u001e;jY*\u0011A\nC\u0001\bG>lWn\u001c8t\u0013\tq\u0015JA\u0003DY>\u001c7\u000eC\u0003Q\u0001\u0011\u0005\u0011+\u0001\u0004=S:LGO\u0010\u000b\b%R+fk\u0016-Z!\t\u0019\u0006!D\u0001\u0003\u0011\u0015)r\n1\u0001\u0017\u0011\u0015Qr\n1\u0001\u001c\u0011\u0015\u0011s\n1\u0001$\u0011\u00151t\n1\u00018\u0011\u0015qt\n1\u0001@\u0011\u00151u\n1\u0001H\u0011\u0015Y\u0006\u0001\"\u0001]\u0003Q)\b\u000fZ1uKN+7o]5p]\u000e\u0013\u0018m\u001d5fIR!Q,\u001a4l!\tq6-D\u0001`\u0015\t\u0001\u0017-A\u0004tKN\u001c\u0018n\u001c8\u000b\u0005\tD\u0011\u0001B2pe\u0016L!\u0001Z0\u0003\u000fM+7o]5p]\")\u0001M\u0017a\u0001;\")qM\u0017a\u0001Q\u0006q1\u000f^1siRKW.Z:uC6\u0004\bCA\bj\u0013\tQ\u0007C\u0001\u0003M_:<\u0007\"\u00027[\u0001\u0004A\u0017\u0001D3oIRKW.Z:uC6\u0004\b\"\u00028\u0001\t\u0013y\u0017AE;qI\u0006$XmU3tg&|gn\u0015;biN$R!\u00189reNDQ\u0001Y7A\u0002uCQaZ7A\u0002!DQ\u0001\\7A\u0002!DQ\u0001^7A\u0002U\faa\u001d;biV\u001c\bC\u0001<z\u001b\u00059(B\u0001=L\u0003\u0015\u0019H/\u0019;t\u0013\tQxO\u0001\u0004Ti\u0006$Xo\u001d\u0005\u0006y\u0002!\t!`\u0001\u000fkB$\u0017\r^3e'\u0016\u001c8/[8o)\u001dq\u0018qDA\u0011\u0003[\u0001raD@^\u0003\u0007\tI!C\u0002\u0002\u0002A\u0011a\u0001V;qY\u0016\u001c\u0004#B\b\u0002\u0006uk\u0016bAA\u0004!\tIa)\u001e8di&|g.\r\t\u0006\u001f\u0005-\u0011qB\u0005\u0004\u0003\u001b\u0001\"AB(qi&|g\u000e\u0005\u0003\u0002\u0012\u0005ea\u0002BA\n\u0003+\u0001\"A\n\t\n\u0007\u0005]\u0001#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\tiB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003/\u0001\u0002\"\u00021|\u0001\u0004i\u0006BB\u0002|\u0001\u0004\t\u0019\u0003\u0005\u0003\u0002&\u0005%RBAA\u0014\u0015\t\u0019a!\u0003\u0003\u0002,\u0005\u001d\"\u0001\u0003*fgB|gn]3\t\r\u0005=2\u00101\u0001\u0017\u00039\u0019w.\u001c9vi\u0016,\u0006\u000fZ1uKNDq!a\r\u0001\t\u0003\t)$\u0001\fva\u0012\fG/\u001a3SK\u0012L'/Z2u'\u0016\u001c8/[8o)\u001di\u0016qGA\u001d\u0003wAa\u0001YA\u0019\u0001\u0004i\u0006bB\u0002\u00022\u0001\u0007\u00111\u0005\u0005\t\u0003{\t\t\u00041\u0001\u0002@\u0005Y!/\u001a3je\u0016\u001cG/\u0016:j!\u0011\t\t%a\u0013\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\n1!\u001e:j\u0015\r\tI%H\u0001\u0004C\"\u001c\u0017\u0002BA'\u0003\u0007\u00121!\u0016:j\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'\nQbY1dQ\u0016\u0014V\rZ5sK\u000e$HcB/\u0002V\u0005]\u0013\u0011\f\u0005\u0007A\u0006=\u0003\u0019A/\t\u000f\r\ty\u00051\u0001\u0002$!A\u0011QHA(\u0001\u0004\ty\u0004C\u0004\u0002^\u00011\t\"a\u0018\u0002\u001bU\u0004H-\u0019;f%\u00164WM]3s)\u0015i\u0016\u0011MA2\u0011\u0019\u0001\u00171\fa\u0001;\"91!a\u0017A\u0002\u0005\r\u0002bBA4\u0001\u0019E\u0011\u0011N\u0001\u0011kB$\u0017\r^3He>,\bo\u0015;biN$\u0012\"XA6\u0003[\ny'!\u001d\t\r\u0001\f)\u00071\u0001^\u0011\u00199\u0017Q\ra\u0001Q\"1A.!\u001aA\u0002!Da\u0001^A3\u0001\u0004)\u0018&\u0002\u0001\u0002v\u0005e\u0014bAA<\u0005\tA\"+Z:pkJ\u001cWmU3tg&|g\u000e\u0015:pG\u0016\u001c8o\u001c:\n\u0007\u0005m$A\u0001\u000bS_>$8+Z:tS>t\u0007K]8dKN\u001cxN\u001d")
public abstract class SessionProcessor {
    private final boolean notSilent;
    private final Request request;
    private final List<HttpCheck> checks;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final Clock clock;

    public Session updateSessionCrashed(Session session, long startTimestamp, long endTimestamp) {
        return this.updateSessionStats(session, startTimestamp, endTimestamp, (Status)KO$.MODULE$);
    }

    private Session updateSessionStats(Session session, long startTimestamp, long endTimestamp, Status status) {
        Session session2;
        if (this.notSilent) {
            Status status2 = status;
            KO$ kO$ = KO$.MODULE$;
            Session sessionWithUpdatedStatus = !(status2 != null ? !status2.equals(kO$) : kO$ != null) ? session.markAsFailed() : session;
            session2 = this.updateGroupStats(sessionWithUpdatedStatus, startTimestamp, endTimestamp, status);
        } else {
            session2 = session;
        }
        return session2;
    }

    public Tuple3<Session, Function1<Session, Session>, Option<String>> updatedSession(Session session, Response response, boolean computeUpdates) {
        Tuple3<Session, Function1<Session, Session>, Option<Failure>> tuple3 = CheckProcessor$.MODULE$.check(session, response, this.checks, computeUpdates);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Session sessionWithCheckSavedValues = (Session)tuple3._1();
        Function1 checkUpdates = (Function1)tuple3._2();
        Option checkError = (Option)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)sessionWithCheckSavedValues, (Object)checkUpdates, (Object)checkError);
        Tuple3 tuple33 = tuple32;
        Session sessionWithCheckSavedValues2 = (Session)tuple33._1();
        Function1 checkUpdates2 = (Function1)tuple33._2();
        Option checkError2 = (Option)tuple33._3();
        Session sessionWithHttp2PriorKnowledge = this.httpProtocol.requestPart().enableHttp2() ? this.httpCaches.updateSessionHttp2PriorKnowledge(sessionWithCheckSavedValues2, response) : sessionWithCheckSavedValues2;
        KO$ newStatus = checkError2.isDefined() ? KO$.MODULE$ : OK$.MODULE$;
        Session newSession = this.updateSessionAfterChecks$1(sessionWithHttp2PriorKnowledge, (Status)newStatus, response);
        Function1 updates = computeUpdates ? checkUpdates2.andThen((Function1 & Serializable & scala.Serializable)x$2 -> $this.httpCaches.updateSessionHttp2PriorKnowledge((Session)x$2, response)).andThen(arg_0 -> SessionProcessor.$anonfun$updatedSession$2(this, response, (Status)newStatus, arg_0)) : x -> (Session)Predef$.MODULE$.identity(x);
        return new Tuple3((Object)newSession, (Object)updates, (Object)checkError2.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.message()));
    }

    public Session updatedRedirectSession(Session session, Response response, Uri redirectUri) {
        Session sessionWithCookieStoreUpdate = CookieSupport$.MODULE$.storeCookies(session, this.request.getUri(), response.cookies(), this.clock.nowMillis());
        Session sessionWithGroupUpdate = this.updateSessionStats(sessionWithCookieStoreUpdate, response.startTimestamp(), response.endTimestamp(), (Status)OK$.MODULE$);
        return this.cacheRedirect(sessionWithGroupUpdate, response, redirectUri);
    }

    private Session cacheRedirect(Session session, Response response, Uri redirectUri) {
        return this.httpProtocol.requestPart().cache() && HttpHelper$.MODULE$.isPermanentRedirect(response.status()) ? this.httpCaches.addRedirect(session, this.request, redirectUri) : session;
    }

    public abstract Session updateReferer(Session var1, Response var2);

    public abstract Session updateGroupStats(Session var1, long var2, long var4, Status var6);

    private final Session updateSessionAfterChecks$1(Session s1, Status status, Response response$1) {
        Session s2 = CookieSupport$.MODULE$.storeCookies(s1, this.request.getUri(), response$1.cookies(), this.clock.nowMillis());
        Session s3 = this.updateReferer(s2, response$1);
        Session s4 = this.httpCaches.cacheContent(s3, this.httpProtocol, this.request, response$1);
        return this.updateSessionStats(s4, response$1.startTimestamp(), response$1.endTimestamp(), status);
    }

    public static final /* synthetic */ Session $anonfun$updatedSession$2(SessionProcessor $this, Response response$1, Status newStatus$1, Session x$3) {
        return $this.updateSessionAfterChecks$1(x$3, newStatus$1, response$1);
    }

    public SessionProcessor(boolean notSilent, Request request, List<HttpCheck> checks, HttpCaches httpCaches, HttpProtocol httpProtocol, Clock clock) {
        this.notSilent = notSilent;
        this.request = request;
        this.checks = checks;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.clock = clock;
    }
}

