/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.fetch;

import com.softwaremill.quicklens.package;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.action.Action;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Request;
import io.gatling.http.client.ahc.uri.Uri;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.HttpTxExecutor;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.fetch.ResourceAggregator;
import io.gatling.http.fetch.ResourceFetcher;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.protocol.Remote;
import io.gatling.http.protocol.Remote$;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.response.ResponseBuilder;
import io.gatling.http.response.ResponseBuilder$;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5f\u0001B\u0001\u0003\u0001-\u0011\u0011\u0004R3gCVdGOU3t_V\u00148-Z!hOJ,w-\u0019;pe*\u00111\u0001B\u0001\u0006M\u0016$8\r\u001b\u0006\u0003\u000b\u0019\tA\u0001\u001b;ua*\u0011q\u0001C\u0001\bO\u0006$H.\u001b8h\u0015\u0005I\u0011AA5p\u0007\u0001\u0019B\u0001\u0001\u0007\u0013-A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003%I+7o\\;sG\u0016\fum\u001a:fO\u0006$xN\u001d\t\u0003/yi\u0011\u0001\u0007\u0006\u00033i\tAb]2bY\u0006dwnZ4j]\u001eT!a\u0007\u000f\u0002\u0011QL\b/Z:bM\u0016T\u0011!H\u0001\u0004G>l\u0017BA\u0010\u0019\u00055\u0019FO]5di2{wmZ5oO\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\u0004s_>$H\u000b\u001f\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\n!\u0001\u001e=\u000b\u0005\u001d\"\u0011AB3oO&tW-\u0003\u0002*I\t1\u0001\n\u001e;q)bD\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\u0011S:LG/[1m%\u0016\u001cx.\u001e:dKN\u00042!L\u001b9\u001d\tq3G\u0004\u00020e5\t\u0001G\u0003\u00022\u0015\u00051AH]8pizJ\u0011aD\u0005\u0003i9\tq\u0001]1dW\u0006<W-\u0003\u00027o\t\u00191+Z9\u000b\u0005Qr\u0001CA\u001d=\u001b\u0005Q$BA\u001e\u0005\u0003\u001d\u0011X-];fgRL!!\u0010\u001e\u0003\u0017!#H\u000f\u001d*fcV,7\u000f\u001e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\u0006Q\u0001\u000e\u001e;q\u0007\u0006\u001c\u0007.Z:\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r#\u0011!B2bG\",\u0017BA#C\u0005)AE\u000f\u001e9DC\u000eDWm\u001d\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\u0006y!/Z:pkJ\u001cWMR3uG\",'\u000f\u0005\u0002\u0014\u0013&\u0011!J\u0001\u0002\u0010%\u0016\u001cx.\u001e:dK\u001a+Go\u00195fe\"AA\n\u0001B\u0001B\u0003%Q*\u0001\biiR\u0004H\u000b_#yK\u000e,Ho\u001c:\u0011\u0005\rr\u0015BA(%\u00059AE\u000f\u001e9Uq\u0016CXmY;u_JD\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IAU\u0001\u0006G2|7m\u001b\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000bA!\u001e;jY*\u0011qKB\u0001\bG>lWn\u001c8t\u0013\tIFKA\u0003DY>\u001c7\u000e\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003]\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\u0007G>tg-[4\u000b\u0005\u00054\u0011\u0001B2pe\u0016L!a\u00190\u0003)\u001d\u000bG\u000f\\5oO\u000e{gNZ5hkJ\fG/[8o\u0011\u0015)\u0007\u0001\"\u0001g\u0003\u0019a\u0014N\\5u}QAq\r[5kW2lg\u000e\u0005\u0002\u0014\u0001!)\u0011\u0005\u001aa\u0001E!)1\u0006\u001aa\u0001Y!)q\b\u001aa\u0001\u0001\")q\t\u001aa\u0001\u0011\")A\n\u001aa\u0001\u001b\")\u0011\u000b\u001aa\u0001%\")1\f\u001aa\u00019\"9\u0001\u000f\u0001b\u0001\n\u0013\t\u0018!\u0003;ie>$H\u000f\\3e+\u0005\u0011\bCA\u0007t\u0013\t!hBA\u0004C_>dW-\u00198\t\rY\u0004\u0001\u0015!\u0003s\u0003)!\bN]8ui2,G\r\t\u0005\bq\u0002\u0011\r\u0011\"\u0003z\u00031AG\u000f\u001e9Qe>$xnY8m+\u0005Q\bCA>\u007f\u001b\u0005a(BA?\u0005\u0003!\u0001(o\u001c;pG>d\u0017BA@}\u00051AE\u000f\u001e9Qe>$xnY8m\u0011\u001d\t\u0019\u0001\u0001Q\u0001\ni\fQ\u0002\u001b;uaB\u0013x\u000e^8d_2\u0004\u0003bCA\u0004\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0013\tqa]3tg&|g.\u0006\u0002\u0002\fA!\u0011QBA\t\u001b\t\tyAC\u0002\u0002\b\u0001LA!a\u0005\u0002\u0010\t91+Z:tS>t\u0007bCA\f\u0001\u0001\u0007\t\u0019!C\u0005\u00033\t1b]3tg&|gn\u0018\u0013fcR!\u00111DA\u0011!\ri\u0011QD\u0005\u0004\u0003?q!\u0001B+oSRD!\"a\t\u0002\u0016\u0005\u0005\t\u0019AA\u0006\u0003\rAH%\r\u0005\f\u0003O\u0001\u0001\u0019!A!B\u0013\tY!\u0001\u0005tKN\u001c\u0018n\u001c8!\u0011%\tY\u0003\u0001b\u0001\n\u0013\ti#A\u0006bYJ,\u0017\rZ=TK\u0016tWCAA\u0018!\u0019\t\t$a\u000f\u0002@5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$A\u0004nkR\f'\r\\3\u000b\u0007\u0005eb\"\u0001\u0006d_2dWm\u0019;j_:LA!!\u0010\u00024\t\u00191+\u001a;\u0011\t\u0005\u0005\u0013qJ\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005\u0019QO]5\u000b\t\u0005%\u00131J\u0001\u0004C\"\u001c'bAA'\t\u000511\r\\5f]RLA!!\u0015\u0002D\t\u0019QK]5\t\u0011\u0005U\u0003\u0001)A\u0005\u0003_\tA\"\u00197sK\u0006$\u0017pU3f]\u0002B\u0011\"!\u0017\u0001\u0005\u0004%I!a\u0017\u0002/\t,hMZ3sK\u0012\u0014Vm]8ve\u000e,7OQ=I_N$XCAA/!!\t\t$a\u0018\u0002d\u0005%\u0014\u0002BA1\u0003g\u00111!T1q!\rY\u0018QM\u0005\u0004\u0003Ob(A\u0002*f[>$X\r\u0005\u0003.\u0003WB\u0014bAA7o\t!A*[:u\u0011!\t\t\b\u0001Q\u0001\n\u0005u\u0013\u0001\u00072vM\u001a,'/\u001a3SKN|WO]2fg\nK\bj\\:uA!I\u0011Q\u000f\u0001C\u0002\u0013%\u0011qO\u0001\u0016[\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t!\u0016\u0014\bj\\:u+\t\tI\bE\u0002\u000e\u0003wJ1!! \u000f\u0005\rIe\u000e\u001e\u0005\t\u0003\u0003\u0003\u0001\u0015!\u0003\u0002z\u00051R.\u0019=D_:tWm\u0019;j_:\u001c\b+\u001a:I_N$\b\u0005C\u0005\u0002\u0006\u0002\u0011\r\u0011\"\u0003\u0002\b\u0006)\u0012M^1jY\u0006\u0014G.\u001a+pW\u0016t7OQ=I_N$XCAAE!!\t\t$a\u0018\u0002d\u0005e\u0004\u0002CAG\u0001\u0001\u0006I!!#\u0002-\u00054\u0018-\u001b7bE2,Gk\\6f]N\u0014\u0015\u0010S8ti\u0002B\u0011\"!%\u0001\u0001\u0004%I!a\u001e\u0002+A,g\u000eZ5oOJ+7o\\;sG\u0016\u001c8i\\;oi\"I\u0011Q\u0013\u0001A\u0002\u0013%\u0011qS\u0001\u001aa\u0016tG-\u001b8h%\u0016\u001cx.\u001e:dKN\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\u0005e\u0005BCA\u0012\u0003'\u000b\t\u00111\u0001\u0002z!A\u0011Q\u0014\u0001!B\u0013\tI(\u0001\fqK:$\u0017N\\4SKN|WO]2fg\u000e{WO\u001c;!\u0011%\t\t\u000b\u0001a\u0001\n\u0013\t\u0019+\u0001\u0007hY>\u0014\u0017\r\\*uCR,8/\u0006\u0002\u0002&B!\u0011qUAW\u001b\t\tIKC\u0002\u0002,Z\u000bQa\u001d;biNLA!a,\u0002*\n11\u000b^1ukND\u0011\"a-\u0001\u0001\u0004%I!!.\u0002!\u001ddwNY1m'R\fG/^:`I\u0015\fH\u0003BA\u000e\u0003oC!\"a\t\u00022\u0006\u0005\t\u0019AAS\u0011!\tY\f\u0001Q!\n\u0005\u0015\u0016!D4m_\n\fGn\u0015;biV\u001c\b\u0005C\u0005\u0002@\u0002\u0011\r\u0011\"\u0003\u0002B\u0006q1\u000f^1siRKW.Z:uC6\u0004XCAAb!\ri\u0011QY\u0005\u0004\u0003\u000ft!\u0001\u0002'p]\u001eD\u0001\"a3\u0001A\u0003%\u00111Y\u0001\u0010gR\f'\u000f\u001e+j[\u0016\u001cH/Y7qA!9\u0011q\u001a\u0001\u0005B\u0005%\u0011AD2veJ,g\u000e^*fgNLwN\u001c\u0005\b\u0003'\u0004A\u0011IAk\u0003\u0015\u0019H/\u0019:u)\u0011\tY\"a6\t\u0011\u0005\u001d\u0011\u0011\u001ba\u0001\u0003\u0017Aq!a7\u0001\t\u0013\ti.\u0001\tde\u0016\fG/\u001a*fg>,(oY3UqR)!%a8\u0002d\"9\u0011\u0011]Am\u0001\u0004A\u0014\u0001\u0003:fg>,(oY3\t\u0011\u0005\u0015\u0018\u0011\u001ca\u0001\u0003O\fQ#[:IiR\u0004(\u0007\u0015:j_J\\en\\<mK\u0012<W\r\u0005\u0003\u000e\u0003S\u0014\u0018bAAv\u001d\t1q\n\u001d;j_:Dq!a<\u0001\t\u0013\t\t0\u0001\u000biC:$G.Z\"bG\",GMU3t_V\u00148-\u001a\u000b\u0005\u00037\t\u0019\u0010C\u0004\u0002b\u00065\b\u0019\u0001\u001d\t\u000f\u0005]\b\u0001\"\u0003\u0002z\u00061b-\u001a;dQ>\u0013()\u001e4gKJ\u0014Vm]8ve\u000e,7\u000f\u0006\u0003\u0002\u001c\u0005m\b\u0002CA\u007f\u0003k\u0004\r!a@\u0002\u0013I,7o\\;sG\u0016\u001c\b\u0003B\u0017\u0003\u0002aJ1Aa\u00018\u0005!IE/\u001a:bE2,\u0007b\u0002B\u0004\u0001\u0011%!\u0011B\u0001\u0005I>tW\r\u0006\u0002\u0002\u001c!9!Q\u0002\u0001\u0005\n\t=\u0011aE:f]\u0012\u0014UO\u001a4fe\u0016$'+Z9vKN$HCBA\u000e\u0005#\u0011\u0019\u0002\u0003\u0004<\u0005\u0017\u0001\r\u0001\u000f\u0005\t\u0005+\u0011Y\u00011\u0001\u0002d\u00051!/Z7pi\u0016DqA!\u0007\u0001\t\u0013\u0011Y\"A\fsK2,\u0017m]3U_.,g.\u00118e\u0007>tG/\u001b8vKR1\u00111\u0004B\u000f\u0005?A\u0001B!\u0006\u0003\u0018\u0001\u0007\u00111\r\u0005\b\u0005C\u00119\u00021\u0001s\u0003\u001dI7\u000f\u0013;uaJBqA!\n\u0001\t\u0013\u00119#A\bsKN|WO]2f\r\u0016$8\r[3e))\tYB!\u000b\u0003,\t=\"1\u0007\u0005\t\u0005+\u0011\u0019\u00031\u0001\u0002d!A!Q\u0006B\u0012\u0001\u0004\t)+\u0001\u0004ti\u0006$Xo\u001d\u0005\b\u0005c\u0011\u0019\u00031\u0001s\u0003\u0019\u0019\u0018\u000e\\3oi\"9!\u0011\u0005B\u0012\u0001\u0004\u0011\bb\u0002B\u001c\u0001\u0011%!\u0011H\u0001\u000bGN\u001ch)\u001a;dQ\u0016$G\u0003DA\u000e\u0005w\u0011iDa\u0010\u0003Z\t=\u0004\u0002CA#\u0005k\u0001\r!a\u0010\t\u0011\t5\"Q\u0007a\u0001\u0003KC\u0001B!\u0011\u00036\u0001\u0007!1I\u0001\u000fe\u0016\u001c\bo\u001c8tKN#\u0018\r^;t!\u0011\u0011)E!\u0016\u000e\u0005\t\u001d#bA\u0003\u0003J)!!1\nB'\u0003\u0015\u0019w\u000eZ3d\u0015\u0011\u0011yE!\u0015\u0002\u000f!\fg\u000e\u001a7fe*\u0019!1\u000b\u0005\u0002\u000b9,G\u000f^=\n\t\t]#q\t\u0002\u0013\u0011R$\bOU3ta>t7/Z*uCR,8\u000f\u0003\u0005\u0003\\\tU\u0002\u0019\u0001B/\u0003Ia\u0017m\u001d;N_\u0012Lg-[3e\u001fJ,E/Y4\u0011\u000b5\tIOa\u0018\u0011\t\t\u0005$\u0011\u000e\b\u0005\u0005G\u0012)\u0007\u0005\u00020\u001d%\u0019!q\r\b\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011YG!\u001c\u0003\rM#(/\u001b8h\u0015\r\u00119G\u0004\u0005\t\u0005c\u0012)\u00041\u0001\u0003`\u000591m\u001c8uK:$\bb\u0002B;\u0001\u0011\u0005#qO\u0001\u0019_:\u0014VmZ;mCJ\u0014Vm]8ve\u000e,g)\u001a;dQ\u0016$GCCA\u000e\u0005s\u0012YH! \u0003\u0000!A\u0011Q\tB:\u0001\u0004\ty\u0004\u0003\u0005\u0003.\tM\u0004\u0019AAS\u0011!\t9Aa\u001dA\u0002\u0005-\u0001b\u0002B\u0019\u0005g\u0002\rA\u001d\u0005\b\u0005\u0007\u0003A\u0011\tBC\u0003QygnQ:t%\u0016\u001cx.\u001e:dK\u001a+Go\u00195fIR\u0001\u00121\u0004BD\u0005\u0013\u0013YI!$\u0003\u0010\nE%1\u0013\u0005\t\u0003\u000b\u0012\t\t1\u0001\u0002@!A!Q\u0006BA\u0001\u0004\t)\u000b\u0003\u0005\u0002\b\t\u0005\u0005\u0019AA\u0006\u0011\u001d\u0011\tD!!A\u0002ID\u0001B!\u0011\u0003\u0002\u0002\u0007!1\t\u0005\t\u00057\u0012\t\t1\u0001\u0003^!A!\u0011\u000fBA\u0001\u0004\u0011y\u0006C\u0004\u0003\u0018\u0002!\tE!'\u0002\u0015=t'+\u001a3je\u0016\u001cG\u000f\u0006\u0004\u0002\u001c\tm%q\u0014\u0005\b\u0005;\u0013)\n1\u0001#\u0003)y'/[4j]\u0006dG\u000b\u001f\u0005\b\u0005C\u0013)\n1\u0001#\u0003)\u0011X\rZ5sK\u000e$H\u000b\u001f\u0005\b\u0005K\u0003A\u0011\tBT\u0003AygnQ1dQ\u0016$'+Z:pkJ\u001cW\r\u0006\u0004\u0002\u001c\t%&1\u0016\u0005\t\u0003\u000b\u0012\u0019\u000b1\u0001\u0002@!1QEa)A\u0002\t\u0002")
public class DefaultResourceAggregator
implements ResourceAggregator,
StrictLogging {
    private final HttpTx rootTx;
    private final Seq<HttpRequest> initialResources;
    private final HttpCaches httpCaches;
    private final ResourceFetcher resourceFetcher;
    private final HttpTxExecutor httpTxExecutor;
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final boolean throttled;
    private final HttpProtocol httpProtocol;
    private Session session;
    private final Set<Uri> alreadySeen;
    private final Map<Remote, List<HttpRequest>> bufferedResourcesByHost;
    private final int maxConnectionsPerHost;
    private final Map<Remote, Object> availableTokensByHost;
    private int pendingResourcesCount;
    private Status globalStatus;
    private final long startTimestamp;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private boolean throttled() {
        return this.throttled;
    }

    private HttpProtocol httpProtocol() {
        return this.httpProtocol;
    }

    private Session session() {
        return this.session;
    }

    private void session_$eq(Session x$1) {
        this.session = x$1;
    }

    private Set<Uri> alreadySeen() {
        return this.alreadySeen;
    }

    private Map<Remote, List<HttpRequest>> bufferedResourcesByHost() {
        return this.bufferedResourcesByHost;
    }

    private int maxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    private Map<Remote, Object> availableTokensByHost() {
        return this.availableTokensByHost;
    }

    private int pendingResourcesCount() {
        return this.pendingResourcesCount;
    }

    private void pendingResourcesCount_$eq(int x$1) {
        this.pendingResourcesCount = x$1;
    }

    private Status globalStatus() {
        return this.globalStatus;
    }

    private void globalStatus_$eq(Status x$1) {
        this.globalStatus = x$1;
    }

    private long startTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public Session currentSession() {
        return this.session();
    }

    @Override
    public void start(Session session) {
        this.session_$eq(session);
        this.fetchOrBufferResources((Iterable<HttpRequest>)this.initialResources);
    }

    private HttpTx createResourceTx(HttpRequest resource, Option<Object> isHttp2PriorKnowledge) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Fetching resource {}", new Object[]{resource.clientRequest().getUri()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Function1<Request, ResponseBuilder> responseBuilderFactory = ResponseBuilder$.MODULE$.newResponseBuilderFactory(resource.requestConfig().checks(), this.httpProtocol().responsePart().inferHtmlResources(), this.clock, this.configuration);
        boolean isAlpnRequired = this.rootTx.request().clientRequest().isHttp2Enabled() && isHttp2PriorKnowledge.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultResourceAggregator.$anonfun$createResourceTx$1(BoxesRunTime.unboxToBoolean((Object)x$1))));
        Session x$15 = this.session();
        HttpRequest fresh$macro$54 = resource;
        HttpRequest x$16 = (HttpRequest)new package.PathModify((Object)fresh$macro$54, (Function2 & Serializable & scala.Serializable)(fresh$macro$52, fresh$macro$53) -> {
            Request x$12 = (Request)fresh$macro$53.apply((Object)fresh$macro$52.clientRequest());
            String x$13 = fresh$macro$52.copy$default$1();
            HttpRequestConfig x$14 = fresh$macro$52.copy$default$3();
            return fresh$macro$52.copy(x$13, x$12, x$14);
        }).using((Function1 & Serializable & scala.Serializable)x$3 -> x$3.copyWithAlpnRequiredAndPriorKnowledge(isAlpnRequired, isHttp2PriorKnowledge.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        Function1<Request, ResponseBuilder> x$17 = responseBuilderFactory;
        Some x$18 = new Some((Object)new ResourceTx(this, resource.clientRequest().getUri()));
        int x$19 = 0;
        Action x$20 = this.rootTx.copy$default$4();
        HttpTx resourceTx = this.rootTx.copy(x$15, x$16, x$17, x$20, (Option<ResourceTx>)x$18, x$19);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Creating resourceTx {}", new Object[]{resourceTx});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return resourceTx;
    }

    private void handleCachedResource(HttpRequest resource) {
        BoxedUnit boxedUnit;
        Uri uri = resource.clientRequest().getUri();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Fetching resource {} from cache", new Object[]{uri});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean silent = resource.isSilent(false);
        if (this.httpCaches.isCssCached(uri)) {
            this.onCssResourceFetched(uri, (Status)OK$.MODULE$, this.session(), silent, HttpResponseStatus.NOT_MODIFIED, (Option<String>)None$.MODULE$, "");
        } else {
            this.onRegularResourceFetched(uri, (Status)OK$.MODULE$, this.session(), silent);
        }
    }

    private void fetchOrBufferResources(Iterable<HttpRequest> resources) {
        this.alreadySeen().$plus$plus$eq((TraversableOnce)resources.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.clientRequest().getUri(), Iterable$.MODULE$.canBuildFrom()));
        this.pendingResourcesCount_$eq(this.pendingResourcesCount() + resources.size());
        Tuple2 tuple2 = resources.partition((Function1 & Serializable & scala.Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)DefaultResourceAggregator.$anonfun$fetchOrBufferResources$3(this, resource)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable cached = (Iterable)tuple2._1();
        Iterable nonCached = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)cached, (Object)nonCached);
        Tuple2 tuple23 = tuple22;
        Iterable cached2 = (Iterable)tuple23._1();
        Iterable nonCached2 = (Iterable)tuple23._2();
        cached2.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            this.handleCachedResource(resource);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map requestsByRemote = nonCached2.groupBy((Function1 & Serializable & scala.Serializable)resource -> Remote$.MODULE$.apply(resource.clientRequest().getUri()));
        if (this.httpProtocol().requestPart().enableHttp2()) {
            requestsByRemote.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DefaultResourceAggregator.$anonfun$fetchOrBufferResources$6(this, resources, x0$1);
                return BoxedUnit.UNIT;
            });
        } else {
            requestsByRemote.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                DefaultResourceAggregator.$anonfun$fetchOrBufferResources$8(this, x0$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void done() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("All resources were fetched");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Session newSession = this.rootTx.silent() ? this.session() : this.session().logGroupRequest(this.startTimestamp(), this.clock.nowMillis(), this.globalStatus());
        this.rootTx.next().$bang(newSession);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendBufferedRequest(HttpRequest request, Remote remote) {
        Option<Object> option;
        Some some;
        ContentCacheEntry contentCacheEntry;
        Option<ContentCacheEntry> option2 = this.httpCaches.contentCacheEntry(this.session(), request.clientRequest());
        if (None$.MODULE$.equals(option2)) {
            this.httpTxExecutor.execute(this.createResourceTx(request, this.httpCaches.isHttp2PriorKnowledge(this.session(), remote)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (option2 instanceof Some && (contentCacheEntry = (ContentCacheEntry)(some = (Some)option2).value()) != null && (option = contentCacheEntry.expires()) instanceof Some) {
            Some some2 = (Some)option;
            long expire = BoxesRunTime.unboxToLong((Object)some2.value());
            if (this.clock.nowMillis() > expire) {
                this.session_$eq(this.httpCaches.clearContentCache(this.session(), request.clientRequest()));
                this.httpTxExecutor.execute(this.createResourceTx(request, this.httpCaches.isHttp2PriorKnowledge(this.session(), remote)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        this.handleCachedResource(request);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void releaseTokenAndContinue(Remote remote, boolean isHttp2) {
        Some some;
        List list;
        Option option = this.bufferedResourcesByHost().get((Object)remote);
        boolean bl = option instanceof Some && Nil$.MODULE$.equals(list = (List)(some = (Some)option).value()) ? true : None$.MODULE$.equals(option);
        if (bl) {
            int availableToken = BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)remote));
            this.availableTokensByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)(availableToken == this.maxConnectionsPerHost() ? BoxesRunTime.boxToInteger((int)availableToken) : BoxesRunTime.boxToInteger((int)(availableToken + 1)))));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some2 = (Some)option;
            List requests = (List)some2.value();
            if (isHttp2) {
                this.bufferedResourcesByHost().remove((Object)remote);
                requests.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                    this.sendBufferedRequest(x$9, remote);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                List list2 = requests;
                if (!(list2 instanceof .colon.colon)) {
                    throw new MatchError((Object)list2);
                }
                .colon.colon colon2 = (.colon.colon)list2;
                HttpRequest request = (HttpRequest)colon2.head();
                List tail = colon2.tl$access$1();
                Tuple2 tuple2 = new Tuple2((Object)request, (Object)tail);
                Tuple2 tuple22 = tuple2;
                HttpRequest request2 = (HttpRequest)tuple22._1();
                List tail2 = (List)tuple22._2();
                this.bufferedResourcesByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)tail2));
                this.sendBufferedRequest(request2, remote);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void resourceFetched(Remote remote, Status status, boolean silent, boolean isHttp2) {
        this.pendingResourcesCount_$eq(this.pendingResourcesCount() - 1);
        if (!silent) {
            Status status2 = status;
            KO$ kO$ = KO$.MODULE$;
            if (!(status2 != null ? !status2.equals(kO$) : kO$ != null)) {
                this.globalStatus_$eq((Status)KO$.MODULE$);
            }
        }
        if (this.pendingResourcesCount() == 0) {
            this.done();
        } else {
            this.releaseTokenAndContinue(remote, isHttp2);
        }
    }

    private void cssFetched(Uri uri, Status status, HttpResponseStatus responseStatus, Option<String> lastModifiedOrEtag, String content) {
        block0: {
            List<HttpRequest> cssResources;
            Status status2 = status;
            OK$ oK$ = OK$.MODULE$;
            if ((status2 != null ? !status2.equals(oK$) : oK$ != null) || !(cssResources = this.resourceFetcher.cssFetched(uri, responseStatus, lastModifiedOrEtag, content, this.session(), this.throttled())).nonEmpty()) break block0;
            List filtered = (List)cssResources.filterNot((Function1 & Serializable & scala.Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)DefaultResourceAggregator.$anonfun$cssFetched$1(this, resource)));
            this.fetchOrBufferResources((Iterable<HttpRequest>)filtered);
        }
    }

    @Override
    public void onRegularResourceFetched(Uri uri, Status status, Session session, boolean silent) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Resource {} was fetched", new Object[]{uri});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.session_$eq(session);
        Remote remote = Remote$.MODULE$.apply(uri);
        this.resourceFetched(remote, status, silent, this.httpCaches.isHttp2PriorKnowledge(session, remote).contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    @Override
    public void onCssResourceFetched(Uri uri, Status status, Session session, boolean silent, HttpResponseStatus responseStatus, Option<String> lastModifiedOrEtag, String content) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Resource {} was fetched", new Object[]{uri});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.session_$eq(session);
        this.cssFetched(uri, status, responseStatus, lastModifiedOrEtag, content);
        Remote remote = Remote$.MODULE$.apply(uri);
        this.resourceFetched(remote, status, silent, this.httpCaches.isHttp2PriorKnowledge(session, remote).contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    @Override
    public void onRedirect(HttpTx originalTx, HttpTx redirectTx) {
        Remote redirectRemote;
        this.session_$eq(redirectTx.session());
        Uri originUri = originalTx.request().clientRequest().getUri();
        Remote originRemote = Remote$.MODULE$.apply(originUri);
        Uri redirectUri = redirectTx.request().clientRequest().getUri();
        Remote remote = redirectRemote = Remote$.MODULE$.apply(redirectUri);
        Remote remote2 = originRemote;
        if (!(remote != null ? !((Object)remote).equals(remote2) : remote2 != null)) {
            this.sendBufferedRequest(redirectTx.request(), redirectRemote);
        } else {
            this.releaseTokenAndContinue(originRemote, this.httpCaches.isHttp2PriorKnowledge(this.session(), originRemote).contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.availableTokensByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)redirectRemote), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)redirectRemote)) - 1))));
            if (BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)redirectRemote)) > 0) {
                this.sendBufferedRequest(redirectTx.request(), redirectRemote);
            } else {
                HttpRequest httpRequest = redirectTx.request();
                this.bufferedResourcesByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)redirectRemote), (Object)((List)this.bufferedResourcesByHost().apply((Object)redirectRemote)).$colon$colon((Object)httpRequest)));
            }
        }
    }

    @Override
    public void onCachedResource(Uri uri, HttpTx tx) {
        Remote remote = Remote$.MODULE$.apply(uri);
        this.resourceFetched(remote, (Status)OK$.MODULE$, tx.silent(), this.httpCaches.isHttp2PriorKnowledge(tx.session(), remote).contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    public static final /* synthetic */ boolean $anonfun$createResourceTx$1(boolean x$1) {
        return x$1;
    }

    private final void fetchAndBufferWithTokens$1(Remote remote, Iterable resources, Option isHttp2PriorKnowledge) {
        int availableTokens = BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)remote));
        Tuple2 tuple2 = resources.splitAt(availableTokens);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable immediate = (Iterable)tuple2._1();
        Iterable buffered = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)immediate, (Object)buffered);
        Tuple2 tuple23 = tuple22;
        Iterable immediate2 = (Iterable)tuple23._1();
        Iterable buffered2 = (Iterable)tuple23._2();
        this.fetchHttp1Resources$1(remote, immediate2, isHttp2PriorKnowledge);
        this.bufferResources$1(remote, buffered2);
    }

    private final void fetchHttp1Resources$1(Remote remote, Iterable resources, Option isHttp2PriorKnowledge) {
        this.availableTokensByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)remote)) - resources.size()))));
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            this.httpTxExecutor.execute(this.createResourceTx(resource, (Option<Object>)isHttp2PriorKnowledge));
            return BoxedUnit.UNIT;
        });
    }

    private final void bufferResources$1(Remote remote, Iterable resources) {
        List list = (List)this.bufferedResourcesByHost().apply((Object)remote);
        this.bufferedResourcesByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)resources.toList().$colon$colon$colon(list)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$fetchOrBufferResources$3(DefaultResourceAggregator $this, HttpRequest resource) {
        Option<Object> option;
        Some some;
        ContentCacheEntry contentCacheEntry;
        Request request = resource.clientRequest();
        Option<ContentCacheEntry> option2 = $this.httpCaches.contentCacheEntry($this.session(), request);
        if (None$.MODULE$.equals(option2)) {
            return false;
        }
        if (option2 instanceof Some && (contentCacheEntry = (ContentCacheEntry)(some = (Some)option2).value()) != null && None$.MODULE$.equals(option = contentCacheEntry.expires())) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        if (!(option2 instanceof Some)) return true;
        Some some2 = (Some)option2;
        ContentCacheEntry contentCacheEntry2 = (ContentCacheEntry)some2.value();
        if (contentCacheEntry2 == null) return true;
        Option<Object> option3 = contentCacheEntry2.expires();
        if (!(option3 instanceof Some)) return true;
        Some some3 = (Some)option3;
        long expire = BoxesRunTime.unboxToLong((Object)some3.value());
        if ($this.clock.nowMillis() <= expire) return true;
        $this.session_$eq($this.httpCaches.clearContentCache($this.session(), request));
        return false;
    }

    public static final /* synthetic */ void $anonfun$fetchOrBufferResources$6(DefaultResourceAggregator $this, Iterable resources$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Remote remote = (Remote)tuple2._1();
            Iterable res = (Iterable)tuple2._2();
            Option<Object> isHttp2PriorKnowledge = $this.httpCaches.isHttp2PriorKnowledge($this.session(), remote);
            if (isHttp2PriorKnowledge.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                $this.httpTxExecutor.execute((Iterable<HttpTx>)((Iterable)resources$1.map((Function1 & Serializable & scala.Serializable)x$8 -> $this.createResourceTx((HttpRequest)x$8, isHttp2PriorKnowledge), Iterable$.MODULE$.canBuildFrom())));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.fetchAndBufferWithTokens$1(remote, res, isHttp2PriorKnowledge);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$fetchOrBufferResources$8(DefaultResourceAggregator $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Remote remote = (Remote)tuple2._1();
        Iterable res = (Iterable)tuple2._2();
        $this.fetchAndBufferWithTokens$1(remote, res, (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$cssFetched$1(DefaultResourceAggregator $this, HttpRequest resource) {
        return $this.alreadySeen().contains((Object)resource.clientRequest().getUri());
    }

    public DefaultResourceAggregator(HttpTx rootTx, Seq<HttpRequest> initialResources, HttpCaches httpCaches, ResourceFetcher resourceFetcher, HttpTxExecutor httpTxExecutor, Clock clock, GatlingConfiguration configuration) {
        this.rootTx = rootTx;
        this.initialResources = initialResources;
        this.httpCaches = httpCaches;
        this.resourceFetcher = resourceFetcher;
        this.httpTxExecutor = httpTxExecutor;
        this.clock = clock;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        this.throttled = rootTx.request().requestConfig().throttled();
        this.httpProtocol = rootTx.request().requestConfig().httpProtocol();
        this.alreadySeen = Set$.MODULE$.empty();
        this.bufferedResourcesByHost = HashMap$.MODULE$.empty().withDefaultValue((Object)Nil$.MODULE$);
        this.maxConnectionsPerHost = this.httpProtocol().enginePart().maxConnectionsPerHost();
        this.availableTokensByHost = HashMap$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToInteger((int)this.maxConnectionsPerHost()));
        this.pendingResourcesCount = 0;
        this.globalStatus = OK$.MODULE$;
        this.startTimestamp = clock.nowMillis();
    }
}

