/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eventpoi;

import com.alibaba.fastjson.JSON;
import com.dc.eventpoi.core.PoiUtils;
import com.dc.eventpoi.core.entity.ExcelCell;
import com.dc.eventpoi.core.entity.ExcelRow;
import com.dc.eventpoi.core.entity.ExportExcelCell;
import com.dc.eventpoi.core.enums.FileType;
import com.dc.eventpoi.core.inter.CellStyleCallBack;
import com.dc.eventpoi.core.inter.ExcelEventStream;
import com.dc.eventpoi.core.inter.RowCallBack;
import com.dc.eventpoi.core.inter.SheetCallBack;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelHelper {
    public static byte[] exportExcel(byte[] tempExcelBtye, List<?> listAndTableDataList, Integer sheetIndex, SheetCallBack sheetCallBack, CellStyleCallBack callBackCellStyle) throws Exception {
        Object workbook = null;
        FileType fileType = PoiUtils.judgeFileType(new ByteArrayInputStream(tempExcelBtye));
        workbook = fileType == FileType.XLSX ? new XSSFWorkbook((InputStream)new ByteArrayInputStream(tempExcelBtye)) : (HSSFWorkbook)WorkbookFactory.create((InputStream)new ByteArrayInputStream(tempExcelBtye));
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook();
        int sheetStart = 0;
        int sheetEnd = workbook.getNumberOfSheets();
        if (sheetIndex != null) {
            sheetStart = sheetIndex;
            sheetEnd = sheetIndex + 1;
        }
        for (int i = sheetStart; i < sheetEnd; ++i) {
            SXSSFSheet sxssSheet = sxssfWorkbook.createSheet(workbook.getSheetName(i));
            if (sheetCallBack != null) {
                sheetCallBack.callBack(sxssSheet);
            }
            SXSSFDrawing patriarch = sxssSheet.createDrawingPatriarch();
            Sheet xsssheet = workbook.getSheetAt(i);
            int sheetMergerCount = xsssheet.getNumMergedRegions();
            int rowNum = xsssheet.getPhysicalNumberOfRows();
            int offset = 0;
            int listCount = 0;
            block1: for (int j = 0; j < rowNum; ++j) {
                for (int ii = 0; ii < sheetMergerCount; ++ii) {
                    CellRangeAddress mergedRegionAt = xsssheet.getMergedRegion(ii);
                    if (mergedRegionAt.getFirstRow() != j) continue;
                    mergedRegionAt.setFirstRow(mergedRegionAt.getFirstRow() + offset - listCount);
                    mergedRegionAt.setLastRow(mergedRegionAt.getLastRow() + offset - listCount);
                    sxssSheet.addMergedRegion(mergedRegionAt);
                }
                Row xssrow = xsssheet.getRow(j);
                int xssCellNum = xssrow.getPhysicalNumberOfCells();
                boolean breakFlag = false;
                SXSSFRow sxssrow = sxssSheet.createRow(j + offset - listCount);
                sxssrow.setHeight(xssrow.getHeight());
                for (int k = 0; k < xssCellNum; ++k) {
                    int temp_k = k;
                    if (breakFlag) continue block1;
                    Cell xssCell = xssrow.getCell(k);
                    sxssSheet.setColumnWidth(k, xsssheet.getColumnWidth(k));
                    if (xssCell == null) continue;
                    boolean matchFlag = false;
                    String xssCellValue = xssCell.getStringCellValue();
                    if (xssCellValue != null && xssCellValue.contains("${")) {
                        String keyName = xssCellValue.substring(xssCellValue.indexOf("${") + 2, xssCellValue.lastIndexOf("}"));
                        String excelFieldSrcKeyword = xssCellValue.substring(xssCellValue.indexOf("${"), xssCellValue.lastIndexOf("}") + 1);
                        for (Object dataObj : listAndTableDataList) {
                            if (matchFlag) break;
                            if (dataObj instanceof Collection) {
                                Object tempData;
                                List dataList = (List)dataObj;
                                if (dataList.size() <= 0 || FieldUtils.getField((tempData = dataList.get(0)).getClass(), (String)keyName, (boolean)true) == null) continue;
                                ArrayList<ExportExcelCell> keyCellList = new ArrayList<ExportExcelCell>();
                                for (int kk = k; kk < xssCellNum; ++kk) {
                                    Cell xssCell_kk = xssrow.getCell(kk);
                                    CellType type = xssCell_kk.getCellType();
                                    CellStyle _sxssStyle = sxssfWorkbook.createCellStyle();
                                    _sxssStyle.cloneStyleFrom(xssCell_kk.getCellStyle());
                                    ExportExcelCell ee = new ExportExcelCell((short)xssCell_kk.getColumnIndex(), xssCell_kk.getStringCellValue(), _sxssStyle);
                                    ee.setCellType(type);
                                    keyCellList.add(ee);
                                }
                                breakFlag = true;
                                matchFlag = true;
                                ++listCount;
                                int len = dataList.size();
                                for (int y = 0; y < len; ++y) {
                                    int create_row_num = j + offset;
                                    ++offset;
                                    Object srcData = dataList.get(y);
                                    SXSSFRow sxssrow_y = sxssSheet.createRow(create_row_num);
                                    sxssrow_y.setHeight(xssrow.getHeight());
                                    for (int x = temp_k; x < xssCellNum; ++x) {
                                        SXSSFCell _sxssCell;
                                        ExportExcelCell curCell = null;
                                        String vv = null;
                                        for (ExportExcelCell exportCell : keyCellList) {
                                            if (exportCell.getIndex() != x) continue;
                                            curCell = exportCell;
                                            vv = exportCell.getValue();
                                            break;
                                        }
                                        String _keyName = vv.substring(vv.indexOf("${") + 2, vv.lastIndexOf("}"));
                                        Field field = FieldUtils.getField(srcData.getClass(), (String)_keyName, (boolean)true);
                                        if (field != null && field.get(srcData) != null) {
                                            _sxssCell = sxssrow_y.createCell(x, curCell.getCellType());
                                            if (callBackCellStyle != null) {
                                                callBackCellStyle.callBack(sxssSheet, _sxssCell, curCell.getCellStyle());
                                                _sxssCell.setCellStyle(curCell.getCellStyle());
                                            } else {
                                                _sxssCell.setCellStyle(curCell.getCellStyle());
                                            }
                                            Object value = field.get(srcData);
                                            if (value instanceof byte[]) {
                                                if (PoiUtils.getImageType((byte[])value) != null) {
                                                    XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, 0, 0, x, sxssrow_y.getRowNum(), x + 1, sxssrow_y.getRowNum() + 1);
                                                    int picIndex = sxssfWorkbook.addPicture((byte[])value, 5);
                                                    patriarch.createPicture((ClientAnchor)anchor, picIndex);
                                                    continue;
                                                }
                                                _sxssCell.setCellValue(new String((byte[])value));
                                                continue;
                                            }
                                            _sxssCell.setCellValue(String.valueOf(value));
                                            continue;
                                        }
                                        _sxssCell = sxssrow_y.createCell(x, curCell.getCellType());
                                        if (callBackCellStyle != null) {
                                            callBackCellStyle.callBack(sxssSheet, _sxssCell, curCell.getCellStyle());
                                            _sxssCell.setCellStyle(curCell.getCellStyle());
                                        } else {
                                            _sxssCell.setCellStyle(curCell.getCellStyle());
                                        }
                                        _sxssCell.setCellValue("");
                                    }
                                }
                                continue;
                            }
                            Field field = FieldUtils.getField(dataObj.getClass(), (String)keyName, (boolean)true);
                            if (field == null) continue;
                            matchFlag = true;
                            SXSSFCell sxssCell = sxssrow.createCell(k, xssCell.getCellType());
                            CellStyle _sxssStyle = sxssfWorkbook.createCellStyle();
                            if (callBackCellStyle != null) {
                                _sxssStyle.cloneStyleFrom(xssCell.getCellStyle());
                                sxssCell.setCellStyle(_sxssStyle);
                                callBackCellStyle.callBack(sxssSheet, sxssCell, _sxssStyle);
                            } else {
                                _sxssStyle.cloneStyleFrom(xssCell.getCellStyle());
                                sxssCell.setCellStyle(_sxssStyle);
                            }
                            Object value = field.get(dataObj);
                            if (value instanceof byte[]) {
                                if (PoiUtils.getImageType((byte[])value) != null) {
                                    XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, 0, 0, k, sxssrow.getRowNum(), k + 1, sxssrow.getRowNum() + 1);
                                    int picIndex = sxssfWorkbook.addPicture((byte[])value, 5);
                                    patriarch.createPicture((ClientAnchor)anchor, picIndex);
                                    continue;
                                }
                                sxssCell.setCellValue(new String((byte[])value));
                                continue;
                            }
                            String cellValue = xssCellValue.replace(excelFieldSrcKeyword, String.valueOf(field.get(dataObj)));
                            sxssCell.setCellValue(cellValue);
                        }
                    }
                    if (matchFlag) continue;
                    SXSSFCell sxssCell = sxssrow.createCell(k, xssCell.getCellType());
                    String value = xssCell.getStringCellValue();
                    if (value != null && value.contains("${")) {
                        String excelFieldSrcKeyword = value.substring(value.indexOf("${"), value.lastIndexOf("}") + 1);
                        value = value.replace(excelFieldSrcKeyword, "");
                    }
                    CellStyle _sxssStyle = sxssfWorkbook.createCellStyle();
                    if (callBackCellStyle != null) {
                        _sxssStyle.cloneStyleFrom(xssCell.getCellStyle());
                        sxssCell.setCellStyle(_sxssStyle);
                        callBackCellStyle.callBack(sxssSheet, sxssCell, _sxssStyle);
                    } else {
                        _sxssStyle.cloneStyleFrom(xssCell.getCellStyle());
                        sxssCell.setCellStyle(_sxssStyle);
                    }
                    sxssCell.setCellValue(value);
                }
            }
        }
        workbook.close();
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        sxssfWorkbook.write((OutputStream)byteStream);
        byteStream.flush();
        byteStream.close();
        sxssfWorkbook.close();
        sxssfWorkbook.dispose();
        return byteStream.toByteArray();
    }

    public static <T> List<T> parseExcelToObject(InputStream excelDataSourceStream, InputStream excelTemplateStream, Class<T> clazz, boolean imageRead) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = excelDataSourceStream.read(buffer))) {
            output.write(buffer, 0, n);
        }
        HSSFWorkbook wb = null;
        Sheet sheet = null;
        FileType fileType = PoiUtils.judgeFileType(new ByteArrayInputStream(output.toByteArray()));
        switch (fileType) {
            case XLS: {
                wb = (HSSFWorkbook)WorkbookFactory.create((InputStream)new ByteArrayInputStream(output.toByteArray()));
                break;
            }
            case XLSX: {
                wb = new XSSFWorkbook((InputStream)new ByteArrayInputStream(output.toByteArray()));
                break;
            }
            default: {
                throw new Exception("filetype is unsupport");
            }
        }
        int sheetNumbers = wb.getNumberOfSheets();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        block9: for (int i = 0; i < sheetNumbers; ++i) {
            sheet = wb.getSheetAt(i);
            switch (fileType) {
                case XLS: {
                    map.putAll(PoiUtils.getXlsPictures(i, (HSSFSheet)sheet));
                    continue block9;
                }
                case XLSX: {
                    map.putAll(PoiUtils.getXlsxPictures(i, (XSSFSheet)sheet));
                    continue block9;
                }
                default: {
                    throw new Exception("filetype is unsupport");
                }
            }
        }
        wb.close();
        List<ExcelRow> dataList = ExcelHelper.parseExcelRowList(new ByteArrayInputStream(output.toByteArray()));
        List<ExcelRow> templeteList = ExcelHelper.parseExcelRowList(excelTemplateStream);
        ExcelHelper.checkTemplete(dataList, templeteList);
        if (map.size() > 0) {
            block10: for (ExcelRow excelRow : dataList) {
                int rowIndex = excelRow.getRowIndex();
                short sheetIndex = excelRow.getSheetIndex();
                List<ExcelCell> cellList = excelRow.getCellList();
                for (Map.Entry entry : map.entrySet()) {
                    int img_sheetIndex = Integer.parseInt(((String)entry.getKey()).split("-")[0]);
                    int img_rowIndex = Integer.parseInt(((String)entry.getKey()).split("-")[1]);
                    int img_cellIndex = Integer.parseInt(((String)entry.getKey()).split("-")[2]);
                    if (rowIndex != img_rowIndex || img_sheetIndex != sheetIndex) continue;
                    ExcelCell imgCell = new ExcelCell((Short)((short)img_sheetIndex), (byte[])entry.getValue());
                    cellList.add(img_cellIndex, imgCell);
                    continue block10;
                }
            }
        }
        return ExcelHelper.parseExcelToObject(dataList, templeteList, clazz);
    }

    public static <T> List<T> parseExcelToObject(InputStream excelDataSourceStream, InputStream excelTemplateStream, Class<T> clazz) throws Exception {
        List<ExcelRow> dataList = ExcelHelper.parseExcelRowList(excelDataSourceStream);
        List<ExcelRow> templeteList = ExcelHelper.parseExcelRowList(excelTemplateStream);
        ExcelHelper.checkTemplete(dataList, templeteList);
        return ExcelHelper.parseExcelToObject(dataList, templeteList, clazz);
    }

    public static <T> List<T> parseExcelToObject(List<ExcelRow> fileList, List<ExcelRow> templeteList, Class<T> clazz) throws Exception {
        ArrayList<T> rtn = new ArrayList<T>();
        List<Object> tempFieldList = new ArrayList();
        int size = fileList.size();
        int x = 0;
        int startRow = 0;
        for (int i = 0; i < templeteList.size(); ++i) {
            if (!templeteList.get(i).getCellList().get(0).getValue().startsWith("$")) continue;
            startRow = templeteList.get(i).getRowIndex();
            short sheetIndex = templeteList.get(i).getSheetIndex();
            tempFieldList = templeteList.get(i).getCellList();
            for (int j = x + startRow; j < size; ++j) {
                ExcelRow row = fileList.get(j);
                int rowIndex = row.getRowIndex();
                if (rowIndex < startRow || row.getSheetIndex() != sheetIndex) continue;
                ++x;
                T obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                List<ExcelCell> fieldList = row.getCellList();
                for (ExcelCell fieldCell : fieldList) {
                    block3: for (ExcelCell excelCell : tempFieldList) {
                        if (fieldCell.getIndex() != excelCell.getIndex()) continue;
                        for (Field field : FieldUtils.getAllFields(clazz)) {
                            if (Modifier.isStatic(field.getModifiers()) || !excelCell.getValue().contains(field.getName())) continue;
                            field.setAccessible(true);
                            if (fieldCell.getImgBytes() != null) {
                                field.set(obj, fieldCell.getImgBytes());
                                continue block3;
                            }
                            Object vall = PoiUtils.getValueByFieldType(fieldCell.getValue(), field.getType());
                            field.set(obj, vall);
                            continue block3;
                        }
                    }
                }
                rtn.add(obj);
            }
        }
        return rtn;
    }

    public static List<ExcelRow> parseExcelRowList(byte[] baytes) throws Exception {
        return ExcelHelper.parseExcelRowList(new ByteArrayInputStream(baytes));
    }

    public static List<ExcelRow> parseExcelRowList(byte[] baytes, Integer sheetIndex) throws Exception {
        return ExcelHelper.parseExcelRowList(new ByteArrayInputStream(baytes), sheetIndex);
    }

    public static List<ExcelRow> parseExcelRowList(File file, Integer sheetIndex) throws Exception {
        return ExcelHelper.parseExcelRowList(new FileInputStream(file), sheetIndex);
    }

    public static List<ExcelRow> parseExcelRowList(File file) throws Exception {
        return ExcelHelper.parseExcelRowList(new FileInputStream(file), null);
    }

    public static List<ExcelRow> parseExcelRowList(InputStream inputSrc, Integer sheetIndex) throws Exception {
        final ArrayList<ExcelRow> fileList = new ArrayList<ExcelRow>();
        try (ExcelEventStream fileStream = null;){
            fileStream = ExcelEventStream.readExcel(inputSrc);
            fileStream.sheetAt(sheetIndex).rowStream(new RowCallBack(){

                @Override
                public void getRow(ExcelRow row) {
                    fileList.add(row);
                }
            });
        }
        return fileList;
    }

    public static List<ExcelRow> parseExcelRowList(InputStream inputSrc) throws Exception {
        return ExcelHelper.parseExcelRowList(inputSrc, null);
    }

    public static void checkTemplete(List<ExcelRow> fileList, List<ExcelRow> templeteList) throws Exception {
        ExcelRow row;
        List<ExcelCell> excelCell;
        for (int i = 0; i < templeteList.size() && !(excelCell = (row = templeteList.get(i)).getCellList()).get(0).getValue().startsWith("${"); ++i) {
            if (JSON.toJSONString((Object)templeteList.get(i)).equals(JSON.toJSONString((Object)fileList.get(i)))) continue;
            throw new Exception("fileList is not the same as templeteList[\u8bfb\u53d6\u6587\u4ef6\u7684excel\u5934\u4fe1\u606f\u548c\u6a21\u677f\u5934\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u6587\u4ef6\u683c\u5f0f\u4e0d\u4e00\u81f4]");
        }
    }

    public static byte[] exportExcel(byte[] templete, List<?> listData, CellStyleCallBack callBackCellStyle) throws Exception {
        return ExcelHelper.exportExcel(templete, listData, 0, null, callBackCellStyle);
    }

    public static byte[] exportExcel(byte[] templete, List<?> listData, Integer sheetIndex) throws Exception {
        return ExcelHelper.exportExcel(templete, Arrays.asList(listData), sheetIndex, null, null);
    }

    public static byte[] exportExcel(byte[] templete, List<?> listAndTableDataList) throws Exception {
        return ExcelHelper.exportExcel(templete, Arrays.asList(listAndTableDataList), 0, null, null);
    }

    public static byte[] exportExcel(InputStream templeteStream, Object tableData) throws Exception {
        return ExcelHelper.exportExcel(PoiUtils.inputStreamToByte(templeteStream), Arrays.asList(tableData), 0, null, null);
    }

    public static byte[] exportExcel(byte[] templete, Object tableData) throws Exception {
        return ExcelHelper.exportExcel(templete, Arrays.asList(tableData), 0, null, null);
    }

    public static byte[] exportExcel(InputStream templeteStream, List<Object> listAndTableDataList, SheetCallBack sheetCallBack) throws Exception {
        return ExcelHelper.exportExcel(PoiUtils.inputStreamToByte(templeteStream), listAndTableDataList, null, sheetCallBack, null);
    }

    public static byte[] exportExcel(InputStream templeteStream, List<Object> listAndTableDataList, SheetCallBack sheetCallBack, CellStyleCallBack callBackCellStyle) throws Exception {
        return ExcelHelper.exportExcel(PoiUtils.inputStreamToByte(templeteStream), listAndTableDataList, null, sheetCallBack, callBackCellStyle);
    }

    public static byte[] exportExcel(InputStream templeteStream, List<Object> listAndTableDataList, CellStyleCallBack callBackCellStyle) throws Exception {
        return ExcelHelper.exportExcel(PoiUtils.inputStreamToByte(templeteStream), listAndTableDataList, null, null, callBackCellStyle);
    }

    public static byte[] exportExcel(InputStream templeteStream, List<Object> listAndTableDataList, Integer sheetIndex) throws Exception {
        return ExcelHelper.exportExcel(PoiUtils.inputStreamToByte(templeteStream), listAndTableDataList, sheetIndex, null, null);
    }

    public static byte[] exportExcel(InputStream templeteStream, List<Object> listAndTableDataList) throws Exception {
        return ExcelHelper.exportExcel(PoiUtils.inputStreamToByte(templeteStream), listAndTableDataList, 0, null, null);
    }
}

