/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eventpoi.core;

import com.dc.eventpoi.core.BaseExcelStream;
import com.dc.eventpoi.core.entity.ExcelCell;
import com.dc.eventpoi.core.entity.ExcelRow;
import com.dc.eventpoi.core.inter.BaseCallBack;
import com.dc.eventpoi.core.inter.ExcelEventStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ExcelXlsStream
extends BaseExcelStream
implements ExcelEventStream {
    private POIFSFileSystem poifs;
    private InputStream din;
    private HSSFRequest req;
    private HSSFEventFactory factory;
    private BaseCallBack baseCallBack;
    private short sheetIndex = 0;
    private HSSFListener listener = new HSSFListener(){
        private byte eofNum = 0;
        private int curRowIndex = 0;
        private List<ExcelCell> valueList = new ArrayList<ExcelCell>();
        private SSTRecord sstrec;

        public void eventHandle(int rowIndex, ExcelCell excelCell) {
            ExcelRow excelRow;
            if (excelCell == null) {
                if (ExcelXlsStream.this.allowSheet(ExcelXlsStream.this.sheetIndexArr, ExcelXlsStream.this.sheetIndex)) {
                    excelRow = new ExcelRow();
                    excelRow.setRowIndex(excelRow.getRowIndex());
                    excelRow.setSheetIndex(ExcelXlsStream.this.sheetIndex);
                    ExcelXlsStream.this.excuteCallBack(ExcelXlsStream.this.baseCallBack, excelRow);
                }
                ExcelXlsStream.access$008(ExcelXlsStream.this);
                this.curRowIndex = 0;
                this.valueList = new ArrayList<ExcelCell>();
            }
            if (rowIndex == this.curRowIndex) {
                this.valueList.add(excelCell);
            } else {
                excelRow = new ExcelRow();
                if (ExcelXlsStream.this.allowSheet(ExcelXlsStream.this.sheetIndexArr, ExcelXlsStream.this.sheetIndex)) {
                    excelRow.setCellList(this.valueList);
                    excelRow.setRowIndex(this.curRowIndex);
                    excelRow.setSheetIndex(ExcelXlsStream.this.sheetIndex);
                    ExcelXlsStream.this.excuteCallBack(ExcelXlsStream.this.baseCallBack, excelRow);
                }
                this.valueList = new ArrayList<ExcelCell>();
                this.valueList.add(excelCell);
                this.curRowIndex = rowIndex;
            }
        }

        public void processRecord(Record record) {
            switch (record.getSid()) {
                case 2057: {
                    break;
                }
                case 133: {
                    BoundSheetRecord bsr = (BoundSheetRecord)record;
                    ExcelXlsStream.this.sheetList.add(bsr.getSheetname());
                    break;
                }
                case 520: {
                    break;
                }
                case 515: {
                    NumberRecord numrec = (NumberRecord)record;
                    int rowNum1 = numrec.getRow();
                    short colNum1 = numrec.getColumn();
                    DecimalFormat decimalFormat = new DecimalFormat("###################.###########");
                    this.eventHandle(rowNum1, new ExcelCell((Short)colNum1, decimalFormat.format(numrec.getValue())));
                    break;
                }
                case 252: {
                    this.sstrec = (SSTRecord)record;
                    break;
                }
                case 253: {
                    LabelSSTRecord lrec = (LabelSSTRecord)record;
                    int rowNum2 = lrec.getRow();
                    short colNum2 = lrec.getColumn();
                    this.eventHandle(rowNum2, new ExcelCell((Short)colNum2, this.sstrec.getString(lrec.getSSTIndex()).getString()));
                    break;
                }
                case 516: {
                    LabelRecord lr = (LabelRecord)record;
                    int rowNum3 = lr.getRow();
                    short colNum3 = lr.getColumn();
                    this.eventHandle(rowNum3, new ExcelCell((Short)colNum3, lr.getValue()));
                    break;
                }
                case 513: {
                    break;
                }
                case 29: {
                    break;
                }
                case 10: {
                    if (ExcelXlsStream.this.sheetIndex + 1 == this.eofNum) {
                        this.eventHandle(0, null);
                    }
                    this.eofNum = (byte)(this.eofNum + 1);
                }
            }
        }
    };

    public boolean allowSheet(Integer[] sheetIndexArr, short sheetIndex) {
        if (sheetIndexArr == null) {
            return true;
        }
        Integer[] integerArray = sheetIndexArr;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int index = integerArray[i];
            if (index != sheetIndex) continue;
            return true;
        }
        return false;
    }

    public ExcelXlsStream(File file) throws Exception {
        this.fileStream = new FileInputStream(file);
    }

    public ExcelXlsStream(InputStream fileStream) {
        this.fileStream = fileStream;
    }

    public ExcelXlsStream(byte[] bytes) {
        this.fileStream = new ByteArrayInputStream(bytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws Exception {
        try {
            if (this.fileStream == null) return;
            this.fileStream.close();
            this.fileStream = null;
            return;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (this.poifs != null) {
                    this.poifs.close();
                    this.poifs = null;
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (this.din != null) {
                    this.din.close();
                }
                this.req = null;
                this.factory = null;
            }
        }
    }

    @Override
    public String getSheetName() {
        return (String)this.sheetList.get(this.sheetIndex);
    }

    @Override
    public void rowStream(BaseCallBack baseCallBack) throws Exception {
        this.baseCallBack = baseCallBack;
        this.processEvents();
    }

    private void processEvents() throws Exception {
        this.poifs = new POIFSFileSystem(this.fileStream);
        this.din = this.poifs.createDocumentInputStream("Workbook");
        this.req = new HSSFRequest();
        this.req.addListenerForAllRecords(this.listener);
        this.factory = new HSSFEventFactory();
        this.factory.processEvents(this.req, this.din);
    }

    @Override
    public short getSheetIndex() {
        return this.sheetIndex;
    }

    @Override
    public ExcelEventStream sheetAt(Integer ... sheetIndexArr) {
        this.sheetIndexArr = sheetIndexArr;
        return this;
    }

    static /* synthetic */ short access$008(ExcelXlsStream x0) {
        short s = x0.sheetIndex;
        x0.sheetIndex = (short)(s + 1);
        return s;
    }
}

