/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eventpoi.core;

import com.dc.eventpoi.core.BaseExcelStream;
import com.dc.eventpoi.core.entity.ExcelCell;
import com.dc.eventpoi.core.entity.ExcelRow;
import com.dc.eventpoi.core.enums.CellDataTypeEnum;
import com.dc.eventpoi.core.inter.BaseCallBack;
import com.dc.eventpoi.core.inter.ExcelEventStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ExcelXlsxStream
extends BaseExcelStream
implements ExcelEventStream {
    private OPCPackage pkg = null;
    private XSSFReader r = null;
    private SharedStringsTable sst = null;
    private XMLReader parser = null;
    private InputStream is = null;
    private XSSFReader.SheetIterator sheets = null;
    private short sheetIndex = 0;
    private String sheetName;
    private BaseCallBack baseCallBack;
    private List<String> sheetList = new ArrayList<String>();
    private DefaultHandler defaultHandler = new DefaultHandler(){
        private String lastContents;
        private CellDataTypeEnum cellDataType;
        private String cellNo;
        private int curRowNum = 0;
        private List<ExcelCell> valueList = new ArrayList<ExcelCell>();

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.lastContents = this.lastContents + new String(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("c")) {
                this.cellNo = attributes.getValue("r");
                this.cellDataType = CellDataTypeEnum.buildFromCellType(attributes.getValue("t"));
            }
            this.lastContents = "";
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (name.equals("v") || this.cellDataType == CellDataTypeEnum.IN_LINE_STR && name.equals("c")) {
                if (this.cellDataType == CellDataTypeEnum.EMPTY) {
                    this.lastContents = BigDecimal.valueOf(Double.parseDouble(this.lastContents)).stripTrailingZeros().toPlainString();
                } else {
                    Integer idx = Integer.valueOf(this.lastContents);
                    this.lastContents = ExcelXlsxStream.this.sst.getItemAt(idx.intValue()).toString();
                }
                String[] cellNoArr = ExcelXlsxStream.parseCellNo(this.cellNo);
                short cellNum = (short)(ExcelXlsxStream.excelColStrToNum(cellNoArr[0]) - 1);
                int rowNum = Integer.parseInt(cellNoArr[1]) - 1;
                if (this.curRowNum == rowNum) {
                    this.valueList.add(new ExcelCell((Short)cellNum, this.lastContents));
                } else {
                    ExcelRow excelRow = new ExcelRow();
                    excelRow.setRowIndex(this.curRowNum);
                    excelRow.setCellList(this.valueList);
                    excelRow.setSheetIndex(ExcelXlsxStream.this.sheetIndex);
                    ExcelXlsxStream.this.excuteCallBack(ExcelXlsxStream.this.baseCallBack, excelRow);
                    this.valueList = new ArrayList<ExcelCell>();
                    this.valueList.add(new ExcelCell((Short)cellNum, this.lastContents));
                    this.curRowNum = rowNum;
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.valueList.size() != 0) {
                ExcelRow excelRow = new ExcelRow();
                excelRow.setRowIndex(this.curRowNum);
                excelRow.setCellList(this.valueList);
                excelRow.setSheetIndex(ExcelXlsxStream.this.sheetIndex);
                ExcelXlsxStream.this.excuteCallBack(ExcelXlsxStream.this.baseCallBack, excelRow);
            }
            this.curRowNum = 0;
            this.valueList = new ArrayList<ExcelCell>();
        }
    };

    public ExcelXlsxStream(File file) throws Exception {
        this.fileStream = new FileInputStream(file);
    }

    public ExcelXlsxStream(InputStream fileStream) {
        this.fileStream = fileStream;
    }

    private static String[] parseCellNo(String cellNo) {
        String[] cellNoArr = new String[2];
        for (int i = 0; i < cellNo.length(); ++i) {
            char ch = cellNo.charAt(i);
            if (!Character.isDigit(ch)) continue;
            cellNoArr[0] = cellNo.substring(0, i);
            cellNoArr[1] = cellNo.substring(i);
            break;
        }
        return cellNoArr;
    }

    private static short excelColStrToNum(String colStr) {
        int len = colStr.length();
        short num = 0;
        short result = 0;
        for (int i = 0; i < len; ++i) {
            char ch = colStr.charAt(len - i - 1);
            num = (short)(ch - 65 + 1);
            num = (short)((double)num * Math.pow(26.0, i));
            result = (short)(result + num);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws Exception {
        try {
            if (this.is == null) return;
            this.is.close();
            this.is = null;
            return;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (this.sst != null) {
                    this.sst.close();
                    this.sst = null;
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    if (this.pkg != null) {
                        this.pkg.close();
                        this.pkg = null;
                    }
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    try {
                        if (this.fileStream != null) {
                            this.fileStream.close();
                            this.fileStream = null;
                        }
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    finally {
                        this.defaultHandler = null;
                        this.r = null;
                        this.parser = null;
                        this.sheets = null;
                    }
                }
            }
        }
    }

    @Override
    public void rowStream(BaseCallBack baseCallBack) throws Exception {
        this.baseCallBack = baseCallBack;
        this.parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        this.parser.setContentHandler(this.defaultHandler);
        this.pkg = OPCPackage.open((InputStream)this.fileStream);
        this.r = new XSSFReader(this.pkg);
        this.sst = this.r.getSharedStringsTable();
        this.sheets = (XSSFReader.SheetIterator)this.r.getSheetsData();
        if (this.sheetIndexArr == null || this.sheetIndexArr[0] == null) {
            while (this.sheets.hasNext()) {
                this.is = this.sheets.next();
                this.sheetName = this.sheets.getSheetName();
                this.sheetList.add(this.sheetName);
                this.parser.parse(new InputSource(this.is));
                this.sheetIndex = (short)(this.sheetIndex + 1);
            }
        } else {
            while (this.sheets.hasNext()) {
                this.is = this.sheets.next();
                this.sheetName = this.sheets.getSheetName();
                Integer[] integerArray = this.sheetIndexArr;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int index = integerArray[i];
                    if (index != this.sheetIndex) continue;
                    this.parser.parse(new InputSource(this.is));
                }
                this.sheetList.add(this.sheetName);
                this.sheetIndex = (short)(this.sheetIndex + 1);
            }
        }
    }

    @Override
    public ExcelEventStream sheetAt(Integer ... sheetIndexArr) {
        this.sheetIndexArr = sheetIndexArr;
        return this;
    }

    @Override
    public String getSheetName() {
        return this.sheetName;
    }

    @Override
    public short getSheetIndex() {
        return this.sheetIndex;
    }
}

