/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eventpoi.core;

import com.dc.eventpoi.ExcelHelper;
import com.dc.eventpoi.core.entity.ExcelCell;
import com.dc.eventpoi.core.entity.ExcelRow;
import com.dc.eventpoi.core.enums.FileType;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;

public class PoiUtils {
    public static FileType judgeFileType(InputStream inp) throws Exception {
        InputStream is = FileMagic.prepareToCheckMagic((InputStream)inp);
        FileMagic fm = FileMagic.valueOf((InputStream)is);
        switch (fm) {
            case OLE2: {
                return FileType.XLS;
            }
            case OOXML: {
                return FileType.XLSX;
            }
        }
        throw new IOException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static Map<String, byte[]> getXlsxPictures(int sheetIndex, XSSFSheet sheet) throws Exception {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        List list = sheet.getRelations();
        for (POIXMLDocumentPart part : list) {
            if (!(part instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)part;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                XSSFPicture picture = (XSSFPicture)shape;
                XSSFClientAnchor anchor = picture.getPreferredSize();
                CTMarker marker = anchor.getFrom();
                String key = sheetIndex + "-" + marker.getRow() + "-" + marker.getCol();
                map.put(key, picture.getPictureData().getData());
            }
        }
        return map;
    }

    public static Map<String, byte[]> getXlsPictures(int sheetIndex, HSSFSheet sheet) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        List list = sheet.getDrawingPatriarch().getChildren();
        for (HSSFShape shape : list) {
            if (!(shape instanceof HSSFPicture)) continue;
            HSSFPicture picture = (HSSFPicture)shape;
            HSSFClientAnchor cAnchor = picture.getClientAnchor();
            HSSFPictureData pdata = picture.getPictureData();
            String key = sheetIndex + "-" + cAnchor.getRow1() + "-" + cAnchor.getCol1();
            map.put(key, pdata.getData());
        }
        return map;
    }

    public static String getImageType(byte[] b10) {
        byte b0 = b10[0];
        byte b1 = b10[1];
        byte b2 = b10[2];
        byte b3 = b10[3];
        byte b6 = b10[6];
        byte b7 = b10[7];
        byte b8 = b10[8];
        byte b9 = b10[9];
        if (b0 == 71 && b1 == 73 && b2 == 70) {
            return "gif";
        }
        if (b1 == 80 && b2 == 78 && b3 == 71) {
            return "png";
        }
        if (b6 == 74 && b7 == 70 && b8 == 73 && b9 == 70) {
            return "jpg";
        }
        return null;
    }

    public static String getDateFormat(String str) {
        boolean year = false;
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        if (pattern.matcher(str.substring(0, 4)).matches()) {
            year = true;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        if (!year) {
            if (str.contains("\u6708") || str.contains("-") || str.contains("/")) {
                if (Character.isDigit(str.charAt(0))) {
                    index = 1;
                }
            } else {
                index = 3;
            }
        }
        for (int i = 0; i < str.length(); ++i) {
            char lastChar;
            char chr = str.charAt(i);
            if (Character.isDigit(chr)) {
                if (index == 0) {
                    sb.append("y");
                    continue;
                }
                if (index == 1) {
                    sb.append("M");
                    continue;
                }
                if (index == 2) {
                    sb.append("d");
                    continue;
                }
                if (index == 3) {
                    sb.append("H");
                    continue;
                }
                if (index == 4) {
                    sb.append("m");
                    continue;
                }
                if (index == 5) {
                    sb.append("s");
                    continue;
                }
                if (index != 6) continue;
                sb.append("S");
                continue;
            }
            if (i > 0 && Character.isDigit(lastChar = str.charAt(i - 1))) {
                ++index;
            }
            sb.append(chr);
        }
        return sb.toString();
    }

    public static Object getValueByFieldType(Object value, Class<?> fieldType) throws Exception {
        if (value == null) {
            return null;
        }
        String v = String.valueOf(value);
        String type = fieldType.getSimpleName();
        if (type.equals("String")) {
            return v;
        }
        if (v.trim().length() == 0) {
            return null;
        }
        if (type.equals("Integer") || type.equals("int")) {
            return Integer.parseInt(v);
        }
        if (type.equals("Long") || type.equals("long")) {
            return Long.parseLong(v);
        }
        if (type.equals("Double") || type.equals("double")) {
            return Double.parseDouble(v);
        }
        if (type.equals("Short") || type.equals("short")) {
            return Short.parseShort(v);
        }
        if (type.equals("Float") || type.equals("float")) {
            return Float.valueOf(Float.parseFloat(v));
        }
        if (type.equals("Byte") || type.equals("byte")) {
            return Byte.parseByte(v);
        }
        if (type.equals("Byte[]") || type.equals("byte[]")) {
            return v.getBytes();
        }
        if (type.equals("Boolean") || type.equals("boolean")) {
            return Boolean.parseBoolean(v);
        }
        if (type.equals("BigDecimal")) {
            return new BigDecimal(v);
        }
        if (type.equals("BigInteger")) {
            return new BigInteger(v);
        }
        if (type.equals("Date")) {
            SimpleDateFormat sdf = new SimpleDateFormat(PoiUtils.getDateFormat(v));
            sdf.setLenient(false);
            Date date = sdf.parse(v);
            return date;
        }
        throw new Exception(type + " is unsupported");
    }

    public static byte[] inputStreamToByte(InputStream is) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] a = new byte[1000];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = bis.read(a)) != -1) {
            bos.write(a, 0, len);
        }
        bis.close();
        bos.close();
        return bos.toByteArray();
    }

    public static <T> T getValueBy(List<ExcelCell> cellList, int cellIndex, Class<? extends T> returnClass) throws Exception {
        for (int i = 0; i < cellList.size(); ++i) {
            ExcelCell cell = cellList.get(i);
            if (cell.getIndex() != cellIndex) continue;
            return (T)PoiUtils.getValueByFieldType(cell.getValue(), returnClass);
        }
        return null;
    }

    public static String getValueBy(List<ExcelCell> cellList, int cellIndex) throws Exception {
        return PoiUtils.getValueBy(cellList, cellIndex, String.class);
    }

    public static <T> T getValueBy(List<ExcelRow> rowList, int rowIndex, int cellIndex, Class<? extends T> returnClass) throws Exception {
        ExcelRow row;
        for (int i = 0; i < rowList.size() && (row = rowList.get(i)).getRowIndex() <= rowIndex; ++i) {
            if (row.getRowIndex() != rowIndex) continue;
            List<ExcelCell> cellList = row.getCellList();
            for (int j = 0; j < cellList.size(); ++j) {
                ExcelCell cell = cellList.get(j);
                if (cell.getIndex() != cellIndex) continue;
                return (T)PoiUtils.getValueByFieldType(cell.getValue(), returnClass);
            }
        }
        return null;
    }

    public static String getValueBy(List<ExcelRow> rowList, int rowIndex, int cellIndex) throws Exception {
        return PoiUtils.getValueBy(rowList, rowIndex, cellIndex, String.class);
    }

    public static void deleteColumn(Sheet sheet, int columnToDeleteIndex) {
        for (int rId = 0; rId <= sheet.getLastRowNum(); ++rId) {
            Row row = sheet.getRow(rId);
            for (int cID = columnToDeleteIndex; cID < row.getLastCellNum(); ++cID) {
                Cell cNext;
                Cell cOld = row.getCell(cID);
                if (cOld != null) {
                    row.removeCell(cOld);
                }
                if ((cNext = row.getCell(cID + 1)) == null) continue;
                Cell cNew = row.createCell(cID, cNext.getCellType());
                PoiUtils.cloneCell(cNew, cNext);
                if (rId != 0) continue;
                sheet.setColumnWidth(cID, sheet.getColumnWidth(cID + 1));
            }
        }
    }

    public static void cloneCell(Cell cNew, Cell cOld) {
        cNew.setCellComment(cOld.getCellComment());
        cNew.setCellStyle(cOld.getCellStyle());
        if (CellType.BOOLEAN == cNew.getCellType()) {
            cNew.setCellValue(cOld.getBooleanCellValue());
        } else if (CellType.NUMERIC == cNew.getCellType()) {
            cNew.setCellValue(cOld.getNumericCellValue());
        } else if (CellType.STRING == cNew.getCellType()) {
            cNew.setCellValue(cOld.getStringCellValue());
        } else if (CellType.ERROR == cNew.getCellType()) {
            cNew.setCellValue((double)cOld.getErrorCellValue());
        } else if (CellType.FORMULA == cNew.getCellType()) {
            cNew.setCellValue(cOld.getCellFormula());
        }
    }

    public static byte[] deleteTemplateColumn(InputStream excelFileInput, String ... key) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        int n = 0;
        while (-1 != (n = excelFileInput.read(buff))) {
            output.write(buff, 0, n);
        }
        return PoiUtils.deleteTemplateColumn(output.toByteArray(), 0, key);
    }

    public static byte[] deleteTemplateColumn(InputStream excelFileInput, int sheetIndex, String ... keys) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        int n = 0;
        while (-1 != (n = excelFileInput.read(buff))) {
            output.write(buff, 0, n);
        }
        return PoiUtils.deleteTemplateColumn(output.toByteArray(), sheetIndex, keys);
    }

    public static byte[] deleteTemplateColumn(byte[] templateFile, String ... key) throws Exception {
        return PoiUtils.deleteTemplateColumn(templateFile, 0, key);
    }

    public static byte[] deleteTemplateColumn(byte[] templateFile, int sheetIndex, String ... keys) throws Exception {
        Workbook workbook = WorkbookFactory.create((InputStream)new ByteArrayInputStream(templateFile));
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        List<ExcelRow> rowList = ExcelHelper.parseExcelRowList(new ByteArrayInputStream(templateFile));
        for (String kk : keys) {
            for (ExcelRow row : rowList) {
                List<ExcelCell> cellList = row.getCellList();
                for (ExcelCell cell : cellList) {
                    if (!cell.getValue().equals(kk) || sheetIndex != row.getSheetIndex()) continue;
                    PoiUtils.deleteColumn(sheet, cell.getIndex().shortValue());
                }
            }
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        workbook.write((OutputStream)byteOut);
        byteOut.flush();
        byteOut.close();
        return byteOut.toByteArray();
    }

    public static byte[] deleteCol(InputStream templeteStream, String ... delCellKey) throws Exception {
        ByteArrayOutputStream templeteOutput = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        int n = 0;
        while (-1 != (n = templeteStream.read(buff))) {
            templeteOutput.write(buff, 0, n);
        }
        byte[] newTemPleteExcel = PoiUtils.deleteTemplateColumn(templeteOutput.toByteArray(), delCellKey);
        return newTemPleteExcel;
    }

    public static ByteArrayOutputStream deleteTempleteFormat(InputStream inputSrc, int sheetIndex) throws Exception {
        Workbook workbook = WorkbookFactory.create((InputStream)inputSrc);
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        int totalRow = sheet.getPhysicalNumberOfRows();
        block0: for (int i = sheet.getFirstRowNum(); i < totalRow; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            int totalCell = row.getPhysicalNumberOfCells();
            for (int j = row.getFirstCellNum(); j < totalCell; ++j) {
                String value;
                Cell cell = row.getCell(j);
                if (cell == null || (value = cell.getStringCellValue()) == null || !value.startsWith("${")) continue;
                sheet.removeRow(row);
                sheet.shiftRows(i + 1, i + 1 + 1, -1);
                continue block0;
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        workbook.write((OutputStream)os);
        os.flush();
        return os;
    }
}

