/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eventpoi.core.enums;

import java.util.HashMap;
import java.util.Map;

public enum CellDataTypeEnum {
    STRING,
    IN_LINE_STR,
    DIRECT_STRING,
    NUMBER,
    BOOLEAN,
    EMPTY,
    ERROR,
    IMAGE;

    private static final Map<String, CellDataTypeEnum> TYPE_ROUTING_MAP;

    public static CellDataTypeEnum buildFromCellType(String cellType) {
        if (cellType == null || cellType.equals("")) {
            return EMPTY;
        }
        return TYPE_ROUTING_MAP.get(cellType);
    }

    static {
        TYPE_ROUTING_MAP = new HashMap<String, CellDataTypeEnum>(16);
        TYPE_ROUTING_MAP.put("s", STRING);
        TYPE_ROUTING_MAP.put("str", DIRECT_STRING);
        TYPE_ROUTING_MAP.put("inlineStr", IN_LINE_STR);
        TYPE_ROUTING_MAP.put("e", ERROR);
        TYPE_ROUTING_MAP.put("b", BOOLEAN);
        TYPE_ROUTING_MAP.put("n", NUMBER);
    }
}

