/*
 * Decompiled with CFR 0.152.
 */
package com.dc.eventpoi.core.inter;

import com.dc.eventpoi.core.ExcelXlsStream;
import com.dc.eventpoi.core.ExcelXlsxStream;
import com.dc.eventpoi.core.PoiUtils;
import com.dc.eventpoi.core.enums.FileType;
import com.dc.eventpoi.core.inter.BaseCallBack;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;

public interface ExcelEventStream {
    public ExcelEventStream sheetAt(Integer ... var1);

    public String getSheetName();

    public void rowStream(BaseCallBack var1) throws Exception;

    public List<String> getSheetList();

    public short getSheetIndex();

    public void close() throws Exception;

    public static ExcelEventStream readExcel(File file) throws Exception {
        return ExcelEventStream.readExcel(new FileInputStream(file));
    }

    public static ExcelEventStream readExcel(byte[] bytes) throws Exception {
        return ExcelEventStream.readExcel(new ByteArrayInputStream(bytes));
    }

    public static ExcelEventStream readExcel(InputStream fileStream) throws Exception {
        FileType fileType = PoiUtils.judgeFileType(fileStream);
        switch (fileType) {
            case XLS: {
                return new ExcelXlsStream(fileStream);
            }
            case XLSX: {
                return new ExcelXlsxStream(fileStream);
            }
        }
        throw new Exception("filetype is unsupport");
    }
}

