/*
 * Decompiled with CFR 0.152.
 */
package iRpc.base;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SerializationUtil {
    private static Map<Class<?>, Schema<?>> cachedSchema = new ConcurrentHashMap();

    private SerializationUtil() {
    }

    private static <T> Schema<T> getSchema(Class<T> cls) {
        if (!cachedSchema.containsKey(cls)) {
            Schema schema = RuntimeSchema.getSchema(cls);
            cachedSchema.put(cls, schema);
            return schema;
        }
        return cachedSchema.get(cls);
    }

    public static <T> byte[] serialize(T obj) {
        Class<?> cls = obj.getClass();
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            Schema<?> schema = SerializationUtil.getSchema(cls);
            byte[] byArray = ProtostuffIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
            return byArray;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            buffer.clear();
        }
    }

    public static <T> T deserialize(byte[] data, Class<T> cls) {
        try {
            Schema<T> schema = SerializationUtil.getSchema(cls);
            Object message = schema.newMessage();
            ProtostuffIOUtil.mergeFrom((byte[])data, (Object)message, schema);
            return (T)message;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

