/*
 * Decompiled with CFR 0.152.
 */
package iRpc.base.messageDeal;

import iRpc.base.IRpcContext;
import iRpc.base.messageDeal.IMessageSender;
import iRpc.base.processor.IProcessor;
import iRpc.cache.CommonLocalCache;
import iRpc.dataBridge.IDataSend;
import iRpc.dataBridge.RequestData;
import iRpc.dataBridge.ResponseData;
import iRpc.dataBridge.SendData;
import iRpc.dataBridge.vote.HeartBeatResponse;
import iRpc.dataBridge.vote.VoteResponse;
import iRpc.util.CommonUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class MessageSender
implements IMessageSender {
    private static <R, T> R synMessageSend(T msg, int timeout) {
        if (msg instanceof SendData) {
            final SendData sendData = (SendData)msg;
            Channel channel = ((SendData)msg).getChannel();
            channel.writeAndFlush(msg).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        CommonLocalCache.RetCache.putRet(((IDataSend)sendData.getData()).getRequestNum(), new ResponseData(((IDataSend)sendData.getData()).getRequestNum(), 500));
                    } else {
                        CommonLocalCache.AsynTaskCache.putAsynTask(((IDataSend)sendData.getData()).getRequestNum(), new IProcessor(){

                            @Override
                            public void run(ResponseData ret) {
                                CommonLocalCache.RetCache.putRet(ret.getResponseNum(), ret);
                            }
                        });
                    }
                }
            });
            int index = timeout / 100 + (timeout % 100 == 0 ? 0 : 1);
            while (CommonLocalCache.RetCache.getRet(((IDataSend)sendData.getData()).getRequestNum()) == null && index-- > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return (R)CommonLocalCache.RetCache.getRet(((IDataSend)sendData.getData()).getRequestNum());
        }
        return null;
    }

    private static boolean asynMessageSend(final SendData<IDataSend> msg, final IProcessor task) {
        Channel channel = msg.getChannel();
        if (channel == null) {
            return false;
        }
        channel.writeAndFlush(msg).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    CommonLocalCache.AsynTaskCache.putAsynTask(((IDataSend)msg.getData()).getRequestNum(), task);
                }
            }
        });
        return true;
    }

    private static ResponseData synMessageSend2Server(int msgType, IDataSend data, int timeout, String channelName) {
        Channel channel;
        Channel channel2 = channel = channelName.startsWith("cliChannel_") ? CommonLocalCache.ClientChannelCache.getChannel(channelName) : CommonLocalCache.ChannelCache.getChannel(channelName);
        if (channel == null) {
            return new ResponseData(data.getRequestNum(), 500);
        }
        ResponseData ret = (ResponseData)MessageSender.synMessageSend(new SendData<IDataSend>(msgType, channel, data), timeout);
        return ret == null ? new ResponseData(data.getRequestNum(), 500) : ret;
    }

    private static boolean asynMessaSend2Server(int msgType, IDataSend data, IProcessor task, String channelName) {
        Channel channel;
        Channel channel2 = channel = channelName.startsWith("cliChannel_") ? CommonLocalCache.ClientChannelCache.getChannel(channelName) : CommonLocalCache.ChannelCache.getChannel(channelName);
        if (channel == null) {
            return false;
        }
        boolean suc = MessageSender.asynMessageSend(new SendData<IDataSend>(msgType, channel, data), task);
        return suc;
    }

    public static ResponseData synBaseMsgSend(boolean isBroadcast, String className, String methodName, Class<?>[] argsType, Object[] args, int timeout) {
        RequestData requestData = new RequestData();
        requestData.setBroadcast(isBroadcast);
        requestData.setRequestNum(String.valueOf(CommonUtil.getSeq()));
        requestData.setClassName(className);
        requestData.setMethodName(methodName);
        requestData.setParamTyps(argsType);
        requestData.setArgs(args);
        return MessageSender.synMessageSend2Server(1, requestData, timeout, IRpcContext.LeaderNode);
    }

    public static ResponseData synBaseMsgSend(boolean isBroadcast, String className, String methodName, int timeout) {
        RequestData requestData = new RequestData();
        requestData.setBroadcast(isBroadcast);
        requestData.setRequestNum(String.valueOf(CommonUtil.getSeq()));
        requestData.setClassName(className);
        requestData.setMethodName(methodName);
        return MessageSender.synMessageSend2Server(1, requestData, timeout, IRpcContext.LeaderNode);
    }

    public static ResponseData synBaseMsgSend(List<String> remoteChannelkey, boolean isBroadcast, String className, String methodName, int timeout) {
        String channelKey;
        RequestData requestData = new RequestData();
        requestData.setBroadcast(isBroadcast);
        requestData.setRequestNum(String.valueOf(CommonUtil.getSeq()));
        requestData.setClassName(className);
        requestData.setMethodName(methodName);
        ResponseData responseData = null;
        Iterator<String> iterator = remoteChannelkey.iterator();
        while (iterator.hasNext() && (responseData = MessageSender.synMessageSend2Server(1, requestData, timeout, channelKey = iterator.next())).getReturnCode() != 200) {
        }
        return responseData;
    }

    public static ResponseData synBaseMsgSend(boolean isBroadcast, String className, String methodName, Object[] args, int timeout) {
        RequestData requestData = new RequestData();
        requestData.setBroadcast(isBroadcast);
        requestData.setRequestNum(String.valueOf(CommonUtil.getSeq()));
        requestData.setClassName(className);
        requestData.setMethodName(methodName);
        requestData.setArgs(args);
        return MessageSender.synMessageSend2Server(1, requestData, timeout, IRpcContext.LeaderNode);
    }

    public static boolean asynBaseMsgSend(boolean isBroadcast, String className, String methodName, Class<?>[] argsType, Object[] args, IProcessor task) {
        RequestData requestData = new RequestData();
        requestData.setBroadcast(isBroadcast);
        requestData.setRequestNum(String.valueOf(CommonUtil.getSeq()));
        requestData.setClassName(className);
        requestData.setMethodName(methodName);
        requestData.setParamTyps(argsType);
        requestData.setArgs(args);
        return MessageSender.asynMessaSend2Server(1, requestData, task, IRpcContext.LeaderNode);
    }

    public static boolean asynBaseMsgSend(boolean isBroadcast, String className, String methodName, Object[] args, IProcessor task) {
        RequestData requestData = new RequestData();
        requestData.setBroadcast(isBroadcast);
        requestData.setRequestNum(String.valueOf(CommonUtil.getSeq()));
        requestData.setClassName(className);
        requestData.setMethodName(methodName);
        requestData.setArgs(args);
        return MessageSender.asynMessaSend2Server(1, requestData, task, IRpcContext.LeaderNode);
    }

    public static CompletableFuture<VoteResponse> vote(IDataSend sendData, String channelName) {
        final CompletableFuture<VoteResponse> future = new CompletableFuture<VoteResponse>();
        boolean isSuc = MessageSender.asynMessaSend2Server(2, sendData, new IProcessor(){

            @Override
            public void run(ResponseData ret) {
                VoteResponse voteResponse = (VoteResponse)ret.getData();
                if (ret.getReturnCode() == 200 && ret.getData() != null) {
                    future.complete(voteResponse);
                } else {
                    future.completeExceptionally(ret.getErroInfo());
                }
            }
        }, channelName);
        if (!isSuc) {
            future.completeExceptionally(new RuntimeException("data for vote send failed"));
        }
        return future;
    }

    public static CompletableFuture<HeartBeatResponse> heartBeat(IDataSend sendData, String channelName) {
        final CompletableFuture<HeartBeatResponse> future = new CompletableFuture<HeartBeatResponse>();
        boolean isSuc = MessageSender.asynMessaSend2Server(0, sendData, new IProcessor(){

            @Override
            public void run(ResponseData ret) {
                HeartBeatResponse heartBeatResponse = (HeartBeatResponse)ret.getData();
                if (ret.getReturnCode() == 200 && ret.getData() != null) {
                    future.complete(heartBeatResponse);
                } else {
                    future.completeExceptionally(ret.getErroInfo());
                }
            }
        }, channelName);
        if (!isSuc) {
            future.completeExceptionally(new RuntimeException("data for heartBeat send failed"));
        }
        return future;
    }
}

