/*
 * Decompiled with CFR 0.152.
 */
package iRpc.base.starter;

import iRpc.base.IRpcContext;
import iRpc.base.starter.ClusterInfoInterval;
import iRpc.base.starter.Istarter;
import iRpc.socketAware.RemoteClient;
import iRpc.util.CommonUtil;
import iRpc.util.YamlUtil;
import io.netty.util.TimerTask;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ClientStarter
implements Istarter {
    private String pathName;

    public ClientStarter() {
        this.pathName = "application3.yml";
        this.start();
    }

    public ClientStarter(String pathName) {
        this.pathName = pathName;
        this.start();
    }

    @Override
    public boolean start() {
        if (!IRpcContext.clientStarted.compareAndSet(false, true)) {
            throw new RuntimeException("ClientStarter is started once");
        }
        IRpcContext.yumInfo = YamlUtil.getTypePropertieMap(this.pathName);
        Map clientMap = (Map)IRpcContext.yumInfo.get("iRpcClient");
        if (clientMap != null) {
            boolean isCluster = clientMap.get("serverModCluster") == null ? false : Boolean.valueOf(String.valueOf(clientMap.get("serverModCluster")));
            List lists = (List)clientMap.get("serverNode");
            IRpcContext.LeaderNode = "cliChannel_" + ((Map)lists.get(0)).get("ip") + ":" + ((Map)lists.get(0)).get("port");
            final int retryTimes = clientMap.get("retryTimes") == null ? 3 : Integer.parseInt(String.valueOf(clientMap.get("retryTimes")));
            try {
                for (Map node : lists) {
                    final String ip = (String)node.get("ip");
                    final String port = String.valueOf(node.get("port"));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < retryTimes; ++i) {
                                RemoteClient remoteClient = new RemoteClient();
                                boolean isSuc = remoteClient.start(ip, Integer.parseInt(port), "cliChannel_" + String.format("%s:%s", ip, port));
                                if (!isSuc) {
                                    try {
                                        Thread.sleep(2000L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                    continue;
                                }
                                return;
                            }
                        }
                    }, String.format("Client4%s:%s", ip, port)).start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (isCluster) {
                CommonUtil.timer.newTimeout((TimerTask)new ClusterInfoInterval(), 2L, TimeUnit.SECONDS);
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean stop() {
        return false;
    }
}

