/*
 * Decompiled with CFR 0.152.
 */
package iRpc.base.starter;

import iRpc.base.IRpcContext;
import iRpc.base.messageDeal.MessageSender;
import iRpc.cache.CommonLocalCache;
import iRpc.dataBridge.ResponseData;
import iRpc.dataBridge.vote.ClusterInfo;
import iRpc.socketAware.RemoteClient;
import iRpc.util.CommonUtil;
import io.netty.channel.Channel;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClusterInfoInterval
implements TimerTask {
    private static Logger logger = LoggerFactory.getLogger(ClusterInfoInterval.class);
    private List<String> clientChannelKeys;

    ClusterInfoInterval() {
    }

    public void run(Timeout timeout) throws Exception {
        CommonUtil.timer.newTimeout((TimerTask)this, 2L, TimeUnit.SECONDS);
        this.getClusterInfo();
    }

    public void getClusterInfo() {
        Map clientMap = (Map)IRpcContext.yumInfo.get("client");
        final int retryTimes = clientMap.get("retryTimes") == null ? 3 : Integer.parseInt(String.valueOf(clientMap.get("retryTimes")));
        ArrayList<String> clientChannelKeys = new ArrayList<String>();
        if (IRpcContext.ClusterPeersInfo == null || IRpcContext.ClusterPeersInfo.isEmpty()) {
            clientChannelKeys.add(IRpcContext.LeaderNode);
        } else {
            Set<String> keys = IRpcContext.ClusterPeersInfo.keySet();
            for (String key : keys) {
                clientChannelKeys.add("cliChannel_" + IRpcContext.ClusterPeersInfo.get(key));
            }
        }
        ResponseData responseData = MessageSender.synBaseMsgSend(clientChannelKeys, false, "iRpc.vote.service.ClusterInfoService", "getClusterInfo", 2000);
        ClusterInfo clusterInfo = (ClusterInfo)responseData.getData();
        if (clusterInfo == null) {
            return;
        }
        IRpcContext.LeaderNode = "cliChannel_" + clusterInfo.getPeers().get(clusterInfo.getLeaderId());
        logger.debug("leaderNode\uff1a{}", (Object)("cliChannel_" + clusterInfo.getPeers().get(clusterInfo.getLeaderId())));
        IRpcContext.ClusterPeersInfo = clusterInfo.getPeers();
        Set<Map.Entry<String, String>> set = clusterInfo.getPeers().entrySet();
        for (Map.Entry<String, String> entry : set) {
            String addr = entry.getValue();
            Channel channel = CommonLocalCache.ClientChannelCache.getChannel("cliChannel_" + addr);
            if (channel != null) continue;
            final RemoteClient remoteClient = new RemoteClient();
            final String ip = addr.split(":")[0];
            final String port = addr.split(":")[1];
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < retryTimes; ++i) {
                        boolean isSuc = remoteClient.start(ip, Integer.parseInt(port), "cliChannel_" + String.format("%s:%s", ip, port));
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (!isSuc) continue;
                        return;
                    }
                }
            }, String.format("Client4%s:%s", ip, port)).start();
        }
    }

    public List<String> getClientChannelKeys() {
        return this.clientChannelKeys;
    }

    public void setClientChannelKeys(List<String> clientChannelKeys) {
        this.clientChannelKeys = clientChannelKeys;
    }
}

