/*
 * Decompiled with CFR 0.152.
 */
package iRpc.base.starter;

import iRpc.base.IRpcContext;
import iRpc.base.starter.ClusterExecutors;
import iRpc.base.starter.Istarter;
import iRpc.cache.CommonLocalCache;
import iRpc.socketAware.RemoteClient;
import iRpc.socketAware.RemoteServer;
import iRpc.util.YamlUtil;
import iRpc.vote.DLedgerConfig;
import iRpc.vote.DLedgerLeaderElector;
import iRpc.vote.MemberState;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStarter
implements Istarter {
    Logger logger = LoggerFactory.getLogger((String)"serverStarter");
    private String pathName;

    public ServerStarter() {
        this.pathName = "application3.yml";
        this.start();
        this.logger.info("the profile name is {}", (Object)this.pathName);
    }

    public ServerStarter(String pathName) {
        this.pathName = pathName;
        this.start();
        this.logger.info("the profile name is {}", (Object)pathName);
    }

    public boolean initLeaderElector(DLedgerConfig dLedgerConfig) {
        if (CommonLocalCache.BasicInfoCache.getProperty("elector") == null) {
            MemberState memberState = new MemberState(dLedgerConfig);
            DLedgerLeaderElector elector = new DLedgerLeaderElector(dLedgerConfig, memberState);
            CommonLocalCache.BasicInfoCache.putProperty("elector", elector);
            CommonLocalCache.BasicInfoCache.putProperty("memberState", memberState);
            elector.startup();
        }
        return true;
    }

    @Override
    public boolean start() {
        if (!IRpcContext.serverStarted.compareAndSet(false, true)) {
            return false;
        }
        Map<String, Object> map = YamlUtil.getTypePropertieMap(this.pathName);
        Map serverMap = (Map)map.get("iRpcServer");
        if (serverMap != null) {
            final String serverPort = String.valueOf(serverMap.get("serverPort"));
            final String heartbeat = String.valueOf(serverMap.get("heartbeat"));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        new RemoteServer().start(Integer.parseInt(serverPort), Integer.parseInt(heartbeat));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, String.format("iRpc_server:%s", serverPort)).start();
            if (serverMap.containsKey("ClusterNode")) {
                DLedgerConfig config = new DLedgerConfig();
                List lists = (List)serverMap.get("ClusterNode");
                StringBuffer sb = new StringBuffer();
                for (Map nodeInfo : lists) {
                    String nodeName = (String)nodeInfo.get("node");
                    final String ip = (String)nodeInfo.get("ip");
                    final String port = String.valueOf(nodeInfo.get("port"));
                    if (serverPort.equals(port)) {
                        config.setSelfId(nodeName);
                    }
                    sb.append(String.format("%s-%s:%s;", nodeName, ip, port));
                    ClusterExecutors.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            new RemoteClient().start(ip, Integer.parseInt(port), String.format("%s:%s", ip, port));
                        }
                    });
                }
                this.logger.info("cluster peers info {}", (Object)sb.substring(0, sb.length() - 1));
                config.setPeers(sb.substring(0, sb.length() - 1));
                this.initLeaderElector(config);
            }
        }
        return true;
    }

    @Override
    public boolean stop() {
        return false;
    }
}

