/*
 * Decompiled with CFR 0.152.
 */
package iRpc.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import iRpc.base.processor.IProcessor;
import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;

public class CommonLocalCache {
    public CommonLocalCache() {
        throw new AssertionError();
    }

    public static <T> Cache<String, T> newCaffeineCache(int timeout) {
        return Caffeine.newBuilder().expireAfterWrite((long)timeout, TimeUnit.SECONDS).initialCapacity(1000).maximumSize(10000L).build();
    }

    public static <T> Cache<String, T> newCaffeineCacheNoExpireTime() {
        return Caffeine.newBuilder().initialCapacity(1000).maximumSize(10000L).build();
    }

    public static class BasicInfoCache {
        private static Cache<String, Object> propertyCache = CommonLocalCache.newCaffeineCacheNoExpireTime();

        public static void putProperty(String key, Object value) {
            propertyCache.put((Object)key, value);
        }

        public static Object getProperty(String key) {
            return propertyCache.getIfPresent((Object)key);
        }
    }

    public static class AsynTaskCache {
        private static Cache<String, IProcessor> callTaskCache = CommonLocalCache.newCaffeineCache(60);

        public static void putAsynTask(String key, IProcessor task) {
            callTaskCache.put((Object)key, (Object)task);
        }

        public static IProcessor getAsynTask(String key) {
            return (IProcessor)callTaskCache.getIfPresent((Object)key);
        }
    }

    public static class ClientChannelCache {
        private static Cache<String, Channel> retCache = CommonLocalCache.newCaffeineCacheNoExpireTime();

        public static void putClientChannel(String key, Channel value) {
            retCache.put((Object)key, (Object)value);
        }

        public static Channel getChannel(String key) {
            return (Channel)retCache.getIfPresent((Object)key);
        }

        public static void removeChannel(String key) {
            retCache.invalidate((Object)key);
        }
    }

    public static class ChannelCache {
        private static Cache<String, Channel> retCache = CommonLocalCache.newCaffeineCacheNoExpireTime();

        public static void putRet(String key, Channel value) {
            retCache.put((Object)key, (Object)value);
        }

        public static Channel getChannel(String key) {
            return (Channel)retCache.getIfPresent((Object)key);
        }
    }

    public static class RetCache {
        private static Cache<String, Object> retCache = CommonLocalCache.newCaffeineCache(60);

        public static void putRet(String key, Object value) {
            retCache.put((Object)key, value);
        }

        public static Object getRet(String key) {
            return retCache.getIfPresent((Object)key);
        }
    }
}

