/*
 * Decompiled with CFR 0.152.
 */
package iRpc.socketAware;

import iRpc.cache.CommonLocalCache;
import iRpc.socketAware.IHolderHanders;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;

public abstract class IOTGateWacthDog
extends SimpleChannelInboundHandler<Object>
implements IHolderHanders,
TimerTask {
    private Bootstrap bootstrap;
    private String ip;
    private int port;
    private HashedWheelTimer timer;
    private boolean flag;
    private String channelName;

    public IOTGateWacthDog(Bootstrap bootstrap, String ip, int port, HashedWheelTimer timer, boolean flag, String channelName) {
        this.bootstrap = bootstrap;
        this.ip = ip;
        this.port = port;
        this.timer = timer;
        this.flag = flag;
        this.channelName = channelName;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.flag) {
            this.timer.newTimeout((TimerTask)this, 800L, TimeUnit.MILLISECONDS);
        } else {
            CommonLocalCache.ClientChannelCache.removeChannel(this.channelName);
        }
        ctx.fireChannelInactive();
    }

    public void run(Timeout timeout) throws Exception {
        ChannelFuture channelFuture = this.bootstrap.connect(this.ip, this.port);
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                boolean isSuc = future.isSuccess();
                if (isSuc) {
                    future.channel().pipeline().fireChannelActive();
                    CommonLocalCache.ChannelCache.putRet(IOTGateWacthDog.this.channelName, future.channel());
                } else {
                    future.channel().pipeline().fireChannelInactive();
                }
            }
        });
    }
}

