/*
 * Decompiled with CFR 0.152.
 */
package iRpc.socketAware;

import com.alibaba.fastjson.JSON;
import iRpc.base.IRpcContext;
import iRpc.base.concurrent.ThreadFactoryImpl;
import iRpc.base.messageDeal.MessageReciever;
import iRpc.base.messageDeal.MessageType;
import iRpc.base.processor.IProcessor;
import iRpc.cache.CommonLocalCache;
import iRpc.dataBridge.RecieveData;
import iRpc.dataBridge.ResponseData;
import iRpc.socketAware.IOTGateWacthDog;
import iRpc.socketAware.codec.RpcClientDecoder;
import iRpc.socketAware.codec.RpcClientEncoder;
import iRpc.util.CommonUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteClient {
    protected static Logger logger = LoggerFactory.getLogger(RemoteClient.class);
    private final Bootstrap bootstrap = new Bootstrap();
    private final EventLoopGroup eventLoopGroupWorker;
    private Channel channel;
    private Bootstrap singleBootstrap;
    private Object lock = new Object();

    public RemoteClient() {
        this.eventLoopGroupWorker = new NioEventLoopGroup(1, (ThreadFactory)new ThreadFactoryImpl("netty_rpc_client_", false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(final String ip, final int port, final String channelName) {
        ChannelFuture channelFuture;
        boolean isTryAgain;
        final ClientHandler clientHandler = new ClientHandler();
        boolean bl = isTryAgain = !channelName.startsWith("cliChannel_");
        if (this.singleBootstrap == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.singleBootstrap == null) {
                    this.singleBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroupWorker)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).option(ChannelOption.SO_SNDBUF, (Object)65535)).option(ChannelOption.SO_RCVBUF, (Object)65535)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                        public void initChannel(SocketChannel ch) throws Exception {
                            ch.pipeline().addLast(new IOTGateWacthDog(RemoteClient.this.bootstrap, ip, port, CommonUtil.timer, isTryAgain, channelName){

                                protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
                                    ctx.fireChannelRead(msg);
                                }

                                @Override
                                public ChannelHandler[] getChannelHandlers() {
                                    return new ChannelHandler[]{new RpcClientEncoder(), new RpcClientDecoder(), clientHandler};
                                }
                            }.getChannelHandlers());
                        }
                    });
                }
            }
        }
        if (channelName.startsWith("cliChannel_")) {
            channelFuture = this.singleBootstrap.connect(ip, port).awaitUninterruptibly();
            if (channelFuture.isSuccess()) {
                this.channel = channelFuture.channel();
                this.channel.attr(IRpcContext.ATTRIBUTEKEY_IRPC_CLIENT).set((Object)"iRpcClient");
                CommonLocalCache.ClientChannelCache.putClientChannel(channelName, this.channel);
                logger.info("rpc client is connect to server {}:{}", (Object)ip, (Object)port);
                return true;
            }
            logger.error("rpc client is connect to server {}:{} failed ", (Object)ip, (Object)port);
            return false;
        }
        while (true) {
            if ((channelFuture = this.singleBootstrap.connect(ip, port).awaitUninterruptibly()).isSuccess()) break;
            logger.error("cluster node {} connected failed ,try again later.....", (Object)String.format("%s:%s", ip, port));
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        logger.info("cluster node {} connected success", (Object)String.format("%s:%s", ip, port));
        this.channel = channelFuture.channel();
        CommonLocalCache.ChannelCache.putRet(channelName, this.channel);
        return true;
    }

    @ChannelHandler.Sharable
    class ClientHandler
    extends ChannelDuplexHandler {
        ClientHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof List) {
                List listData = (List)msg;
                int size = listData.size();
                for (int i = 0; i < size; ++i) {
                    RecieveData recieveData = (RecieveData)listData.get(i);
                    switch (MessageType.getMessageType(recieveData.getMsgType())) {
                        case BASE_MSG: 
                        case HEART_MSG: 
                        case VOTE_MMSG: {
                            final ResponseData responseData = (ResponseData)recieveData.getData();
                            MessageReciever.reciveMsg(new Runnable(){

                                @Override
                                public void run() {
                                    String responseNum = responseData.getResponseNum();
                                    IProcessor iProcessor = CommonLocalCache.AsynTaskCache.getAsynTask(responseNum);
                                    if (iProcessor != null) {
                                        iProcessor.run(responseData);
                                    } else {
                                        logger.error("\u8be5\u8fd4\u56de\u503c\u672a\u67e5\u8be2\u5230\u56de\u8c03\u65b9\u6cd5\uff1a{}", (Object)JSON.toJSONString((Object)responseData));
                                    }
                                }
                            });
                        }
                    }
                }
            }
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            RemoteClient.this.channel = ctx.channel();
            InetSocketAddress inetSocketAddress = (InetSocketAddress)RemoteClient.this.channel.remoteAddress();
            CommonLocalCache.ChannelCache.putRet(String.format("%s:%s", inetSocketAddress.getHostName(), String.valueOf(inetSocketAddress.getPort())), RemoteClient.this.channel);
        }
    }
}

