/*
 * Decompiled with CFR 0.152.
 */
package iRpc.socketAware;

import com.alibaba.fastjson.JSON;
import iRpc.base.concurrent.ThreadFactoryImpl;
import iRpc.base.exception.IRPCServerNotFound;
import iRpc.base.messageDeal.MessageType;
import iRpc.cache.CommonLocalCache;
import iRpc.dataBridge.RecieveData;
import iRpc.dataBridge.RequestData;
import iRpc.dataBridge.ResponseData;
import iRpc.dataBridge.SendData;
import iRpc.dataBridge.vote.HeartBeatRequest;
import iRpc.dataBridge.vote.HeartBeatResponse;
import iRpc.dataBridge.vote.VoteRequest;
import iRpc.dataBridge.vote.VoteResponse;
import iRpc.service.IRPCService;
import iRpc.socketAware.codec.RpcServerDecoder;
import iRpc.socketAware.codec.RpcServerEncoder;
import iRpc.vote.DLedgerLeaderElector;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServer {
    protected static Logger logger = LoggerFactory.getLogger(RemoteServer.class);
    private final ServerBootstrap bootstrap = new ServerBootstrap();
    private final EventLoopGroup eventLoopGroupWorker;
    private final EventLoopGroup eventLoopGroupBoss = new NioEventLoopGroup(1);

    public RemoteServer() {
        this.eventLoopGroupWorker = new NioEventLoopGroup(2, (ThreadFactory)new ThreadFactoryImpl("netty_RPC_selecter_", false));
    }

    public void start(int port, final int heartbeat) {
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.eventLoopGroupBoss, this.eventLoopGroupWorker).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).childOption(ChannelOption.TCP_NODELAY, (Object)true).option(ChannelOption.SO_SNDBUF, (Object)65535)).option(ChannelOption.SO_RCVBUF, (Object)65535)).localAddress((SocketAddress)new InetSocketAddress(port))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new RpcServerEncoder(), new RpcServerDecoder(), new IdleStateHandler(0, 0, heartbeat), new NettyConnetManageHandler(), new NettyServerHandler()});
            }
        });
        logger.info("server started at port: " + port);
        try {
            this.bootstrap.bind().sync();
        }
        catch (InterruptedException e1) {
            throw new RuntimeException("this.bootstrap.bind().sync() InterruptedException", e1);
        }
    }

    class NettyServerHandler
    extends SimpleChannelInboundHandler<Object> {
        NettyServerHandler() {
        }

        protected void channelRead0(final ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof List) {
                List listData = (List)msg;
                int size = listData.size();
                block7: for (int i = 0; i < size; ++i) {
                    final RecieveData recieveData = (RecieveData)listData.get(i);
                    switch (MessageType.getMessageType(recieveData.getMsgType())) {
                        case BASE_MSG: {
                            RequestData requestData = (RequestData)recieveData.getData();
                            ResponseData rpcResponse = new ResponseData(requestData.getRequestNum(), 200);
                            try {
                                Object data = this.handleRpcRquest(requestData);
                                rpcResponse.setData(data);
                            }
                            catch (Throwable throwable) {
                                rpcResponse.setReturnCode(500);
                                rpcResponse.setErroInfo(throwable);
                                logger.error("\u670d\u52a1\u6267\u884c\u5f02\u5e38", throwable);
                            }
                            SendData<ResponseData> sendData = new SendData<ResponseData>(recieveData.getMsgType(), rpcResponse);
                            ctx.writeAndFlush(sendData);
                            continue block7;
                        }
                        case HEART_MSG: {
                            logger.debug("\u670d\u52a1\u7aef\u6536\u5230\u5fc3\u8df3\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString(recieveData.getData()));
                            DLedgerLeaderElector elector4h = (DLedgerLeaderElector)CommonLocalCache.BasicInfoCache.getProperty("elector");
                            HeartBeatRequest heartBeatRequest4h = (HeartBeatRequest)recieveData.getData();
                            CompletableFuture<HeartBeatResponse> heartBeatResponseCompletableFuture = elector4h.handleHeartBeat(heartBeatRequest4h);
                            heartBeatResponseCompletableFuture.whenCompleteAsync((BiConsumer)new BiConsumer<HeartBeatResponse, Throwable>(){

                                @Override
                                public void accept(HeartBeatResponse heartBeatResponse, Throwable throwable) {
                                    ResponseData rpcResponse = new ResponseData(heartBeatResponse.getRequestNum(), 200);
                                    if (throwable != null) {
                                        rpcResponse.setReturnCode(500);
                                        rpcResponse.setErroInfo(throwable);
                                    } else {
                                        rpcResponse.setData(heartBeatResponse);
                                    }
                                    SendData<ResponseData> sendData = new SendData<ResponseData>(recieveData.getMsgType(), rpcResponse);
                                    ctx.writeAndFlush(sendData);
                                }
                            });
                            continue block7;
                        }
                        case VOTE_MMSG: {
                            logger.debug("\u670d\u52a1\u7aef\u6536\u5230\u9009\u4e3e\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString(recieveData.getData()));
                            DLedgerLeaderElector elector4v = (DLedgerLeaderElector)CommonLocalCache.BasicInfoCache.getProperty("elector");
                            VoteRequest voteRequest = (VoteRequest)recieveData.getData();
                            CompletableFuture<VoteResponse> completableFuture = elector4v.handleVote(voteRequest, false);
                            completableFuture.whenCompleteAsync((BiConsumer)new BiConsumer<VoteResponse, Throwable>(){

                                @Override
                                public void accept(VoteResponse voteResponse, Throwable throwable) {
                                    ResponseData rpcResponse = new ResponseData(voteResponse.getRequestNum(), 200);
                                    if (throwable != null) {
                                        rpcResponse.setReturnCode(500);
                                        rpcResponse.setErroInfo(throwable);
                                    } else {
                                        rpcResponse.setData(voteResponse);
                                    }
                                    logger.debug("\u670d\u52a1\u7aef\u5904\u7406\u5b8c\u6536\u5230\u7684\u9009\u4e3e\u6d88\u606f\u65f6\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)voteResponse));
                                    SendData<ResponseData> sendData = new SendData<ResponseData>(recieveData.getMsgType(), rpcResponse);
                                    ctx.writeAndFlush(sendData);
                                }
                            });
                        }
                    }
                }
            }
        }

        private Object handleRpcRquest(RequestData request) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(request.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IRPCServerNotFound("server not found\uff08ClassNotFoundException\uff09!", e);
            }
            Object data = null;
            Object[] args = request.getArgs();
            if (args == null || args.length == 0) {
                Method method = null;
                try {
                    method = clazz.getMethod(request.getMethodName(), new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IRPCServerNotFound("server not found\uff08NoSuchMethodException\uff09!", e);
                }
                if (clazz.isAnnotationPresent(IRPCService.class) || method.isAnnotationPresent(IRPCService.class)) {
                    try {
                        data = method.invoke(clazz.newInstance(), new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IRPCServerNotFound("server not found!", e);
                    }
                }
                throw new IRPCServerNotFound("server not found!");
            }
            int argsLen = args.length;
            Class[] clazzs = new Class[argsLen];
            if (request.getArgs() != null && request.getArgs().length > 0 && (request.getParamTyps() == null || request.getParamTyps().length < request.getArgs().length)) {
                for (int i = 0; i < argsLen; ++i) {
                    clazzs[i] = args[i].getClass();
                }
            } else {
                clazzs = request.getParamTyps();
            }
            Method method = null;
            try {
                method = clazz.getMethod(request.getMethodName(), clazzs);
            }
            catch (NoSuchMethodException e) {
                throw new IRPCServerNotFound("server not found\uff08NoSuchMethodException\uff09!", e);
            }
            if (clazz.isAnnotationPresent(IRPCService.class) || method.isAnnotationPresent(IRPCService.class)) {
                try {
                    data = method.invoke(clazz.newInstance(), request.getArgs());
                }
                catch (Exception e) {
                    throw new IRPCServerNotFound("server not found!", e);
                }
            } else {
                throw new IRPCServerNotFound("server not found!");
            }
            return data;
        }
    }

    class NettyConnetManageHandler
    extends ChannelDuplexHandler {
        NettyConnetManageHandler() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            IdleStateEvent evnet;
            if (evt instanceof IdleStateEvent && (evnet = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                ctx.channel().close();
            }
            ctx.fireUserEventTriggered(evt);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ctx.channel().close();
        }
    }
}

