/*
 * Decompiled with CFR 0.152.
 */
package iRpc.socketAware.codec;

import iRpc.base.SerializationUtil;
import iRpc.base.messageDeal.MessageType;
import iRpc.dataBridge.RecieveData;
import iRpc.dataBridge.ResponseData;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.internal.RecyclableArrayList;
import java.util.ArrayList;
import java.util.List;

public class RpcClientDecoder
extends ByteToMessageDecoder {
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        RecyclableArrayList list = RecyclableArrayList.newInstance();
        if (in.readableBytes() > 4) {
            int pos = in.readerIndex();
            short len = in.readShort();
            if (len <= in.readableBytes()) {
                int dataLen = len - 1;
                byte msgType = in.readByte();
                switch (MessageType.getMessageType(msgType)) {
                    case BASE_MSG: 
                    case HEART_MSG: 
                    case VOTE_MMSG: {
                        byte[] contentData = new byte[dataLen];
                        in.readBytes(contentData);
                        ResponseData responseData = SerializationUtil.deserialize(contentData, ResponseData.class);
                        RecieveData<ResponseData> recieveData = new RecieveData<ResponseData>(msgType, responseData);
                        list.add(recieveData);
                    }
                }
            } else {
                in.readerIndex(pos);
            }
        }
        if (list.size() > 0) {
            ArrayList data = new ArrayList(list.size());
            data.addAll(list);
            list.recycle();
            out.add(data);
        }
    }
}

