/*
 * Decompiled with CFR 0.152.
 */
package iRpc.socketAware.codec;

import iRpc.base.SerializationUtil;
import iRpc.base.messageDeal.MessageType;
import iRpc.dataBridge.RecieveData;
import iRpc.dataBridge.RequestData;
import iRpc.dataBridge.vote.HeartBeatRequest;
import iRpc.dataBridge.vote.VoteRequest;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.internal.RecyclableArrayList;
import java.util.ArrayList;
import java.util.List;

public class RpcServerDecoder
extends ByteToMessageDecoder {
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        RecyclableArrayList arrayList = RecyclableArrayList.newInstance();
        if (in.readableBytes() > 4) {
            int pos = in.readerIndex();
            short len = in.readShort();
            if (len <= in.readableBytes()) {
                int dataLen = len - 1;
                byte msgType = in.readByte();
                switch (MessageType.getMessageType(msgType)) {
                    case BASE_MSG: {
                        byte[] contentData = new byte[dataLen];
                        in.readBytes(contentData);
                        RequestData requestData = SerializationUtil.deserialize(contentData, RequestData.class);
                        RecieveData<RequestData> recieveData = new RecieveData<RequestData>(msgType, requestData);
                        arrayList.add(recieveData);
                        break;
                    }
                    case HEART_MSG: {
                        byte[] heartData = new byte[dataLen];
                        in.readBytes(heartData);
                        HeartBeatRequest heartBeatRequest = SerializationUtil.deserialize(heartData, HeartBeatRequest.class);
                        RecieveData<HeartBeatRequest> recieveHeartData = new RecieveData<HeartBeatRequest>(msgType, heartBeatRequest);
                        arrayList.add(recieveHeartData);
                        break;
                    }
                    case VOTE_MMSG: {
                        byte[] voteData = new byte[dataLen];
                        in.readBytes(voteData);
                        VoteRequest voteRequest = SerializationUtil.deserialize(voteData, VoteRequest.class);
                        RecieveData<VoteRequest> recieveVoteData = new RecieveData<VoteRequest>(msgType, voteRequest);
                        arrayList.add(recieveVoteData);
                    }
                }
            } else {
                in.readerIndex(pos);
            }
        }
        if (arrayList.size() > 0) {
            ArrayList list = new ArrayList(arrayList.size());
            list.addAll(arrayList);
            arrayList.recycle();
            out.add(list);
        }
    }
}

