/*
 * Decompiled with CFR 0.152.
 */
package iRpc.vote;

import com.alibaba.fastjson.JSON;
import iRpc.base.concurrent.ThreadFactoryImpl;
import iRpc.base.messageDeal.MessageSender;
import iRpc.dataBridge.vote.DLedgerResponseCode;
import iRpc.dataBridge.vote.HeartBeatRequest;
import iRpc.dataBridge.vote.HeartBeatResponse;
import iRpc.dataBridge.vote.VoteRequest;
import iRpc.dataBridge.vote.VoteResponse;
import iRpc.util.CommonUtil;
import iRpc.util.DLedgerUtils;
import iRpc.vote.DLedgerConfig;
import iRpc.vote.MemberState;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLedgerLeaderElector {
    private static Logger logger = LoggerFactory.getLogger(DLedgerLeaderElector.class);
    private Random random = new Random();
    private DLedgerConfig dLedgerConfig;
    private final MemberState memberState;
    private long lastLeaderHeartBeatTime = -1L;
    private long lastSendHeartBeatTime = -1L;
    private long lastSuccHeartBeatTime = -1L;
    private int heartBeatTimeIntervalMs = 2000;
    private int maxHeartBeatLeak = 3;
    private long nextTimeToRequestVote = -1L;
    private boolean needIncreaseTermImmediately = false;
    private int minVoteIntervalMs = 300;
    private int maxVoteIntervalMs = 1000;
    private List<RoleChangeHandler> roleChangeHandlers = new ArrayList<RoleChangeHandler>();
    private VoteResponse.ParseResult lastParseResult = VoteResponse.ParseResult.WAIT_TO_REVOTE;
    private long lastVoteCost = 0L;
    private StateMaintainer stateMaintainer = new StateMaintainer();
    private ExecutorService executorService = Executors.newFixedThreadPool(4, new ThreadFactoryImpl("dledgerLeaderElector_", false));
    private VoteRequest voteRequest;

    public DLedgerLeaderElector(DLedgerConfig dLedgerConfig, MemberState memberState) {
        this.dLedgerConfig = dLedgerConfig;
        this.memberState = memberState;
        this.refreshIntervals(dLedgerConfig);
    }

    public void startup() {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                DLedgerLeaderElector.this.stateMaintainer.start();
            }
        });
        for (RoleChangeHandler roleChangeHandler : this.roleChangeHandlers) {
            roleChangeHandler.startup();
        }
    }

    public void shutdown() {
        this.stateMaintainer.shutDown();
        for (RoleChangeHandler roleChangeHandler : this.roleChangeHandlers) {
            roleChangeHandler.shutdown();
        }
    }

    private void refreshIntervals(DLedgerConfig dLedgerConfig) {
        this.heartBeatTimeIntervalMs = dLedgerConfig.getHeartBeatTimeIntervalMs();
        this.maxHeartBeatLeak = dLedgerConfig.getMaxHeartBeatLeak();
        this.minVoteIntervalMs = dLedgerConfig.getMinVoteIntervalMs();
        this.maxVoteIntervalMs = dLedgerConfig.getMaxVoteIntervalMs();
    }

    private void maintainState() throws Exception {
        if (this.memberState.isLeader()) {
            this.maintainAsLeader();
        } else if (this.memberState.isFollower()) {
            this.maintainAsFollower();
        } else {
            this.maintainAsCandidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintainAsLeader() throws Exception {
        if (DLedgerUtils.elapsed(this.lastSendHeartBeatTime) > (long)this.heartBeatTimeIntervalMs) {
            String leaderId;
            long term;
            MemberState memberState = this.memberState;
            synchronized (memberState) {
                if (!this.memberState.isLeader()) {
                    return;
                }
                term = this.memberState.currTerm();
                leaderId = this.memberState.getLeaderId();
                this.lastSendHeartBeatTime = System.currentTimeMillis();
            }
            this.sendHeartbeats(term, leaderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintainAsFollower() {
        if (DLedgerUtils.elapsed(this.lastLeaderHeartBeatTime) > (long)(2 * this.heartBeatTimeIntervalMs)) {
            MemberState memberState = this.memberState;
            synchronized (memberState) {
                if (this.memberState.isFollower() && DLedgerUtils.elapsed(this.lastLeaderHeartBeatTime) > (long)(this.maxHeartBeatLeak * this.heartBeatTimeIntervalMs)) {
                    logger.info("[{}][HeartBeatTimeOut] lastLeaderHeartBeatTime: {} heartBeatTimeIntervalMs: {} lastLeader={}", new Object[]{this.memberState.getSelfId(), new Timestamp(this.lastLeaderHeartBeatTime), this.heartBeatTimeIntervalMs, this.memberState.getLeaderId()});
                    this.changeRoleToCandidate(this.memberState.currTerm());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintainAsCandidate() throws Exception {
        VoteResponse.ParseResult parseResult;
        long ledgerEndTerm;
        long ledgerEndIndex;
        long term;
        if (System.currentTimeMillis() < this.nextTimeToRequestVote && !this.needIncreaseTermImmediately) {
            return;
        }
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            if (!this.memberState.isCandidate()) {
                return;
            }
            if (this.lastParseResult == VoteResponse.ParseResult.WAIT_TO_VOTE_NEXT || this.needIncreaseTermImmediately) {
                long prevTerm = this.memberState.currTerm();
                term = this.memberState.nextTerm();
                System.err.println("\u6e05\u7a7a\u5f53\u524d\u8282\u70b9\u4e4b\u524d\u6295\u7968\uff0c\u5f53\u524dterm = " + term);
                logger.info("{}_[INCREASE_TERM] from {} to {}", new Object[]{this.memberState.getSelfId(), prevTerm, term});
                this.lastParseResult = VoteResponse.ParseResult.WAIT_TO_REVOTE;
            } else {
                term = this.memberState.currTerm();
            }
            ledgerEndIndex = this.memberState.getLedgerEndIndex();
            ledgerEndTerm = this.memberState.getLedgerEndTerm();
        }
        if (this.needIncreaseTermImmediately) {
            this.nextTimeToRequestVote = this.getNextTimeToRequestVote();
            this.needIncreaseTermImmediately = false;
            return;
        }
        long startVoteTimeMs = LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli();
        List<CompletableFuture<VoteResponse>> quorumVoteResponses = this.voteForQuorumResponses(term, ledgerEndTerm, ledgerEndIndex);
        AtomicLong knownMaxTermInGroup = new AtomicLong(-1L);
        AtomicInteger allNum = new AtomicInteger(0);
        AtomicInteger validNum = new AtomicInteger(0);
        AtomicInteger acceptedNum = new AtomicInteger(0);
        AtomicInteger notReadyTermNum = new AtomicInteger(0);
        AtomicInteger biggerLedgerNum = new AtomicInteger(0);
        AtomicBoolean alreadyHasLeader = new AtomicBoolean(false);
        CountDownLatch voteLatch = new CountDownLatch(1);
        for (CompletableFuture<VoteResponse> future : quorumVoteResponses) {
            future.whenComplete((x, ex) -> {
                try {
                    if (ex != null) {
                        logger.error("vote failed ", ex);
                        return;
                    }
                    logger.debug("[{}][\u6295\u7968\u56de\u8c03\u6267\u884c] {}", (Object)this.memberState.getSelfId(), (Object)JSON.toJSONString((Object)x));
                    if (x.getVoteResult() != VoteResponse.RESULT.UNKNOWN) {
                        validNum.incrementAndGet();
                    }
                    AtomicLong atomicLong = knownMaxTermInGroup;
                    synchronized (atomicLong) {
                        switch (x.getVoteResult()) {
                            case ACCEPT: {
                                acceptedNum.incrementAndGet();
                                break;
                            }
                            case REJECT_ALREADY_VOTED: {
                                break;
                            }
                            case REJECT_ALREADY__HAS_LEADER: {
                                alreadyHasLeader.compareAndSet(false, true);
                                break;
                            }
                            case REJECT_TERM_SMALL_THAN_LEDGER: 
                            case REJECT_EXPIRED_VOTE_TERM: {
                                if (x.getTerm() <= knownMaxTermInGroup.get()) break;
                                knownMaxTermInGroup.set(x.getTerm());
                                break;
                            }
                            case REJECT_EXPIRED_LEDGER_TERM: 
                            case REJECT_SMALL_LEDGER_END_INDEX: {
                                biggerLedgerNum.incrementAndGet();
                                break;
                            }
                            case REJECT_TERM_NOT_READY: {
                                notReadyTermNum.incrementAndGet();
                                break;
                            }
                        }
                    }
                    if (alreadyHasLeader.get() || this.memberState.isQuorum(acceptedNum.get()) || this.memberState.isQuorum(acceptedNum.get() + notReadyTermNum.get())) {
                        voteLatch.countDown();
                    }
                }
                catch (Throwable t) {
                    logger.error("Get error when parsing vote response ", t);
                }
                finally {
                    allNum.incrementAndGet();
                    if (allNum.get() == this.memberState.peerSize()) {
                        voteLatch.countDown();
                    }
                }
            });
        }
        try {
            voteLatch.await(3000 + this.random.nextInt(this.maxVoteIntervalMs), TimeUnit.MILLISECONDS);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.lastVoteCost = DLedgerUtils.elapsed(startVoteTimeMs);
        if (knownMaxTermInGroup.get() > term) {
            parseResult = VoteResponse.ParseResult.WAIT_TO_VOTE_NEXT;
            this.nextTimeToRequestVote = this.getNextTimeToRequestVote();
            this.changeRoleToCandidate(knownMaxTermInGroup.get());
        } else if (alreadyHasLeader.get()) {
            parseResult = VoteResponse.ParseResult.WAIT_TO_VOTE_NEXT;
            this.nextTimeToRequestVote = this.getNextTimeToRequestVote() + (long)(this.heartBeatTimeIntervalMs * this.maxHeartBeatLeak);
        } else if (!this.memberState.isQuorum(validNum.get())) {
            parseResult = VoteResponse.ParseResult.WAIT_TO_REVOTE;
            this.nextTimeToRequestVote = this.getNextTimeToRequestVote();
        } else if (this.memberState.isQuorum(acceptedNum.get())) {
            parseResult = VoteResponse.ParseResult.PASSED;
        } else if (this.memberState.isQuorum(acceptedNum.get() + notReadyTermNum.get())) {
            parseResult = VoteResponse.ParseResult.REVOTE_IMMEDIATELY;
        } else if (this.memberState.isQuorum(acceptedNum.get() + biggerLedgerNum.get())) {
            parseResult = VoteResponse.ParseResult.WAIT_TO_REVOTE;
            this.nextTimeToRequestVote = this.getNextTimeToRequestVote();
        } else {
            parseResult = VoteResponse.ParseResult.WAIT_TO_VOTE_NEXT;
            this.nextTimeToRequestVote = this.getNextTimeToRequestVote();
        }
        this.lastParseResult = parseResult;
        logger.debug("[{}] [\u6295\u7968\u7efc\u5408\u7ed3\u679c] cost={} term={} memberNum={} allNum={} acceptedNum={} notReadyTermNum={} biggerLedgerNum={} alreadyHasLeader={} maxTerm={} result={}", new Object[]{this.memberState.getSelfId(), this.lastVoteCost, term, this.memberState.peerSize(), allNum, acceptedNum, notReadyTermNum, biggerLedgerNum, alreadyHasLeader, knownMaxTermInGroup.get(), parseResult});
        if (parseResult == VoteResponse.ParseResult.PASSED) {
            logger.debug("[{}] [\u6295\u7968\u6700\u7ec8\u7ed3\u679c] has been elected to be the leader in term {}", (Object)this.memberState.getSelfId(), (Object)term);
            this.changeRoleToLeader(term);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeRoleToLeader(long term) {
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            if (this.memberState.currTerm() == term) {
                this.memberState.changeToLeader(term);
                this.lastSendHeartBeatTime = -1L;
                this.handleRoleChange(term, MemberState.Role.LEADER);
                logger.info("[{}] [ChangeRoleToLeader] from term: {} and currTerm: {}", new Object[]{this.memberState.getSelfId(), term, this.memberState.currTerm()});
            } else {
                logger.warn("[{}] skip to be the leader in term: {}, but currTerm is: {}", new Object[]{this.memberState.getSelfId(), term, this.memberState.currTerm()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeRoleToCandidate(long term) {
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            if (term >= this.memberState.currTerm()) {
                this.memberState.changeToCandidate(term);
                this.handleRoleChange(term, MemberState.Role.CANDIDATE);
                logger.info("[{}] [ChangeRoleToCandidate] from term: {} and currTerm: {}", new Object[]{this.memberState.getSelfId(), term, this.memberState.currTerm()});
            } else {
                logger.info("[{}] skip to be candidate in term: {}, but currTerm: {}", new Object[]{this.memberState.getSelfId(), term, this.memberState.currTerm()});
            }
        }
    }

    public void changeRoleToFollower(long term, String leaderId) {
        logger.info("[{}][ChangeRoleToFollower] from term: {} leaderId: {} and currTerm: {}", new Object[]{this.memberState.getSelfId(), term, leaderId, this.memberState.currTerm()});
        this.memberState.changeToFollower(term, leaderId);
        this.lastLeaderHeartBeatTime = System.currentTimeMillis();
        this.handleRoleChange(term, MemberState.Role.FOLLOWER);
    }

    private long getNextTimeToRequestVote() {
        return System.currentTimeMillis() + this.lastVoteCost + (long)this.minVoteIntervalMs + (long)this.random.nextInt(this.maxVoteIntervalMs - this.minVoteIntervalMs);
    }

    private void sendHeartbeats(long term, String leaderId) throws Exception {
        AtomicInteger allNum = new AtomicInteger(1);
        AtomicInteger succNum = new AtomicInteger(1);
        AtomicInteger notReadyNum = new AtomicInteger(0);
        AtomicLong maxTerm = new AtomicLong(-1L);
        AtomicBoolean inconsistLeader = new AtomicBoolean(false);
        CountDownLatch beatLatch = new CountDownLatch(1);
        long startHeartbeatTimeMs = System.currentTimeMillis();
        for (String id : this.memberState.getPeerMap().keySet()) {
            if (this.memberState.getSelfId().equals(id)) continue;
            HeartBeatRequest heartBeatRequest = new HeartBeatRequest();
            heartBeatRequest.setRequestNum(String.valueOf(CommonUtil.getSeq()));
            heartBeatRequest.setGroup(this.memberState.getGroup());
            heartBeatRequest.setLocalId(this.memberState.getSelfId());
            heartBeatRequest.setRemoteId(id);
            heartBeatRequest.setLeaderId(leaderId);
            heartBeatRequest.setTerm(term);
            CompletableFuture<HeartBeatResponse> future = MessageSender.heartBeat(heartBeatRequest, this.memberState.getPeerMap().get(id));
            future.whenComplete((x, ex) -> {
                try {
                    if (ex != null) {
                        throw ex;
                    }
                    switch (DLedgerResponseCode.valueOf(x.getCode())) {
                        case SUCCESS: {
                            succNum.incrementAndGet();
                            break;
                        }
                        case EXPIRED_TERM: {
                            maxTerm.set(x.getTerm());
                            break;
                        }
                        case INCONSISTENT_LEADER: {
                            inconsistLeader.compareAndSet(false, true);
                            break;
                        }
                        case TERM_NOT_READY: {
                            notReadyNum.incrementAndGet();
                            break;
                        }
                    }
                    if (this.memberState.isQuorum(succNum.get()) || this.memberState.isQuorum(succNum.get() + notReadyNum.get())) {
                        beatLatch.countDown();
                    }
                }
                catch (Throwable t) {
                    logger.error("Parse heartbeat response failed", t);
                }
                finally {
                    allNum.incrementAndGet();
                    if (allNum.get() == this.memberState.peerSize()) {
                        beatLatch.countDown();
                    }
                }
            });
        }
        beatLatch.await(this.heartBeatTimeIntervalMs, TimeUnit.MILLISECONDS);
        if (this.memberState.isQuorum(succNum.get())) {
            this.lastSuccHeartBeatTime = System.currentTimeMillis();
        } else {
            logger.debug("[{}] Parse heartbeat responses in cost={} term={} allNum={} succNum={} notReadyNum={} inconsistLeader={} maxTerm={} peerSize={} lastSuccHeartBeatTime={}", new Object[]{this.memberState.getSelfId(), DLedgerUtils.elapsed(startHeartbeatTimeMs), term, allNum.get(), succNum.get(), notReadyNum.get(), inconsistLeader.get(), maxTerm.get(), this.memberState.peerSize(), new Timestamp(this.lastSuccHeartBeatTime)});
            if (this.memberState.isQuorum(succNum.get() + notReadyNum.get())) {
                this.lastSendHeartBeatTime = -1L;
            } else if (maxTerm.get() > term) {
                this.changeRoleToCandidate(maxTerm.get());
            } else if (inconsistLeader.get()) {
                this.changeRoleToCandidate(term);
            } else if (DLedgerUtils.elapsed(this.lastSuccHeartBeatTime) > (long)(this.maxHeartBeatLeak * this.heartBeatTimeIntervalMs)) {
                this.changeRoleToCandidate(term);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<HeartBeatResponse> handleHeartBeat(HeartBeatRequest request) throws Exception {
        if (!this.memberState.isPeerMember(request.getLeaderId())) {
            logger.warn("[BUG] [HandleHeartBeat] remoteId={} is an unknown member", (Object)request.getLeaderId());
            return CompletableFuture.completedFuture(new HeartBeatResponse(request).term(this.memberState.currTerm()).code(DLedgerResponseCode.UNKNOWN_MEMBER.getCode()));
        }
        if (this.memberState.getSelfId().equals(request.getLeaderId())) {
            logger.warn("[BUG] [HandleHeartBeat] selfId={} but remoteId={}", (Object)this.memberState.getSelfId(), (Object)request.getLeaderId());
            return CompletableFuture.completedFuture(new HeartBeatResponse(request).term(this.memberState.currTerm()).code(DLedgerResponseCode.UNEXPECTED_MEMBER.getCode()));
        }
        if (request.getTerm() < this.memberState.currTerm()) {
            return CompletableFuture.completedFuture(new HeartBeatResponse(request).term(this.memberState.currTerm()).code(DLedgerResponseCode.EXPIRED_TERM.getCode()));
        }
        if (request.getTerm() == this.memberState.currTerm() && request.getLeaderId().equals(this.memberState.getLeaderId())) {
            this.lastLeaderHeartBeatTime = System.currentTimeMillis();
            return CompletableFuture.completedFuture(new HeartBeatResponse(request));
        }
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            if (request.getTerm() < this.memberState.currTerm()) {
                return CompletableFuture.completedFuture(new HeartBeatResponse(request).term(this.memberState.currTerm()).code(DLedgerResponseCode.EXPIRED_TERM.getCode()));
            }
            if (request.getTerm() == this.memberState.currTerm()) {
                if (this.memberState.getLeaderId() == null) {
                    this.changeRoleToFollower(request.getTerm(), request.getLeaderId());
                    return CompletableFuture.completedFuture(new HeartBeatResponse(request));
                }
                if (request.getLeaderId().equals(this.memberState.getLeaderId())) {
                    this.lastLeaderHeartBeatTime = System.currentTimeMillis();
                    return CompletableFuture.completedFuture(new HeartBeatResponse(request));
                }
                logger.error("[{}][BUG] currTerm {} has leader {}, but received leader {}", new Object[]{this.memberState.getSelfId(), this.memberState.currTerm(), this.memberState.getLeaderId(), request.getLeaderId()});
                return CompletableFuture.completedFuture(new HeartBeatResponse(request).code(DLedgerResponseCode.INCONSISTENT_LEADER.getCode()));
            }
            this.changeRoleToCandidate(request.getTerm());
            this.needIncreaseTermImmediately = true;
            return CompletableFuture.completedFuture(new HeartBeatResponse(request).code(DLedgerResponseCode.TERM_NOT_READY.getCode()));
        }
    }

    private List<CompletableFuture<VoteResponse>> voteForQuorumResponses(long term, long ledgerEndTerm, long ledgerEndIndex) throws Exception {
        ArrayList<CompletableFuture<VoteResponse>> responses = new ArrayList<CompletableFuture<VoteResponse>>();
        for (String id : this.memberState.getPeerMap().keySet()) {
            VoteRequest voteRequest = new VoteRequest();
            voteRequest.setRequestNum(String.valueOf(CommonUtil.getSeq()));
            voteRequest.setGroup(this.memberState.getGroup());
            voteRequest.setLedgerEndIndex(ledgerEndIndex);
            voteRequest.setLedgerEndTerm(ledgerEndTerm);
            voteRequest.setLeaderId(this.memberState.getSelfId());
            voteRequest.setTerm(term);
            voteRequest.setRemoteId(id);
            CompletableFuture<VoteResponse> voteResponse = null;
            voteResponse = this.memberState.getSelfId().equals(id) ? this.handleVote(voteRequest, true) : MessageSender.vote(voteRequest, this.memberState.getPeerMap().get(id));
            if (voteResponse == null) continue;
            responses.add(voteResponse);
        }
        return responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<VoteResponse> handleVote(VoteRequest request, boolean self) {
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            if (!this.memberState.isPeerMember(request.getLeaderId())) {
                logger.warn("[BUG] [HandleVote] remoteId={} is an unknown member", (Object)request.getLeaderId());
                return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_UNKNOWN_LEADER));
            }
            if (!self && this.memberState.getSelfId().equals(request.getLeaderId())) {
                logger.warn("[BUG] [HandleVote] selfId={} but remoteId={}", (Object)this.memberState.getSelfId(), (Object)request.getLeaderId());
                return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_UNEXPECTED_LEADER));
            }
            if (request.getTerm() < this.memberState.currTerm()) {
                return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_EXPIRED_VOTE_TERM));
            }
            if (request.getTerm() == this.memberState.currTerm()) {
                if (this.memberState.currVoteFor() != null && !this.memberState.currVoteFor().equals(request.getLeaderId())) {
                    if (this.memberState.getLeaderId() != null) {
                        return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_ALREADY__HAS_LEADER));
                    }
                    return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_ALREADY_VOTED));
                }
            } else {
                this.changeRoleToCandidate(request.getTerm());
                this.needIncreaseTermImmediately = true;
                return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_TERM_NOT_READY));
            }
            this.memberState.setCurrVoteFor(request.getLeaderId());
            return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.ACCEPT));
        }
    }

    private void handleRoleChange(long term, MemberState.Role role) {
        for (RoleChangeHandler roleChangeHandler : this.roleChangeHandlers) {
            try {
                roleChangeHandler.handle(term, role);
            }
            catch (Throwable t) {
                logger.warn("Handle role change failed term={} role={} handler={}", new Object[]{term, role, roleChangeHandler.getClass(), t});
            }
        }
    }

    public void addRoleChangeHandler(RoleChangeHandler roleChangeHandler) {
        if (!this.roleChangeHandlers.contains(roleChangeHandler)) {
            this.roleChangeHandlers.add(roleChangeHandler);
        }
    }

    public static interface RoleChangeHandler {
        public void handle(long var1, MemberState.Role var3);

        public void startup();

        public void shutdown();
    }

    public class StateMaintainer {
        private volatile boolean canbeRun = true;

        public boolean start() {
            this.canbeRun = true;
            this.doWork();
            return true;
        }

        public boolean shutDown() {
            this.canbeRun = false;
            return true;
        }

        public void doWork() {
            while (this.canbeRun) {
                try {
                    if (DLedgerLeaderElector.this.dLedgerConfig.isEnableLeaderElector()) {
                        DLedgerLeaderElector.this.refreshIntervals(DLedgerLeaderElector.this.dLedgerConfig);
                        DLedgerLeaderElector.this.maintainState();
                    }
                    Thread.sleep(10L);
                }
                catch (Throwable t) {
                    logger.error("Error in heartbeat", t);
                }
            }
        }
    }
}

